/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.PGConnectionImpl;
import com.impossibl.postgres.jdbc.SQLTypeUtils;
import com.impossibl.postgres.types.Type;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public class PGStruct
implements Struct {
    PGConnectionImpl connection;
    String typeName;
    Type[] attributeTypes;
    Object[] attributeValues;

    public PGStruct(PGConnectionImpl connection, String typeName, Type[] attributeTypes, Object[] values) {
        this.connection = connection;
        this.typeName = typeName;
        this.attributeTypes = attributeTypes;
        this.attributeValues = values;
    }

    public Type[] getAttributeTypes() {
        return this.attributeTypes;
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return this.typeName;
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        return this.getAttributes(this.connection.getTypeMap());
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> map) throws SQLException {
        Object[] newValues = new Object[this.attributeValues.length];
        for (int c = 0; c < this.attributeTypes.length; ++c) {
            Type attrType = this.attributeTypes[c];
            Class<?> targetType = SQLTypeUtils.mapGetType(attrType, map, this.connection);
            newValues[c] = SQLTypeUtils.coerce(this.attributeValues[c], attrType, targetType, map, this.connection);
        }
        return newValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PGStruct pgStruct = (PGStruct)o;
        return Objects.equals(this.connection, pgStruct.connection) && Objects.equals(this.typeName, pgStruct.typeName) && Arrays.equals(this.attributeTypes, pgStruct.attributeTypes) && Arrays.equals(this.attributeValues, pgStruct.attributeValues);
    }

    public int hashCode() {
        return Objects.hash(this.connection, this.typeName, this.attributeTypes, this.attributeValues);
    }
}

