/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.types;

import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.system.procs.Procs;
import com.impossibl.postgres.system.tables.PgAttribute;
import com.impossibl.postgres.system.tables.PgType;
import com.impossibl.postgres.types.Registry;
import com.impossibl.postgres.types.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class CompositeType
extends Type {
    private List<Attribute> attributes;

    public CompositeType(int id, String name, int arrayTypeId, String procName, Procs procs) {
        super(id, name, null, null, Type.Category.Composite, ',', arrayTypeId, procs.loadNamedBinaryCodec(procName, null), procs.loadNamedTextCodec(procName, null));
    }

    public CompositeType(int id, String name, int arrayTypeId, Procs procs) {
        this(id, name, arrayTypeId, "record_", procs);
    }

    public CompositeType() {
    }

    public Attribute getAttribute(int number) {
        if (number > 0 && number <= this.attributes.size() && this.attributes.get(number - 1).number == number) {
            return this.attributes.get(number - 1);
        }
        int sz = this.attributes.size();
        for (int c = 0; c < sz; ++c) {
            Attribute attr = this.attributes.get(c);
            if (attr.number != number) continue;
            return attr;
        }
        return null;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    public Type[] getAttributesTypes() {
        Type[] attributeTypes = new Type[this.attributes.size()];
        for (int c = 0; c < this.attributes.size(); ++c) {
            attributeTypes[c] = this.attributes.get(c).type;
        }
        return attributeTypes;
    }

    @Override
    public boolean isParameterFormatSupported(ResultField.Format format) {
        boolean allSupported = super.isParameterFormatSupported(format);
        for (Attribute attr : this.attributes) {
            allSupported &= attr.type.isParameterFormatSupported(format);
        }
        return allSupported;
    }

    @Override
    public boolean isResultFormatSupported(ResultField.Format format) {
        boolean allSupported = super.isResultFormatSupported(format);
        for (Attribute attr : this.attributes) {
            allSupported &= attr.type.isResultFormatSupported(format);
        }
        return allSupported;
    }

    @Override
    public Class<?> getJavaType(ResultField.Format format, Map<String, Class<?>> customizations) {
        Class<?> type;
        Class<?> clazz = type = customizations != null ? customizations.get(this.getNamespace() + "." + this.getName()) : null;
        if (type == null) {
            Class<?> clazz2 = type = customizations != null ? customizations.get(this.getName()) : null;
            if (type == null) {
                type = super.getJavaType(format, customizations);
            }
        }
        return type;
    }

    @Override
    public void load(PgType.Row pgType, Collection<PgAttribute.Row> pgAttrs, Registry registry) {
        super.load(pgType, pgAttrs, registry);
        if (pgAttrs == null) {
            this.attributes = Collections.emptyList();
        } else {
            this.attributes = new ArrayList<Attribute>(pgAttrs.size());
            for (PgAttribute.Row pgAttr : pgAttrs) {
                Type type = registry.loadType(pgAttr.getTypeId());
                Attribute attr = new Attribute(pgAttr.getNumber(), pgAttr.getName(), type, pgAttr.isNullable(), pgAttr.isAutoIncrement(), pgAttr.isHasDefault(), type != null ? type.getModifierParser().parse(pgAttr.getTypeModifier()) : Collections.emptyMap());
                this.attributes.add(attr);
            }
            Collections.sort(this.attributes, new Comparator<Attribute>(){

                @Override
                public int compare(Attribute o1, Attribute o2) {
                    int o1n = o1.number < 0 ? o1.number + Integer.MAX_VALUE : o1.number;
                    int o2n = o2.number < 0 ? o2.number + Integer.MAX_VALUE : o2.number;
                    return o1n - o2n;
                }
            });
        }
    }

    public static class Attribute {
        private int number;
        private String name;
        private Type type;
        private boolean nullable;
        private boolean autoIncrement;
        private boolean hasDefault;
        private Map<String, Object> typeModifiers;

        Attribute(int number, String name, Type type, boolean nullable, boolean autoIncrement, boolean hasDefault, Map<String, Object> typeModifiers) {
            this.number = number;
            this.name = name;
            this.type = type;
            this.nullable = nullable;
            this.autoIncrement = autoIncrement;
            this.hasDefault = hasDefault;
            this.typeModifiers = typeModifiers;
        }

        public int getNumber() {
            return this.number;
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public boolean isAutoIncrement() {
            return this.autoIncrement;
        }

        public boolean isHasDefault() {
            return this.hasDefault;
        }

        public Map<String, Object> getTypeModifiers() {
            return this.typeModifiers;
        }

        public String toString() {
            return this.name + " : " + this.type;
        }
    }
}

