/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.annotation;

import com.microsoft.applicationinsights.core.dependencies.annotation.AnnotationDetector;
import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.exception.ExceptionUtils;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;

public final class AnnotationPackageScanner {
    private AnnotationPackageScanner() {
    }

    public static List<String> scanForClassAnnotations(final Class<? extends Annotation>[] annotationsToSearch, String packageToScan) {
        final ArrayList<String> performanceModuleNames = new ArrayList<String>();
        AnnotationDetector.TypeReporter reporter = new AnnotationDetector.TypeReporter(){

            @Override
            public Class<? extends Annotation>[] annotations() {
                return annotationsToSearch;
            }

            @Override
            public void reportTypeAnnotation(Class<? extends Annotation> annotation, String className) {
                performanceModuleNames.add(className);
            }
        };
        AnnotationDetector annotationDetector = new AnnotationDetector(reporter);
        try {
            annotationDetector.detect(packageToScan);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            try {
                InternalLogger.INSTANCE.error("Failed to scan packages '%s': exception: '%s'", packageToScan, t.toString());
                InternalLogger.INSTANCE.trace("Stack trace generated is %s", ExceptionUtils.getStackTrace(t));
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return performanceModuleNames;
    }
}

