/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.FloatValue;
import org.apache.batik.css.engine.value.IdentifierManager;
import org.apache.batik.css.engine.value.Messages;
import org.apache.batik.css.engine.value.RGBColorValue;
import org.apache.batik.css.engine.value.StringMap;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public abstract class AbstractColorManager
extends IdentifierManager {
    protected static final StringMap values = new StringMap();
    protected static final StringMap computedValues;

    @Override
    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        if (lexicalUnit.getLexicalUnitType() == 27) {
            lexicalUnit = lexicalUnit.getParameters();
            Value value = this.createColorComponent(lexicalUnit);
            lexicalUnit = lexicalUnit.getNextLexicalUnit().getNextLexicalUnit();
            Value value2 = this.createColorComponent(lexicalUnit);
            lexicalUnit = lexicalUnit.getNextLexicalUnit().getNextLexicalUnit();
            Value value3 = this.createColorComponent(lexicalUnit);
            return this.createRGBColor(value, value2, value3);
        }
        return super.createValue(lexicalUnit, cSSEngine);
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        if (value.getPrimitiveType() == 21) {
            String string2 = value.getStringValue();
            Value value2 = (Value)computedValues.get(string2);
            if (value2 != null) {
                return value2;
            }
            if (values.get(string2) == null) {
                throw new IllegalStateException("Not a system-color:" + string2);
            }
            return cSSEngine.getCSSContext().getSystemColor(string2);
        }
        return super.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, value);
    }

    protected Value createRGBColor(Value value, Value value2, Value value3) {
        return new RGBColorValue(value, value2, value3);
    }

    protected Value createColorComponent(LexicalUnit lexicalUnit) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 13: {
                return new FloatValue(1, lexicalUnit.getIntegerValue());
            }
            case 14: {
                return new FloatValue(1, lexicalUnit.getFloatValue());
            }
            case 23: {
                return new FloatValue(2, lexicalUnit.getFloatValue());
            }
        }
        throw this.createInvalidRGBComponentUnitDOMException(lexicalUnit.getLexicalUnitType());
    }

    @Override
    public StringMap getIdentifiers() {
        return values;
    }

    private DOMException createInvalidRGBComponentUnitDOMException(short s2) {
        Object[] objectArray = new Object[]{this.getPropertyName(), new Integer(s2)};
        String string = Messages.formatMessage("invalid.rgb.component.unit", objectArray);
        return new DOMException(9, string);
    }

    static {
        values.put("aqua", ValueConstants.AQUA_VALUE);
        values.put("black", ValueConstants.BLACK_VALUE);
        values.put("blue", ValueConstants.BLUE_VALUE);
        values.put("fuchsia", ValueConstants.FUCHSIA_VALUE);
        values.put("gray", ValueConstants.GRAY_VALUE);
        values.put("green", ValueConstants.GREEN_VALUE);
        values.put("lime", ValueConstants.LIME_VALUE);
        values.put("maroon", ValueConstants.MAROON_VALUE);
        values.put("navy", ValueConstants.NAVY_VALUE);
        values.put("olive", ValueConstants.OLIVE_VALUE);
        values.put("purple", ValueConstants.PURPLE_VALUE);
        values.put("red", ValueConstants.RED_VALUE);
        values.put("silver", ValueConstants.SILVER_VALUE);
        values.put("teal", ValueConstants.TEAL_VALUE);
        values.put("white", ValueConstants.WHITE_VALUE);
        values.put("yellow", ValueConstants.YELLOW_VALUE);
        values.put("activeborder", ValueConstants.ACTIVEBORDER_VALUE);
        values.put("activecaption", ValueConstants.ACTIVECAPTION_VALUE);
        values.put("appworkspace", ValueConstants.APPWORKSPACE_VALUE);
        values.put("background", ValueConstants.BACKGROUND_VALUE);
        values.put("buttonface", ValueConstants.BUTTONFACE_VALUE);
        values.put("buttonhighlight", ValueConstants.BUTTONHIGHLIGHT_VALUE);
        values.put("buttonshadow", ValueConstants.BUTTONSHADOW_VALUE);
        values.put("buttontext", ValueConstants.BUTTONTEXT_VALUE);
        values.put("captiontext", ValueConstants.CAPTIONTEXT_VALUE);
        values.put("graytext", ValueConstants.GRAYTEXT_VALUE);
        values.put("highlight", ValueConstants.HIGHLIGHT_VALUE);
        values.put("highlighttext", ValueConstants.HIGHLIGHTTEXT_VALUE);
        values.put("inactiveborder", ValueConstants.INACTIVEBORDER_VALUE);
        values.put("inactivecaption", ValueConstants.INACTIVECAPTION_VALUE);
        values.put("inactivecaptiontext", ValueConstants.INACTIVECAPTIONTEXT_VALUE);
        values.put("infobackground", ValueConstants.INFOBACKGROUND_VALUE);
        values.put("infotext", ValueConstants.INFOTEXT_VALUE);
        values.put("menu", ValueConstants.MENU_VALUE);
        values.put("menutext", ValueConstants.MENUTEXT_VALUE);
        values.put("scrollbar", ValueConstants.SCROLLBAR_VALUE);
        values.put("threeddarkshadow", ValueConstants.THREEDDARKSHADOW_VALUE);
        values.put("threedface", ValueConstants.THREEDFACE_VALUE);
        values.put("threedhighlight", ValueConstants.THREEDHIGHLIGHT_VALUE);
        values.put("threedlightshadow", ValueConstants.THREEDLIGHTSHADOW_VALUE);
        values.put("threedshadow", ValueConstants.THREEDSHADOW_VALUE);
        values.put("window", ValueConstants.WINDOW_VALUE);
        values.put("windowframe", ValueConstants.WINDOWFRAME_VALUE);
        values.put("windowtext", ValueConstants.WINDOWTEXT_VALUE);
        computedValues = new StringMap();
        computedValues.put("black", ValueConstants.BLACK_RGB_VALUE);
        computedValues.put("silver", ValueConstants.SILVER_RGB_VALUE);
        computedValues.put("gray", ValueConstants.GRAY_RGB_VALUE);
        computedValues.put("white", ValueConstants.WHITE_RGB_VALUE);
        computedValues.put("maroon", ValueConstants.MAROON_RGB_VALUE);
        computedValues.put("red", ValueConstants.RED_RGB_VALUE);
        computedValues.put("purple", ValueConstants.PURPLE_RGB_VALUE);
        computedValues.put("fuchsia", ValueConstants.FUCHSIA_RGB_VALUE);
        computedValues.put("green", ValueConstants.GREEN_RGB_VALUE);
        computedValues.put("lime", ValueConstants.LIME_RGB_VALUE);
        computedValues.put("olive", ValueConstants.OLIVE_RGB_VALUE);
        computedValues.put("yellow", ValueConstants.YELLOW_RGB_VALUE);
        computedValues.put("navy", ValueConstants.NAVY_RGB_VALUE);
        computedValues.put("blue", ValueConstants.BLUE_RGB_VALUE);
        computedValues.put("teal", ValueConstants.TEAL_RGB_VALUE);
        computedValues.put("aqua", ValueConstants.AQUA_RGB_VALUE);
    }
}

