/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.parser.AngleParser;
import org.apache.batik.parser.DefaultAngleHandler;
import org.apache.batik.parser.ParseException;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGAngle;

public class SVGOMAngle
implements SVGAngle {
    private short unitType;
    protected float value;
    protected static final String[] UNITS = new String[]{"", "", "deg", "rad", "grad"};
    protected static double[][] K = new double[][]{{1.0, Math.PI / 180, 0.015707963267948967}, {57.29577951308232, 1.0, 63.66197723675813}, {0.9, 0.015707963267948967, 1.0}};

    @Override
    public short getUnitType() {
        this.revalidate();
        return this.unitType;
    }

    @Override
    public float getValue() {
        this.revalidate();
        return SVGOMAngle.toUnit(this.getUnitType(), this.value, (short)2);
    }

    @Override
    public void setValue(float f) throws DOMException {
        this.revalidate();
        this.setUnitType((short)2);
        this.value = f;
        this.reset();
    }

    @Override
    public float getValueInSpecifiedUnits() {
        this.revalidate();
        return this.value;
    }

    @Override
    public void setValueInSpecifiedUnits(float f) throws DOMException {
        this.revalidate();
        this.value = f;
        this.reset();
    }

    @Override
    public String getValueAsString() {
        this.revalidate();
        return Float.toString(this.value) + UNITS[this.getUnitType()];
    }

    @Override
    public void setValueAsString(String string) throws DOMException {
        this.parse(string);
        this.reset();
    }

    @Override
    public void newValueSpecifiedUnits(short s2, float f) {
        this.setUnitType(s2);
        this.value = f;
        this.reset();
    }

    @Override
    public void convertToSpecifiedUnits(short s2) {
        this.value = SVGOMAngle.toUnit(this.getUnitType(), this.value, s2);
        this.setUnitType(s2);
    }

    protected void reset() {
    }

    protected void revalidate() {
    }

    protected void parse(String string) {
        try {
            AngleParser angleParser = new AngleParser();
            angleParser.setAngleHandler(new DefaultAngleHandler(){

                @Override
                public void angleValue(float f) throws ParseException {
                    SVGOMAngle.this.value = f;
                }

                @Override
                public void deg() throws ParseException {
                    SVGOMAngle.this.setUnitType((short)2);
                }

                @Override
                public void rad() throws ParseException {
                    SVGOMAngle.this.setUnitType((short)3);
                }

                @Override
                public void grad() throws ParseException {
                    SVGOMAngle.this.setUnitType((short)4);
                }
            });
            this.setUnitType((short)1);
            angleParser.parse(string);
        }
        catch (ParseException parseException) {
            this.setUnitType((short)0);
            this.value = 0.0f;
        }
    }

    public static float toUnit(short s2, float f, short s3) {
        if (s2 == 1) {
            s2 = (short)2;
        }
        if (s3 == 1) {
            s3 = (short)2;
        }
        return (float)(K[s2 - 2][s3 - 2] * (double)f);
    }

    public void setUnitType(short s2) {
        this.unitType = s2;
    }
}

