/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javafx.scene.paint.Color;
import org.fxmisc.richtext.model.StyledSegment;
import org.fxmisc.richtext.model.SuperCodec;
import org.reactfx.util.Either;

public interface Codec<T> {
    public static final Codec<String> STRING_CODEC = new Codec<String>(){

        @Override
        public String getName() {
            return "string";
        }

        @Override
        public void encode(DataOutputStream os, String s2) throws IOException {
            os.writeUTF(s2);
        }

        @Override
        public String decode(DataInputStream is) throws IOException {
            return is.readUTF();
        }
    };
    public static final Codec<Color> COLOR_CODEC = new Codec<Color>(){

        @Override
        public String getName() {
            return "color";
        }

        @Override
        public void encode(DataOutputStream os, Color c) throws IOException {
            os.writeDouble(c.getRed());
            os.writeDouble(c.getGreen());
            os.writeDouble(c.getBlue());
            os.writeDouble(c.getOpacity());
        }

        @Override
        public Color decode(DataInputStream is) throws IOException {
            return Color.color((double)is.readDouble(), (double)is.readDouble(), (double)is.readDouble(), (double)is.readDouble());
        }
    };

    public String getName();

    public void encode(DataOutputStream var1, T var2) throws IOException;

    public T decode(DataInputStream var1) throws IOException;

    public static <SEG, S> Codec<StyledSegment<SEG, S>> styledSegmentCodec(final Codec<SEG> segCodec, final Codec<S> styleCodec) {
        return new Codec<StyledSegment<SEG, S>>(){

            @Override
            public String getName() {
                return "styled-segment<" + segCodec.getName() + ", " + styleCodec.getName() + ">";
            }

            @Override
            public void encode(DataOutputStream os, StyledSegment<SEG, S> styledSegment) throws IOException {
                segCodec.encode(os, styledSegment.getSegment());
                styleCodec.encode(os, styledSegment.getStyle());
            }

            @Override
            public StyledSegment<SEG, S> decode(DataInputStream is) throws IOException {
                Object seg = segCodec.decode(is);
                Object style = styleCodec.decode(is);
                return new StyledSegment(seg, style);
            }
        };
    }

    public static <S> Codec<StyledSegment<String, S>> styledTextCodec(final Codec<S> styleCodec) {
        return new Codec<StyledSegment<String, S>>(){

            @Override
            public String getName() {
                return "styled-text";
            }

            @Override
            public void encode(DataOutputStream os, StyledSegment<String, S> styledSeg) throws IOException {
                STRING_CODEC.encode(os, styledSeg.getSegment());
                styleCodec.encode(os, styledSeg.getStyle());
            }

            @Override
            public StyledSegment<String, S> decode(DataInputStream is) throws IOException {
                String text = STRING_CODEC.decode(is);
                Object style = styleCodec.decode(is);
                return new StyledSegment(text, style);
            }
        };
    }

    public static <T> Codec<List<T>> listCodec(Codec<T> elemCodec) {
        return SuperCodec.collectionListCodec(elemCodec);
    }

    public static <T> Codec<Collection<T>> collectionCodec(Codec<T> elemCodec) {
        return SuperCodec.upCast(SuperCodec.collectionListCodec(elemCodec));
    }

    public static <T> Codec<Optional<T>> optionalCodec(final Codec<T> elemCodec) {
        return new Codec<Optional<T>>(){

            @Override
            public String getName() {
                return "optional<" + elemCodec.getName() + ">";
            }

            @Override
            public void encode(DataOutputStream os, Optional<T> ot) throws IOException {
                if (ot.isPresent()) {
                    os.writeBoolean(true);
                    elemCodec.encode(os, ot.get());
                } else {
                    os.writeBoolean(false);
                }
            }

            @Override
            public Optional<T> decode(DataInputStream is) throws IOException {
                return is.readBoolean() ? Optional.of(elemCodec.decode(is)) : Optional.empty();
            }
        };
    }

    public static <E extends Enum<E>> Codec<E> enumCodec(final Class<E> enumType) {
        return new Codec<E>(){

            @Override
            public String getName() {
                return enumType.getSimpleName();
            }

            @Override
            public void encode(DataOutputStream os, E e) throws IOException {
                os.writeInt(((Enum)e).ordinal());
            }

            @Override
            public E decode(DataInputStream is) throws IOException {
                int ord = is.readInt();
                return ((Enum[])enumType.getEnumConstants())[ord];
            }
        };
    }

    public static <L, R> Codec<Either<L, R>> eitherCodec(final Codec<L> lCodec, final Codec<R> rCodec) {
        return new Codec<Either<L, R>>(){

            @Override
            public String getName() {
                return "either<" + lCodec.getName() + ", " + rCodec.getName() + ">";
            }

            @Override
            public void encode(DataOutputStream os, Either<L, R> e) throws IOException {
                if (e.isLeft()) {
                    os.writeBoolean(false);
                    lCodec.encode(os, e.getLeft());
                } else {
                    os.writeBoolean(true);
                    rCodec.encode(os, e.getRight());
                }
            }

            @Override
            public Either<L, R> decode(DataInputStream is) throws IOException {
                boolean isRight = is.readBoolean();
                return isRight ? Either.right(rCodec.decode(is)) : Either.left(lCodec.decode(is));
            }
        };
    }
}

