/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.actions;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.undo.UndoableEdit;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.actions.MnemonicAwareAction;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;

public class MassSetFieldAction
extends MnemonicAwareAction {
    private final JabRefFrame frame;
    private JDialog diag;
    private JRadioButton all;
    private JRadioButton selected;
    private JRadioButton clear;
    private JRadioButton set;
    private JRadioButton append;
    private JRadioButton rename;
    private JComboBox<String> field;
    private JTextField textFieldSet;
    private JTextField textFieldAppend;
    private JTextField textFieldRename;
    private boolean canceled = true;
    private JCheckBox overwrite;

    public MassSetFieldAction(JabRefFrame frame) {
        this.putValue("Name", Localization.menuTitle("Set/clear/append/rename fields", new String[0]) + "...");
        this.frame = frame;
    }

    private void createDialog() {
        this.diag = new JDialog(this.frame, Localization.lang("Set/clear/append/rename fields", new String[0]), true);
        this.field = new JComboBox();
        this.field.setEditable(true);
        this.textFieldSet = new JTextField();
        this.textFieldSet.setEnabled(false);
        this.textFieldAppend = new JTextField();
        this.textFieldAppend.setEnabled(false);
        this.textFieldRename = new JTextField();
        this.textFieldRename.setEnabled(false);
        JButton ok = new JButton(Localization.lang("OK", new String[0]));
        JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
        this.all = new JRadioButton(Localization.lang("All entries", new String[0]));
        this.selected = new JRadioButton(Localization.lang("Selected entries", new String[0]));
        this.clear = new JRadioButton(Localization.lang("Clear fields", new String[0]));
        this.set = new JRadioButton(Localization.lang("Set fields", new String[0]));
        this.append = new JRadioButton(Localization.lang("Append to fields", new String[0]));
        this.rename = new JRadioButton(Localization.lang("Rename field to", new String[0]) + ":");
        this.rename.setToolTipText(Localization.lang("Move contents of a field into a field with a different name", new String[0]));
        Set<String> allFields = this.frame.getCurrentBasePanel().getDatabase().getAllVisibleFields();
        for (String f : allFields) {
            this.field.addItem(f);
        }
        this.set.addChangeListener(e -> this.textFieldSet.setEnabled(this.set.isSelected()));
        this.append.addChangeListener(e -> {
            this.textFieldAppend.setEnabled(this.append.isSelected());
            this.overwrite.setEnabled(!this.clear.isSelected() && !this.append.isSelected());
        });
        this.clear.addChangeListener(e -> this.overwrite.setEnabled(!this.clear.isSelected() && !this.append.isSelected()));
        this.rename.addChangeListener(e -> this.textFieldRename.setEnabled(this.rename.isSelected()));
        this.overwrite = new JCheckBox(Localization.lang("Overwrite existing field values", new String[0]), true);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.all);
        bg.add(this.selected);
        bg = new ButtonGroup();
        bg.add(this.clear);
        bg.add(this.set);
        bg.add(this.append);
        bg.add(this.rename);
        FormBuilder builder = FormBuilder.create().layout(new FormLayout("left:pref, 4dlu, fill:100dlu:grow", "pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref, 2dlu, pref"));
        builder.addSeparator(Localization.lang("Field name", new String[0]), new Object[0]).xyw(1, 1, 3);
        builder.add(Localization.lang("Field name", new String[0]), new Object[0]).xy(1, 3);
        builder.add(this.field).xy(3, 3);
        builder.addSeparator(Localization.lang("Include entries", new String[0]), new Object[0]).xyw(1, 5, 3);
        builder.add(this.all).xyw(1, 7, 3);
        builder.add(this.selected).xyw(1, 9, 3);
        builder.addSeparator(Localization.lang("New field value", new String[0]), new Object[0]).xyw(1, 11, 3);
        builder.add(this.set).xy(1, 13);
        builder.add(this.textFieldSet).xy(3, 13);
        builder.add(this.clear).xyw(1, 15, 3);
        builder.add(this.append).xy(1, 17);
        builder.add(this.textFieldAppend).xy(3, 17);
        builder.add(this.rename).xy(1, 19);
        builder.add(this.textFieldRename).xy(3, 19);
        builder.add(this.overwrite).xyw(1, 21, 3);
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        bb.addButton((JComponent)ok);
        bb.addButton((JComponent)cancel);
        bb.addGlue();
        builder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        bb.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diag.getContentPane().add((Component)builder.getPanel(), "Center");
        this.diag.getContentPane().add((Component)bb.getPanel(), "South");
        this.diag.pack();
        ok.addActionListener(e -> {
            String[] fields;
            String fieldText = (String)this.field.getSelectedItem();
            if (fieldText == null || fieldText.trim().isEmpty()) {
                JOptionPane.showMessageDialog(this.diag, Localization.lang("You must enter at least one field name", new String[0]), "", 0);
                return;
            }
            if (this.rename.isSelected() && (fields = MassSetFieldAction.getFieldNames(fieldText)).length > 1) {
                JOptionPane.showMessageDialog(this.diag, Localization.lang("You can only rename one field at a time", new String[0]), "", 0);
                return;
            }
            this.canceled = false;
            this.diag.dispose();
        });
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MassSetFieldAction.this.canceled = true;
                MassSetFieldAction.this.diag.dispose();
            }
        };
        cancel.addActionListener(cancelAction);
        ActionMap am = builder.getPanel().getActionMap();
        InputMap im = builder.getPanel().getInputMap(2);
        im.put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        am.put("close", cancelAction);
    }

    private void prepareDialog(boolean selection) {
        this.selected.setEnabled(selection);
        if (selection) {
            this.selected.setSelected(true);
        } else {
            this.all.setSelected(true);
        }
        if (!(this.set.isSelected() || this.clear.isSelected() || this.rename.isSelected())) {
            this.set.setSelected(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        BasePanel bp = this.frame.getCurrentBasePanel();
        if (bp == null) {
            return;
        }
        List<BibEntry> entries = bp.getSelectedEntries();
        if (this.diag == null) {
            this.createDialog();
        }
        this.canceled = true;
        this.prepareDialog(!entries.isEmpty());
        if (this.diag != null) {
            this.diag.setLocationRelativeTo(this.frame);
            this.diag.setVisible(true);
        }
        if (this.canceled) {
            return;
        }
        List<BibEntry> entryList = this.all.isSelected() ? bp.getDatabase().getEntries() : entries;
        String toSet = this.textFieldSet.getText();
        if (toSet.isEmpty()) {
            toSet = null;
        }
        String[] fields = MassSetFieldAction.getFieldNames(((String)this.field.getSelectedItem()).trim().toLowerCase(Locale.ROOT));
        NamedCompound compoundEdit = new NamedCompound(Localization.lang("Set field", new String[0]));
        if (this.rename.isSelected()) {
            if (fields.length > 1) {
                JOptionPane.showMessageDialog(this.diag, Localization.lang("You can only rename one field at a time", new String[0]), "", 0);
                return;
            }
            compoundEdit.addEdit(MassSetFieldAction.massRenameField(entryList, fields[0], this.textFieldRename.getText(), this.overwrite.isSelected()));
        } else if (this.append.isSelected()) {
            for (String field2 : fields) {
                compoundEdit.addEdit(MassSetFieldAction.massAppendField(entryList, field2, this.textFieldAppend.getText()));
            }
        } else {
            for (String field3 : fields) {
                compoundEdit.addEdit(MassSetFieldAction.massSetField(entryList, field3, this.set.isSelected() ? toSet : null, this.overwrite.isSelected()));
            }
        }
        compoundEdit.end();
        bp.getUndoManager().addEdit(compoundEdit);
        bp.markBaseChanged();
    }

    private static UndoableEdit massSetField(Collection<BibEntry> entries, String field2, String textToSet, boolean overwriteValues) {
        NamedCompound compoundEdit = new NamedCompound(Localization.lang("Set field", new String[0]));
        for (BibEntry entry : entries) {
            Optional<String> oldValue = entry.getField(field2);
            if (!overwriteValues && oldValue.isPresent() && !oldValue.get().isEmpty()) continue;
            if (textToSet == null) {
                entry.clearField(field2);
            } else {
                entry.setField(field2, textToSet);
            }
            compoundEdit.addEdit(new UndoableFieldChange(entry, field2, oldValue.orElse(null), textToSet));
        }
        compoundEdit.end();
        return compoundEdit;
    }

    private static UndoableEdit massAppendField(Collection<BibEntry> entries, String field2, String textToAppend) {
        String newValue = "";
        if (textToAppend != null) {
            newValue = textToAppend;
        }
        NamedCompound compoundEdit = new NamedCompound(Localization.lang("Append field", new String[0]));
        for (BibEntry entry : entries) {
            Optional<String> oldValue = entry.getField(field2);
            entry.setField(field2, oldValue.orElse("") + newValue);
            compoundEdit.addEdit(new UndoableFieldChange(entry, field2, oldValue.orElse(null), newValue));
        }
        compoundEdit.end();
        return compoundEdit;
    }

    private static UndoableEdit massRenameField(Collection<BibEntry> entries, String field2, String newField, boolean overwriteValues) {
        NamedCompound compoundEdit = new NamedCompound(Localization.lang("Rename field", new String[0]));
        for (BibEntry entry : entries) {
            Optional<String> valToMove = entry.getField(field2);
            if (!valToMove.isPresent() || valToMove.get().isEmpty()) continue;
            Optional<String> valInNewField = entry.getField(newField);
            if (!overwriteValues && valInNewField.isPresent() && !valInNewField.get().isEmpty()) continue;
            entry.setField(newField, valToMove.get());
            compoundEdit.addEdit(new UndoableFieldChange(entry, newField, valInNewField.orElse(null), valToMove.get()));
            entry.clearField(field2);
            compoundEdit.addEdit(new UndoableFieldChange(entry, field2, valToMove.get(), null));
        }
        compoundEdit.end();
        return compoundEdit;
    }

    private static String[] getFieldNames(String s2) {
        return s2.split("[\\s;,]");
    }
}

