/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.autocompleter;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.controlsfx.control.textfield.AutoCompletionBinding;
import org.jabref.gui.autocompleter.AutoCompleteSuggestionProvider;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.model.entry.Author;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.entry.BibEntry;

public class PersonNameSuggestionProvider
extends SuggestionProvider<Author>
implements AutoCompleteSuggestionProvider<Author> {
    private final List<String> fieldNames;
    private final Comparator<Author> authorComparator = Comparator.comparing(Author::getNameForAlphabetization);

    PersonNameSuggestionProvider(String fieldName) {
        this(Collections.singletonList(Objects.requireNonNull(fieldName)));
    }

    public PersonNameSuggestionProvider(List<String> fieldNames) {
        this.fieldNames = Objects.requireNonNull(fieldNames);
    }

    @Override
    public void indexEntry(BibEntry entry) {
        if (entry == null) {
            return;
        }
        for (String fieldName : this.fieldNames) {
            entry.getField(fieldName).ifPresent(fieldValue -> {
                AuthorList authorList = AuthorList.parse(fieldValue);
                for (Author author : authorList.getAuthors()) {
                    this.addPossibleSuggestions(author);
                }
            });
        }
    }

    @Override
    protected Comparator<Author> getComparator() {
        return this.authorComparator;
    }

    @Override
    protected boolean isMatch(Author suggestion, AutoCompletionBinding.ISuggestionRequest request) {
        String userTextLower = request.getUserText().toLowerCase();
        String suggestionStr = suggestion.getLastFirst(false).toLowerCase();
        return suggestionStr.contains(userTextLower);
    }
}

