/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.exporter;

import java.awt.event.ActionEvent;
import java.nio.file.Path;
import java.util.List;
import javafx.stage.FileChooser;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.jabref.Globals;
import org.jabref.gui.FXDialogService;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.actions.MnemonicAwareAction;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.gui.util.FileFilterConverter;
import org.jabref.gui.worker.AbstractWorker;
import org.jabref.logic.exporter.Exporter;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.entry.BibEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportAction.class);

    private ExportAction() {
    }

    public static AbstractAction getExportAction(JabRefFrame frame, boolean selectedOnly) {
        class InternalExportAction
        extends MnemonicAwareAction {
            private final JabRefFrame frame;
            private final boolean selectedOnly;

            public InternalExportAction(JabRefFrame frame, boolean selectedOnly) {
                this.frame = frame;
                this.selectedOnly = selectedOnly;
                this.putValue("Name", selectedOnly ? Localization.menuTitle("Export selected entries", new String[0]) : Localization.menuTitle("Export", new String[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Globals.exportFactory = Globals.prefs.getExporterFactory(Globals.journalAbbreviationLoader);
                FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(FileFilterConverter.exporterToExtensionFilter(Globals.exportFactory.getExporters())).withDefaultExtension(Globals.prefs.get("lastUsedExport")).withInitialDirectory(Globals.prefs.get("exportWorkingDirectory")).build();
                FXDialogService dialogService = new FXDialogService();
                DefaultTaskExecutor.runInJavaFXThread(() -> dialogService.showFileSaveDialog(fileDialogConfiguration).ifPresent(path -> this.export((Path)path, fileDialogConfiguration.getSelectedExtensionFilter(), Globals.exportFactory.getExporters())));
            }

            private void export(final Path file, FileChooser.ExtensionFilter selectedExtensionFilter, List<Exporter> exporters) {
                String selectedExtension = ((String)selectedExtensionFilter.getExtensions().get(0)).replace("*", "");
                if (!file.endsWith(selectedExtension)) {
                    FileUtil.addExtension(file, selectedExtension);
                }
                final Exporter format = FileFilterConverter.getExporter(selectedExtensionFilter, exporters).orElseThrow(() -> new IllegalStateException("User didn't selected a file type for the extension"));
                List<BibEntry> entries = this.selectedOnly ? this.frame.getCurrentBasePanel().getSelectedEntries() : this.frame.getCurrentBasePanel().getDatabase().getEntries();
                Globals.prefs.fileDirForDatabase = this.frame.getCurrentBasePanel().getBibDatabaseContext().getFileDirectories(Globals.prefs.getFileDirectoryPreferences());
                Globals.prefs.put("lastUsedExport", format.getName());
                Globals.prefs.put("exportWorkingDirectory", file.getParent().toString());
                final List<BibEntry> finEntries = entries;
                AbstractWorker exportWorker = new AbstractWorker(){
                    String errorMessage;

                    @Override
                    public void run() {
                        try {
                            format.export(frame.getCurrentBasePanel().getBibDatabaseContext(), file, frame.getCurrentBasePanel().getBibDatabaseContext().getMetaData().getEncoding().orElse(Globals.prefs.getDefaultEncoding()), finEntries);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Problem exporting", ex);
                            this.errorMessage = ex.getMessage() == null ? ex.toString() : ex.getMessage();
                        }
                    }

                    @Override
                    public void update() {
                        if (this.errorMessage == null) {
                            frame.output(Localization.lang("%0 export successful", format.getName()));
                        } else {
                            frame.output(Localization.lang("Could not save file.", new String[0]) + " - " + this.errorMessage);
                            JOptionPane.showMessageDialog(frame, Localization.lang("Could not save file.", new String[0]) + "\n" + this.errorMessage, Localization.lang("Save library", new String[0]), 0);
                        }
                    }
                };
                exportWorker.getWorker().run();
                exportWorker.update();
            }
        }
        return new InternalExportAction(frame, selectedOnly);
    }
}

