/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.fxmisc.easybind.EasyBind;
import org.jabref.gui.util.TaskExecutor;

public abstract class BackgroundTask<V> {
    private Runnable onRunning;
    private Consumer<V> onSuccess;
    private Consumer<Exception> onException;
    private Runnable onFinished;
    private ObjectProperty<BackgroundProgress> progress = new SimpleObjectProperty((Object)new BackgroundProgress(0.0, 0.0));
    private DoubleProperty workDonePercentage = new SimpleDoubleProperty(0.0);

    public BackgroundTask() {
        this.workDonePercentage.bind(EasyBind.map(this.progress, BackgroundProgress::getWorkDonePercentage));
    }

    public static <V> BackgroundTask<V> wrap(final Callable<V> callable) {
        return new BackgroundTask<V>(){

            @Override
            protected V call() throws Exception {
                return callable.call();
            }
        };
    }

    public double getWorkDonePercentage() {
        return this.workDonePercentage.get();
    }

    public DoubleProperty workDonePercentageProperty() {
        return this.workDonePercentage;
    }

    public BackgroundProgress getProgress() {
        return (BackgroundProgress)this.progress.get();
    }

    public ObjectProperty<BackgroundProgress> progressProperty() {
        return this.progress;
    }

    private static <T> Consumer<T> chain(Runnable first, Consumer<T> second) {
        if (first != null) {
            if (second != null) {
                return result -> {
                    first.run();
                    second.accept(result);
                };
            }
            return result -> first.run();
        }
        return second;
    }

    public BackgroundTask<V> onRunning(Runnable onRunning) {
        this.onRunning = onRunning;
        return this;
    }

    public BackgroundTask<V> onSuccess(Consumer<V> onSuccess) {
        this.onSuccess = onSuccess;
        return this;
    }

    protected abstract V call() throws Exception;

    Runnable getOnRunning() {
        return this.onRunning;
    }

    Consumer<V> getOnSuccess() {
        return BackgroundTask.chain(this.onFinished, this.onSuccess);
    }

    Consumer<Exception> getOnException() {
        return BackgroundTask.chain(this.onFinished, this.onException);
    }

    public BackgroundTask<V> onFailure(Consumer<Exception> onException) {
        this.onException = onException;
        return this;
    }

    public Future<?> executeWith(TaskExecutor taskExecutor) {
        return taskExecutor.execute(this);
    }

    public BackgroundTask<V> onFinished(Runnable onFinished) {
        this.onFinished = onFinished;
        return this;
    }

    protected void updateProgress(double workDone, double max) {
        this.progress.setValue((Object)new BackgroundProgress(workDone, max));
    }

    public class BackgroundProgress {
        private final double workDone;
        private final double max;

        public BackgroundProgress(double workDone, double max) {
            this.workDone = workDone;
            this.max = max;
        }

        public double getWorkDone() {
            return this.workDone;
        }

        public double getMax() {
            return this.max;
        }

        public double getWorkDonePercentage() {
            if (this.max == 0.0) {
                return 0.0;
            }
            return this.workDone / this.max;
        }
    }
}

