/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.worker;

import java.awt.Desktop;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.worker.AbstractWorker;
import org.jabref.logic.bibtex.BibEntryWriter;
import org.jabref.logic.bibtex.LatexFieldFormatter;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.entry.BibEntry;
import org.jabref.preferences.JabRefPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendAsEMailAction
extends AbstractWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendAsEMailAction.class);
    private final JabRefFrame frame;
    private String message;

    public SendAsEMailAction(JabRefFrame frame) {
        this.frame = frame;
    }

    @Override
    public void run() {
        URI uRI;
        if (!Desktop.isDesktopSupported()) {
            this.message = Localization.lang("Error creating email", new String[0]);
            return;
        }
        BasePanel panel = this.frame.getCurrentBasePanel();
        if (panel == null) {
            return;
        }
        if (panel.getSelectedEntries().isEmpty()) {
            this.message = Localization.lang("This operation requires one or more entries to be selected.", new String[0]);
            return;
        }
        StringWriter sw = new StringWriter();
        List<BibEntry> bes = panel.getSelectedEntries();
        BibEntryWriter bibtexEntryWriter = new BibEntryWriter(new LatexFieldFormatter(Globals.prefs.getLatexFieldFormatterPreferences()), true);
        for (BibEntry entry : bes) {
            try {
                bibtexEntryWriter.write(entry, sw, panel.getBibDatabaseContext().getMode());
            }
            catch (IOException e) {
                LOGGER.warn("Problem creating BibTeX file for mailing.", e);
            }
        }
        ArrayList<String> attachments = new ArrayList<String>();
        boolean openFolders = JabRefPreferences.getInstance().getBoolean("openFoldersOfAttachedFiles");
        List<Path> fileList = FileUtil.getListOfLinkedFiles(bes, this.frame.getCurrentBasePanel().getBibDatabaseContext().getFileDirectoriesAsPaths(Globals.prefs.getFileDirectoryPreferences()));
        for (Path path : fileList) {
            attachments.add(path.toAbsolutePath().toString());
            if (!openFolders) continue;
            try {
                JabRefDesktop.openFolderAndSelectFile(path.toAbsolutePath());
            }
            catch (IOException e) {
                LOGGER.debug("Cannot open file", e);
            }
        }
        String mailTo = "?Body=".concat(sw.getBuffer().toString());
        mailTo = mailTo.concat("&Subject=");
        mailTo = mailTo.concat(JabRefPreferences.getInstance().get("emailSubject"));
        for (String path : attachments) {
            mailTo = mailTo.concat("&Attachment=\"").concat(path);
            mailTo = mailTo.concat("\"");
        }
        try {
            uRI = new URI("mailto", mailTo, null);
        }
        catch (URISyntaxException e1) {
            this.message = Localization.lang("Error creating email", new String[0]);
            LOGGER.warn(this.message, e1);
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.mail(uRI);
        }
        catch (IOException e) {
            this.message = Localization.lang("Error creating email", new String[0]);
            LOGGER.warn(this.message, e);
            return;
        }
        this.message = String.format("%s: %d", Localization.lang("Entries added to an email", new String[0]), bes.size());
    }

    @Override
    public void update() {
        this.frame.output(this.message);
    }
}

