/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.cleanup;

import java.util.ArrayList;
import java.util.List;
import org.jabref.logic.formatter.Formatters;
import org.jabref.logic.formatter.IdentityFormatter;
import org.jabref.logic.formatter.bibtexfields.HtmlToLatexFormatter;
import org.jabref.logic.formatter.bibtexfields.HtmlToUnicodeFormatter;
import org.jabref.logic.formatter.bibtexfields.NormalizeDateFormatter;
import org.jabref.logic.formatter.bibtexfields.NormalizeMonthFormatter;
import org.jabref.logic.formatter.bibtexfields.NormalizePagesFormatter;
import org.jabref.logic.formatter.bibtexfields.OrdinalsToSuperscriptFormatter;
import org.jabref.logic.formatter.bibtexfields.UnicodeToLatexFormatter;
import org.jabref.logic.layout.format.LatexToUnicodeFormatter;
import org.jabref.logic.layout.format.ReplaceUnicodeLigaturesFormatter;
import org.jabref.model.cleanup.FieldFormatterCleanup;
import org.jabref.model.cleanup.FieldFormatterCleanups;
import org.jabref.model.cleanup.Formatter;
import org.jabref.model.strings.StringUtil;

public class Cleanups {
    public static final FieldFormatterCleanups DEFAULT_SAVE_ACTIONS;
    public static final FieldFormatterCleanups RECOMMEND_BIBTEX_ACTIONS;
    public static final FieldFormatterCleanups RECOMMEND_BIBLATEX_ACTIONS;

    private Cleanups() {
    }

    public static List<Formatter> getBuiltInFormatters() {
        return Formatters.getAll();
    }

    public static List<FieldFormatterCleanup> parse(String formatterString) {
        if (formatterString == null || formatterString.isEmpty()) {
            return new ArrayList<FieldFormatterCleanup>();
        }
        ArrayList<FieldFormatterCleanup> actions2 = new ArrayList<FieldFormatterCleanup>();
        int startIndex = 0;
        String remainingString = formatterString;
        remainingString = StringUtil.unifyLineBreaks(remainingString, "");
        try {
            block2: while (startIndex < formatterString.length()) {
                int currentIndex = remainingString.indexOf(91);
                String fieldKey = remainingString.substring(0, currentIndex);
                int endIndex = remainingString.indexOf(93);
                startIndex += endIndex + 1;
                int tokenIndex = remainingString.indexOf(44);
                while (true) {
                    boolean doBreak = false;
                    if (tokenIndex == -1 || tokenIndex > endIndex) {
                        tokenIndex = remainingString.indexOf(93);
                        doBreak = true;
                    }
                    String formatterKey = remainingString.substring(currentIndex + 1, tokenIndex);
                    actions2.add(new FieldFormatterCleanup(fieldKey, Cleanups.getFormatterFromString(formatterKey)));
                    if ((remainingString = remainingString.substring(tokenIndex + 1)).startsWith("]") || doBreak) continue block2;
                    tokenIndex = remainingString.indexOf(44);
                    currentIndex = -1;
                }
            }
        }
        catch (StringIndexOutOfBoundsException ignore) {
            return actions2;
        }
        return actions2;
    }

    public static FieldFormatterCleanups parse(List<String> formatterMetaList) {
        if (formatterMetaList != null && formatterMetaList.size() >= 2) {
            boolean enablementStatus = "enabled".equals(formatterMetaList.get(0));
            String formatterString = formatterMetaList.get(1);
            return new FieldFormatterCleanups(enablementStatus, Cleanups.parse(formatterString));
        }
        return DEFAULT_SAVE_ACTIONS;
    }

    private static Formatter getFormatterFromString(String formatterName) {
        for (Formatter formatter : Cleanups.getBuiltInFormatters()) {
            if (!formatterName.equals(formatter.getKey())) continue;
            return formatter;
        }
        return new IdentityFormatter();
    }

    static {
        ArrayList<FieldFormatterCleanup> defaultFormatters = new ArrayList<FieldFormatterCleanup>();
        defaultFormatters.add(new FieldFormatterCleanup("pages", new NormalizePagesFormatter()));
        defaultFormatters.add(new FieldFormatterCleanup("date", new NormalizeDateFormatter()));
        defaultFormatters.add(new FieldFormatterCleanup("month", new NormalizeMonthFormatter()));
        defaultFormatters.add(new FieldFormatterCleanup("all-text-fields", new ReplaceUnicodeLigaturesFormatter()));
        DEFAULT_SAVE_ACTIONS = new FieldFormatterCleanups(false, defaultFormatters);
        ArrayList<FieldFormatterCleanup> recommendedBibTeXFormatters = new ArrayList<FieldFormatterCleanup>();
        recommendedBibTeXFormatters.addAll(defaultFormatters);
        recommendedBibTeXFormatters.add(new FieldFormatterCleanup("all-text-fields", new HtmlToLatexFormatter()));
        recommendedBibTeXFormatters.add(new FieldFormatterCleanup("all-text-fields", new UnicodeToLatexFormatter()));
        recommendedBibTeXFormatters.add(new FieldFormatterCleanup("all-text-fields", new OrdinalsToSuperscriptFormatter()));
        RECOMMEND_BIBTEX_ACTIONS = new FieldFormatterCleanups(false, recommendedBibTeXFormatters);
        ArrayList<FieldFormatterCleanup> recommendedBiblatexFormatters = new ArrayList<FieldFormatterCleanup>();
        recommendedBiblatexFormatters.addAll(defaultFormatters);
        recommendedBiblatexFormatters.add(new FieldFormatterCleanup("title", new HtmlToUnicodeFormatter()));
        recommendedBiblatexFormatters.add(new FieldFormatterCleanup("all-text-fields", new LatexToUnicodeFormatter()));
        RECOMMEND_BIBLATEX_ACTIONS = new FieldFormatterCleanups(false, recommendedBiblatexFormatters);
    }
}

