/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.cleanup;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jabref.model.FieldChange;
import org.jabref.model.cleanup.CleanupJob;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.FileFieldWriter;
import org.jabref.model.entry.LinkedFile;

public class FileLinksCleanup
implements CleanupJob {
    @Override
    public List<FieldChange> cleanup(BibEntry entry) {
        Optional<String> oldValue = entry.getField("file");
        if (!oldValue.isPresent()) {
            return Collections.emptyList();
        }
        List<LinkedFile> fileList = entry.getFiles();
        String newValue = FileFieldWriter.getStringRepresentation(fileList);
        if (!oldValue.get().equals(newValue)) {
            entry.setField("file", newValue);
            FieldChange change = new FieldChange(entry, "file", oldValue.get(), newValue);
            return Collections.singletonList(change);
        }
        return Collections.emptyList();
    }
}

