/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.BibDatabases;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.EntryType;
import org.jabref.model.metadata.MetaData;

public class ParserResult {
    private final Map<String, EntryType> entryTypes;
    private final List<String> warnings = new ArrayList<String>();
    private final List<String> duplicateKeys = new ArrayList<String>();
    private BibDatabase database;
    private MetaData metaData = new MetaData();
    private File file;
    private boolean invalid;
    private boolean toOpenTab;
    private boolean changedOnMigration = false;

    public ParserResult() {
        this(Collections.emptyList());
    }

    public ParserResult(Collection<BibEntry> entries) {
        this(BibDatabases.createDatabase(BibDatabases.purgeEmptyEntries(entries)));
    }

    public ParserResult(BibDatabase database) {
        this(database, new MetaData(), new HashMap<String, EntryType>());
    }

    public ParserResult(BibDatabase database, MetaData metaData, Map<String, EntryType> entryTypes) {
        this.database = Objects.requireNonNull(database);
        this.metaData = Objects.requireNonNull(metaData);
        this.entryTypes = Objects.requireNonNull(entryTypes);
    }

    public static ParserResult fromErrorMessage(String message) {
        ParserResult parserResult = new ParserResult();
        parserResult.addWarning(message);
        parserResult.setInvalid(true);
        return parserResult;
    }

    private static String getErrorMessage(Exception exception) {
        String errorMessage = exception.getLocalizedMessage();
        if (exception.getCause() != null) {
            errorMessage = errorMessage + " Caused by: " + exception.getCause().getLocalizedMessage();
        }
        return errorMessage;
    }

    public static ParserResult fromError(Exception exception) {
        return ParserResult.fromErrorMessage(ParserResult.getErrorMessage(exception));
    }

    public boolean toOpenTab() {
        return this.toOpenTab;
    }

    public void setToOpenTab() {
        this.toOpenTab = true;
    }

    public BibDatabase getDatabase() {
        return this.database;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(MetaData md) {
        this.metaData = md;
    }

    public Map<String, EntryType> getEntryTypes() {
        return this.entryTypes;
    }

    public Optional<File> getFile() {
        return Optional.ofNullable(this.file);
    }

    public void setFile(File f) {
        this.file = f;
    }

    public void addWarning(String s2) {
        if (!this.warnings.contains(s2)) {
            this.warnings.add(s2);
        }
    }

    public void addException(Exception exception) {
        String errorMessage = ParserResult.getErrorMessage(exception);
        this.addWarning(errorMessage);
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public List<String> warnings() {
        return new ArrayList<String>(this.warnings);
    }

    public void addDuplicateKey(String key) {
        if (!this.duplicateKeys.contains(key)) {
            this.duplicateKeys.add(key);
        }
    }

    public boolean hasDuplicateKeys() {
        return !this.duplicateKeys.isEmpty();
    }

    public List<String> getDuplicateKeys() {
        return this.duplicateKeys;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    public void setInvalid(boolean invalid) {
        this.invalid = invalid;
    }

    public String getErrorMessage() {
        return this.warnings().stream().collect(Collectors.joining(" "));
    }

    public BibDatabaseContext getDatabaseContext() {
        return new BibDatabaseContext(this.database, this.metaData, this.file);
    }

    public void setDatabaseContext(BibDatabaseContext bibDatabaseContext) {
        Objects.requireNonNull(bibDatabaseContext);
        this.database = bibDatabaseContext.getDatabase();
        this.metaData = bibDatabaseContext.getMetaData();
        this.file = bibDatabaseContext.getDatabaseFile().orElse(null);
    }

    public boolean isEmpty() {
        return this == new ParserResult();
    }

    public boolean wasChangedOnMigration() {
        return this.changedOnMigration;
    }

    public void setChangedOnMigration(boolean wasChangedOnMigration) {
        this.changedOnMigration = wasChangedOnMigration;
    }
}

