/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.layout.format;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jabref.logic.bst.BibtexNameFormatter;
import org.jabref.logic.layout.LayoutFormatter;
import org.jabref.logic.layout.format.NameFormatterPreferences;
import org.jabref.model.entry.AuthorList;

public class NameFormatter
implements LayoutFormatter {
    public static final String DEFAULT_FORMAT = "1@*@{ff }{vv }{ll}{, jj}@@*@1@{ff }{vv }{ll}{, jj}@*@, {ff }{vv }{ll}{, jj}";
    private String parameter = "1@*@{ff }{vv }{ll}{, jj}@@*@1@{ff }{vv }{ll}{, jj}@*@, {ff }{vv }{ll}{, jj}";

    private static String format(String toFormat, AuthorList al, String[] formats) {
        StringBuilder sb = new StringBuilder();
        int n = al.getNumberOfAuthors();
        block0: for (int i = 1; i <= al.getNumberOfAuthors(); ++i) {
            for (int j = 1; j < formats.length; j += 2) {
                int e;
                int s2;
                if ("*".equals(formats[j])) {
                    sb.append(BibtexNameFormatter.formatName(toFormat, i, formats[j + 1], null));
                    continue block0;
                }
                String[] range = formats[j].split("\\.\\.");
                if (range.length == 2) {
                    s2 = Integer.parseInt(range[0]);
                    e = Integer.parseInt(range[1]);
                } else {
                    s2 = e = Integer.parseInt(range[0]);
                }
                if (s2 < 0) {
                    s2 += n + 1;
                }
                if (e < 0) {
                    e += n + 1;
                }
                if (e < s2) {
                    int temp = e;
                    e = s2;
                    s2 = temp;
                }
                if (s2 > i || i > e) continue;
                sb.append(BibtexNameFormatter.formatName(toFormat, i, formats[j + 1], null));
                continue block0;
            }
        }
        return sb.toString();
    }

    public String format(String toFormat, String inParameters) {
        String[] cases;
        AuthorList al = AuthorList.parse(toFormat);
        String parameters = inParameters == null || inParameters.isEmpty() ? "*:*:\"{ff}{vv}{ll}{,jj} \"" : inParameters;
        for (String aCase : cases = parameters.split("@@")) {
            String[] formatString = aCase.split("@");
            if (formatString.length < 3) {
                return toFormat;
            }
            if ("*".equals(formatString[0])) {
                return NameFormatter.format(toFormat, al, formatString);
            }
            if (al.getNumberOfAuthors() > Integer.parseInt(formatString[0])) continue;
            return NameFormatter.format(toFormat, al, formatString);
        }
        return toFormat;
    }

    @Override
    public String format(String fieldText) {
        return this.format(fieldText, this.parameter);
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public static Map<String, String> getNameFormatters(NameFormatterPreferences prefs) {
        Objects.requireNonNull(prefs);
        HashMap<String, String> result = new HashMap<String, String>();
        List<String> names = prefs.getNameFormatterKey();
        List<String> formats = prefs.getNameFormatterValue();
        for (int i = 0; i < names.size(); ++i) {
            if (i < formats.size()) {
                result.put(names.get(i), formats.get(i));
                continue;
            }
            result.put(names.get(i), DEFAULT_FORMAT);
        }
        return result;
    }
}

