/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.msbib;

import java.util.ArrayList;
import java.util.List;
import org.jabref.logic.msbib.MSBibEntry;
import org.jabref.logic.msbib.MSBibMapping;
import org.jabref.logic.msbib.MsBibAuthor;
import org.jabref.logic.msbib.PageNumbers;
import org.jabref.model.entry.Author;
import org.jabref.model.entry.AuthorList;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.Month;

public class MSBibConverter {
    private static final String MSBIB_PREFIX = "msbib-";
    private static final String BIBTEX_PREFIX = "BIBTEX_";

    private MSBibConverter() {
    }

    public static MSBibEntry convert(BibEntry entry) {
        MSBibEntry result = new MSBibEntry();
        result.fields.put("BIBTEX_Entry", entry.getType());
        String msbibType = result.fields.put("SourceType", MSBibMapping.getMSBibEntryType(entry.getType()).name());
        for (String field2 : entry.getFieldNames()) {
            String unicodeField = entry.getLatexFreeField(field2).orElse("");
            if (MSBibMapping.getMSBibField(field2) == null) continue;
            result.fields.put(MSBibMapping.getMSBibField(field2), unicodeField);
        }
        entry.getLatexFreeField("booktitle").ifPresent(booktitle -> {
            result.conferenceName = booktitle;
        });
        entry.getLatexFreeField("pages").ifPresent(pages -> {
            result.pages = new PageNumbers((String)pages);
        });
        entry.getLatexFreeField("msbib-accessed").ifPresent(accesed -> {
            result.dateAccessed = accesed;
        });
        if ("SoundRecording".equals(msbibType)) {
            result.albumTitle = entry.getLatexFreeField("title").orElse(null);
        }
        if ("Interview".equals(msbibType)) {
            result.broadcastTitle = entry.getLatexFreeField("title").orElse(null);
        }
        result.number = entry.getLatexFreeField("number").orElse(null);
        if ("Patent".equalsIgnoreCase(entry.getType())) {
            result.patentNumber = entry.getLatexFreeField("number").orElse(null);
            result.number = null;
        }
        result.day = entry.getFieldOrAliasLatexFree("day").orElse(null);
        result.month = entry.getMonth().map(Month::getNumber).map(Object::toString).orElse(null);
        if (!entry.getLatexFreeField("year").isPresent()) {
            result.year = entry.getFieldOrAliasLatexFree("year").orElse(null);
        }
        result.journalName = entry.getFieldOrAliasLatexFree("journal").orElse(null);
        entry.getLatexFreeField("language").ifPresent(lang -> result.fields.put("LCID", String.valueOf(MSBibMapping.getLCID(lang))));
        StringBuilder sbNumber = new StringBuilder();
        entry.getLatexFreeField("isbn").ifPresent(isbn -> sbNumber.append(" ISBN: " + isbn));
        entry.getLatexFreeField("issn").ifPresent(issn -> sbNumber.append(" ISSN: " + issn));
        entry.getLatexFreeField("lccn").ifPresent(lccn -> sbNumber.append("LCCN: " + lccn));
        entry.getLatexFreeField("mrnumber").ifPresent(mrnumber -> sbNumber.append(" MRN: " + mrnumber));
        result.standardNumber = sbNumber.toString();
        if (result.standardNumber.isEmpty()) {
            result.standardNumber = null;
        }
        result.address = entry.getFieldOrAliasLatexFree("address").orElse(null);
        if (entry.getLatexFreeField("type").isPresent()) {
            result.thesisType = entry.getLatexFreeField("type").get();
        } else if ("techreport".equalsIgnoreCase(entry.getType())) {
            result.thesisType = "Tech. rep.";
        } else if ("mastersthesis".equalsIgnoreCase(entry.getType())) {
            result.thesisType = "Master's thesis";
        } else if ("phdthesis".equalsIgnoreCase(entry.getType())) {
            result.thesisType = "Ph.D. dissertation";
        } else if ("unpublished".equalsIgnoreCase(entry.getType())) {
            result.thesisType = "unpublished";
        }
        if ("InternetSite".equals(msbibType) || "DocumentFromInternetSite".equals(msbibType)) {
            result.internetSiteTitle = entry.getLatexFreeField("title").orElse(null);
        }
        if ("ElectronicSource".equals(msbibType) || "Art".equals(msbibType) || "Misc".equals(msbibType)) {
            result.publicationTitle = entry.getLatexFreeField("title").orElse(null);
        }
        entry.getLatexFreeField("author").ifPresent(authors -> {
            result.authors = MSBibConverter.getAuthors(authors);
        });
        entry.getLatexFreeField("editor").ifPresent(editors -> {
            result.editors = MSBibConverter.getAuthors(editors);
        });
        entry.getLatexFreeField("translator").ifPresent(translator -> {
            result.translators = MSBibConverter.getAuthors(translator);
        });
        return result;
    }

    private static List<MsBibAuthor> getAuthors(String authors) {
        ArrayList<MsBibAuthor> result = new ArrayList<MsBibAuthor>();
        boolean corporate = false;
        if (authors.startsWith("{") && authors.endsWith("}")) {
            corporate = true;
        }
        AuthorList authorList = AuthorList.parse(authors);
        for (Author author : authorList.getAuthors()) {
            result.add(new MsBibAuthor(author, corporate));
        }
        return result;
    }
}

