/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public abstract class TreeNode<T extends TreeNode<T>> {
    private final ObservableList<T> children;
    private T parent = null;
    private Consumer<T> onDescendantChanged = t -> {};

    public TreeNode(Class<T> derivingClass) {
        this.children = FXCollections.observableArrayList();
        if (!derivingClass.isInstance(this)) {
            throw new UnsupportedOperationException("The class extending TreeNode<T> has to derive from T");
        }
    }

    public List<Integer> getIndexedPathFromRoot() {
        if (this.parent == null) {
            return new ArrayList<Integer>();
        }
        List<Integer> path = ((TreeNode)this.parent).getIndexedPathFromRoot();
        path.add(this.getPositionInParent());
        return path;
    }

    public Optional<T> getDescendant(List<Integer> indexedPath) {
        TreeNode cursor = this;
        for (int index : indexedPath) {
            Optional<T> child = cursor.getChildAt(index);
            if (child.isPresent()) {
                cursor = (TreeNode)child.get();
                continue;
            }
            return Optional.empty();
        }
        return Optional.of(cursor);
    }

    public int getPositionInParent() {
        return ((TreeNode)this.getParent().orElseThrow(() -> new UnsupportedOperationException("Roots have no position in parent"))).getIndexOfChild(this).get();
    }

    public Optional<Integer> getIndexOfChild(T childNode) {
        Objects.requireNonNull(childNode);
        int index = this.children.indexOf(childNode);
        if (index == -1) {
            return Optional.empty();
        }
        return Optional.of(index);
    }

    public int getLevel() {
        if (this.parent == null) {
            return 0;
        }
        return ((TreeNode)this.parent).getLevel() + 1;
    }

    public int getNumberOfChildren() {
        return this.children.size();
    }

    public void moveTo(T target) {
        Objects.requireNonNull(target);
        Optional<T> oldParent = this.getParent();
        if (oldParent.isPresent() && oldParent.get() == target) {
            this.moveTo(target, ((TreeNode)target).getNumberOfChildren() - 1);
        } else {
            this.moveTo(target, ((TreeNode)target).getNumberOfChildren());
        }
    }

    public List<T> getPathFromRoot() {
        if (this.parent == null) {
            ArrayList<TreeNode> pathToMe = new ArrayList<TreeNode>();
            pathToMe.add(this);
            return pathToMe;
        }
        List<T> path = ((TreeNode)this.parent).getPathFromRoot();
        path.add(this);
        return path;
    }

    public Optional<T> getNextSibling() {
        return this.getRelativeSibling(1);
    }

    public Optional<T> getPreviousSibling() {
        return this.getRelativeSibling(-1);
    }

    private Optional<T> getRelativeSibling(int shiftIndex) {
        if (this.parent == null) {
            return Optional.empty();
        }
        int indexInParent = this.getPositionInParent();
        int indexTarget = indexInParent + shiftIndex;
        if (((TreeNode)this.parent).childIndexExists(indexTarget)) {
            return ((TreeNode)this.parent).getChildAt(indexTarget);
        }
        return Optional.empty();
    }

    public Optional<T> getParent() {
        return Optional.ofNullable(this.parent);
    }

    protected void setParent(T parent) {
        this.parent = parent;
    }

    public Optional<T> getChildAt(int index) {
        return this.childIndexExists(index) ? Optional.of((TreeNode)this.children.get(index)) : Optional.empty();
    }

    protected boolean childIndexExists(int index) {
        return index >= 0 && index < this.children.size();
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isAncestorOf(T anotherNode) {
        Objects.requireNonNull(anotherNode);
        if (anotherNode == this) {
            return true;
        }
        for (TreeNode child : this.children) {
            if (!child.isAncestorOf(anotherNode)) continue;
            return true;
        }
        return false;
    }

    public T getRoot() {
        if (this.parent == null) {
            return (T)this;
        }
        return ((TreeNode)this.parent).getRoot();
    }

    public boolean isLeaf() {
        return this.getNumberOfChildren() == 0;
    }

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.removeChild((TreeNode)this);
        }
    }

    public void removeAllChildren() {
        while (this.getNumberOfChildren() > 0) {
            this.removeChild(0);
        }
    }

    public Optional<T> getFirstChild() {
        return this.getChildAt(0);
    }

    public Optional<T> getLastChild() {
        return this.getChildAt(this.children.size() - 1);
    }

    public boolean isNodeDescendant(T anotherNode) {
        Objects.requireNonNull(anotherNode);
        return this.isAncestorOf(anotherNode);
    }

    public ObservableList<T> getChildren() {
        return FXCollections.unmodifiableObservableList(this.children);
    }

    public void removeChild(T child) {
        Objects.requireNonNull(child);
        this.children.remove(child);
        ((TreeNode)child).setParent(null);
        this.notifyAboutDescendantChange(this);
    }

    public void removeChild(int childIndex) {
        Optional<T> child = this.getChildAt(childIndex);
        if (child.isPresent()) {
            this.children.remove(childIndex);
            ((TreeNode)child.get()).setParent(null);
        }
        this.notifyAboutDescendantChange(this);
    }

    public T addChild(T child) {
        return this.addChild(child, this.children.size());
    }

    public T addChild(T child, int index) {
        Objects.requireNonNull(child);
        if (child.getParent().isPresent()) {
            throw new UnsupportedOperationException("Cannot add a node which already has a parent, use moveTo instead");
        }
        child.setParent((TreeNode)this);
        this.children.add(index, child);
        this.notifyAboutDescendantChange(this);
        return (T)child;
    }

    public void moveAllChildrenTo(T target, int targetIndex) {
        while (this.getNumberOfChildren() > 0) {
            ((TreeNode)this.getLastChild().get()).moveTo(target, targetIndex);
        }
    }

    public void sortChildren(Comparator<? super T> comparator, boolean recursive) {
        Objects.requireNonNull(comparator);
        if (this.isLeaf()) {
            return;
        }
        int j = this.getNumberOfChildren() - 1;
        while (j > 0) {
            int lastModified = j + 1;
            j = -1;
            for (int i = 1; i < lastModified; ++i) {
                TreeNode child2;
                TreeNode child1 = (TreeNode)this.getChildAt(i - 1).get();
                if (comparator.compare(child1, child2 = (TreeNode)this.getChildAt(i).get()) <= 0) continue;
                child1.moveTo(this, i);
                j = i;
            }
        }
        if (recursive) {
            for (TreeNode child : this.getChildren()) {
                child.sortChildren(comparator, true);
            }
        }
    }

    public void moveTo(T target, int targetIndex) {
        Objects.requireNonNull(target);
        if (this.isAncestorOf(target)) {
            throw new UnsupportedOperationException("the target cannot be a descendant of this node");
        }
        Optional<T> oldParent = this.getParent();
        if (oldParent.isPresent()) {
            ((TreeNode)oldParent.get()).removeChild(this);
        }
        target.addChild((TreeNode)this, targetIndex);
    }

    public T copySubtree() {
        T copy = this.copyNode();
        for (TreeNode child : this.getChildren()) {
            ((TreeNode)child.copySubtree()).moveTo(copy);
        }
        return copy;
    }

    public abstract T copyNode();

    public void subscribeToDescendantChanged(Consumer<T> subscriber) {
        this.onDescendantChanged = this.onDescendantChanged.andThen(subscriber);
    }

    protected void notifyAboutDescendantChange(T source) {
        this.onDescendantChanged.accept(source);
        if (!this.isRoot()) {
            ((TreeNode)this.parent).notifyAboutDescendantChange(source);
        }
    }

    public List<T> findChildrenSatisfying(Predicate<T> matcher) {
        ArrayList<TreeNode> hits = new ArrayList<TreeNode>();
        if (matcher.test(this)) {
            hits.add(this);
        }
        for (TreeNode child : this.getChildren()) {
            hits.addAll(child.findChildrenSatisfying(matcher));
        }
        return hits;
    }
}

