/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.jabref.model.entry.BibtexEntryType;
import org.jabref.model.entry.EntryType;
import org.jabref.model.entry.FieldName;

public class BibtexEntryTypes {
    public static final EntryType ARTICLE = new BibtexEntryType(){
        {
            this.addAllRequired("author", "title", "journal", "year");
            this.addAllOptional("volume", "number", "pages", "month", "issn", "note");
        }

        @Override
        public String getName() {
            return "Article";
        }
    };
    public static final EntryType BOOK = new BibtexEntryType(){
        {
            this.addAllRequired("title", "publisher", "year", FieldName.orFields("author", "editor"));
            this.addAllOptional("volume", "number", "series", "address", "edition", "month", "isbn", "note");
        }

        @Override
        public String getName() {
            return "Book";
        }
    };
    public static final EntryType BOOKLET = new BibtexEntryType(){
        {
            this.addAllRequired("title");
            this.addAllOptional("author", "howpublished", "address", "month", "year", "note");
        }

        @Override
        public String getName() {
            return "Booklet";
        }
    };
    public static final EntryType CONFERENCE = new BibtexEntryType(){
        {
            this.addAllRequired("author", "title", "booktitle", "year");
            this.addAllOptional("editor", "volume", "number", "series", "pages", "address", "month", "organization", "publisher", "note");
        }

        @Override
        public String getName() {
            return "Conference";
        }
    };
    public static final EntryType INBOOK = new BibtexEntryType(){
        {
            this.addAllRequired(FieldName.orFields("chapter", "pages"), "title", "publisher", "year", FieldName.orFields("author", "editor"));
            this.addAllOptional("volume", "number", "series", "type", "address", "edition", "month", "isbn", "note");
        }

        @Override
        public String getName() {
            return "InBook";
        }
    };
    public static final EntryType INCOLLECTION = new BibtexEntryType(){
        {
            this.addAllRequired("author", "title", "booktitle", "publisher", "year");
            this.addAllOptional("editor", "volume", "number", "series", "type", "chapter", "pages", "address", "edition", "month", "isbn", "note");
        }

        @Override
        public String getName() {
            return "InCollection";
        }
    };
    public static final EntryType INPROCEEDINGS = new BibtexEntryType(){
        {
            this.addAllRequired("author", "title", "booktitle", "year");
            this.addAllOptional("editor", "volume", "number", "series", "pages", "address", "month", "organization", "publisher", "note");
        }

        @Override
        public String getName() {
            return "InProceedings";
        }
    };
    public static final EntryType MANUAL = new BibtexEntryType(){
        {
            this.addAllRequired("title");
            this.addAllOptional("author", "organization", "address", "edition", "month", "year", "isbn", "note");
        }

        @Override
        public String getName() {
            return "Manual";
        }
    };
    public static final EntryType MASTERSTHESIS = new BibtexEntryType(){
        {
            this.addAllRequired("author", "title", "school", "year");
            this.addAllOptional("type", "address", "month", "note");
        }

        @Override
        public String getName() {
            return "MastersThesis";
        }
    };
    public static final EntryType MISC = new BibtexEntryType(){
        {
            this.addAllOptional("author", "title", "howpublished", "month", "year", "note");
        }

        @Override
        public String getName() {
            return "Misc";
        }
    };
    public static final EntryType PHDTHESIS = new BibtexEntryType(){
        {
            this.addAllRequired("author", "title", "school", "year");
            this.addAllOptional("type", "address", "month", "note");
        }

        @Override
        public String getName() {
            return "PhdThesis";
        }
    };
    public static final EntryType PROCEEDINGS = new BibtexEntryType(){
        {
            this.addAllRequired("title", "year");
            this.addAllOptional("editor", "volume", "number", "series", "address", "publisher", "month", "organization", "isbn", "note");
        }

        @Override
        public String getName() {
            return "Proceedings";
        }
    };
    public static final EntryType TECHREPORT = new BibtexEntryType(){
        {
            this.addAllRequired("author", "title", "institution", "year");
            this.addAllOptional("type", "number", "address", "month", "note");
        }

        @Override
        public String getName() {
            return "TechReport";
        }
    };
    public static final EntryType UNPUBLISHED = new BibtexEntryType(){
        {
            this.addAllRequired("author", "title", "note");
            this.addAllOptional("month", "year");
        }

        @Override
        public String getName() {
            return "Unpublished";
        }
    };
    public static final List<EntryType> ALL = Arrays.asList(ARTICLE, INBOOK, BOOK, BOOKLET, INCOLLECTION, CONFERENCE, INPROCEEDINGS, PROCEEDINGS, MANUAL, MASTERSTHESIS, PHDTHESIS, TECHREPORT, UNPUBLISHED, MISC);

    private BibtexEntryTypes() {
    }

    public static Optional<EntryType> getType(String name) {
        return ALL.stream().filter(e -> e.getName().equalsIgnoreCase(name)).findFirst();
    }
}

