/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.xmind.gef.GEF;
import org.xmind.ui.gantt2.gefext.HandleFigure;
import org.xmind.ui.gantt2.gefext.IBlankSpaceFigure;
import org.xmind.ui.gantt2.gefext.IFullHorizontalFigure;
import org.xmind.ui.gantt2.gefext.SelectionFeedback;
import org.xmind.ui.gantt2.viewer.BackgroundLayout;
import org.xmind.ui.gantt2.viewer.Colors;
import org.xmind.ui.gantt2.viewer.IHostFigureProvider;

public class BackgroundSelectionFeedback
extends SelectionFeedback {
    protected IFigure preselection = null;
    protected IFigure selection = null;

    public void activate() {
        super.activate();
        this.preselection = this.registerHandle(new BackgroundSelectionFigure(this.getHostFigure(), Colors.preselected()), GEF.LAYER_BACKGROUND);
        this.selection = this.registerHandle(new BackgroundSelectionFigure(this.getHostFigure(), Colors.selected()), GEF.LAYER_BACKGROUND);
        this.activateHandles(this.preselection, this.selection);
    }

    public void deactivate() {
        this.deactivateHandles(this.preselection, this.selection);
        super.deactivate();
    }

    protected void addToLayer(Object layerKey, IFigure figure, Object constraint) {
        if (figure == this.preselection || figure == this.selection) {
            constraint = BackgroundLayout.CONSTRAINT_SELECTION;
        }
        super.addToLayer(layerKey, figure, constraint);
    }

    protected IFigure getHostFigure() {
        return this.getHost().getFigure();
    }

    protected static Rectangle getBoundingBox(IFigure figure) {
        if (figure instanceof FreeformFigure) {
            return ((FreeformFigure)figure).getFreeformExtent();
        }
        return figure.getBounds();
    }

    protected void onPreselected() {
        super.onPreselected();
        if (!this.getHost().getStatus().isSelected()) {
            this.preselection.setOpaque(true);
        }
    }

    protected void onDepreselected() {
        this.preselection.setOpaque(false);
        super.onDepreselected();
    }

    protected void onSelected() {
        super.onSelected();
        this.selection.setOpaque(true);
    }

    protected void onDeselected() {
        this.selection.setOpaque(false);
        super.onDeselected();
    }

    private boolean isHostFigureVisible() {
        if (this.getHost() instanceof IHostFigureProvider) {
            return ((IHostFigureProvider)this.getHost()).isHostFigureVisible();
        }
        return true;
    }

    public boolean isPreSelected() {
        return this.preselection == null ? false : this.preselection.isOpaque();
    }

    public boolean isSelected() {
        return this.selection == null ? false : this.selection.isOpaque();
    }

    private class BackgroundSelectionFigure
    extends HandleFigure
    implements IFullHorizontalFigure,
    IBlankSpaceFigure {
        private int y;
        private int height;
        private int space;

        public BackgroundSelectionFigure(IFigure host, Color color) {
            this.setHost(host);
            this.setBackgroundColor(color);
            this.setOpaque(false);
        }

        public int getHeight() {
            return this.height;
        }

        public int getY() {
            return this.y;
        }

        public void setHeight(int height) {
            if (height == this.height) {
                return;
            }
            this.height = height;
            this.revalidate();
        }

        public void setY(int y) {
            if (y == this.y) {
                return;
            }
            this.y = y;
            this.revalidate();
        }

        protected void calculateBounds(Rectangle source, Rectangle target) {
        }

        protected void resetBounds() {
            if (this.getHost().getParent().isShowing() && BackgroundSelectionFeedback.this.isHostFigureVisible()) {
                Rectangle r = BackgroundSelectionFeedback.getBoundingBox(this.getHost());
                this.setY(r.y - this.space);
                this.setHeight(r.height + 2 * this.space);
                this.setVisible(true);
            } else {
                this.setY(0);
                this.setHeight(0);
                this.setVisible(false);
            }
        }

        public void setSpace(int space) {
            if (space != this.space) {
                this.space = space;
                this.resetBounds();
                this.revalidate();
            }
        }
    }
}

