/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.de.erichseifert.vectorgraphics2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.xmind.de.erichseifert.vectorgraphics2d.VectorGraphics2D;
import org.xmind.de.erichseifert.vectorgraphics2d.util.DataUtils;
import org.xmind.de.erichseifert.vectorgraphics2d.util.GraphicsUtils;

public class PDFGraphics2D
extends VectorGraphics2D {
    protected static final String FONT_RESOURCE_PREFIX = "F";
    protected static final String IMAGE_RESOURCE_PREFIX = "Im";
    protected static final String TRANSPARENCY_RESOURCE_PREFIX = "T";
    protected static final double MM_IN_UNITS = 2.834645669291339;
    private static final Map<Integer, Integer> STROKE_ENDCAPS = DataUtils.map(new Integer[]{0, 1, 2}, new Integer[]{0, 1, 2});
    private static final Map<Integer, Integer> STROKE_LINEJOIN = DataUtils.map(new Integer[]{0, 1, 2}, new Integer[]{0, 1, 2});
    private int curObjId;
    private final Map<Integer, Integer> objPositions;
    private final Map<Double, String> transpResources;
    private final Map<BufferedImage, String> imageResources;
    private final Map<Font, String> fontResources;
    private int contentStart;
    private double scale;
    private double scaledOffsetX;
    private double scaledOffsetY;

    public PDFGraphics2D(double x, double y, double width, double height, double scale, double scaledOffsetX, double scaledOffsetY) {
        super(x, y, width, height);
        this.scale = scale;
        this.scaledOffsetX = (double)Math.round(scaledOffsetX * 100.0) / 100.0;
        this.scaledOffsetY = (double)Math.round(scaledOffsetY * 100.0) / 100.0;
        this.curObjId = 1;
        this.objPositions = new TreeMap<Integer, Integer>();
        this.transpResources = new TreeMap<Double, String>();
        this.imageResources = new LinkedHashMap<BufferedImage, String>();
        this.fontResources = new LinkedHashMap<Font, String>();
        this.writeHeader();
    }

    @Override
    protected void writeString(String str, double x, double y) {
        str = str.replaceAll("\\\\", "\\\\\\\\").replaceAll("\t", "\\\\t").replaceAll("\b", "\\\\b").replaceAll("\f", "\\\\f").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)");
        float fontSize = this.getFont().getSize2D();
        float leading = this.getFont().getLineMetrics("", this.getFontRenderContext()).getLeading();
        this.writeln("q BT");
        String fontResourceId = this.getFontResource(this.getFont());
        this.writeln("/", fontResourceId, " ", Float.valueOf(fontSize), " Tf");
        this.writeln(Float.valueOf(fontSize + leading), " TL");
        this.writeln("1 0 0 -1 ", x, " ", y, " cm");
        str = str.replaceAll("[\r\n]", "");
        this.writeln("(", str, ") Tj");
        this.writeln("ET Q");
    }

    @Override
    public void setStroke(Stroke s) {
        super.setStroke(s);
        if (s instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)s;
            this.writeln(Float.valueOf(bs.getLineWidth()), " w");
            this.writeln(STROKE_LINEJOIN.get(bs.getLineJoin()), " j");
            this.writeln(STROKE_ENDCAPS.get(bs.getEndCap()), " J");
            this.writeln("[", DataUtils.join(" ", bs.getDashArray()), "] ", Float.valueOf(bs.getDashPhase()), " d");
        }
    }

    @Override
    protected void writeImage(Image img, int imgWidth, int imgHeight, double x, double y, double width, double height) {
        BufferedImage bufferedImg = GraphicsUtils.toBufferedImage(img);
        String imageResourceId = this.getImageResource(bufferedImg);
        this.write("q ");
        AffineTransform txCurrent = this.getTransform();
        if (!txCurrent.isIdentity()) {
            double[] matrix = new double[6];
            txCurrent.getMatrix(matrix);
            this.write(DataUtils.join(" ", matrix), " cm ");
        }
        this.write(width, " 0 0 ", height, " ", x - 2.0, " ", y - 2.0, " cm ");
        this.write("1 0 0 -1 0 1 cm ");
        this.write("/", imageResourceId, " Do ");
        this.writeln("Q");
    }

    @Override
    public void setColor(Color c) {
        if (c != null) {
            super.setColor(c);
            double a = (double)c.getAlpha() / 255.0;
            String transpResourceId = this.getTransparencyResource(a);
            this.writeln("/", transpResourceId, " gs");
            double r = (double)c.getRed() / 255.0;
            double g = (double)c.getGreen() / 255.0;
            double b = (double)c.getBlue() / 255.0;
            this.write(r, " ", g, " ", b, " rg ");
            this.writeln(r, " ", g, " ", b, " RG");
        }
    }

    @Override
    public void setClip(Shape clip) {
        if (this.getClip() != null) {
            this.writeln("Q");
        }
        super.setClip(clip);
        if (this.getClip() != null) {
            this.writeln("q");
            this.writeShape(this.getClip());
            this.writeln(" W n");
        }
    }

    @Override
    protected void writeHeader() {
        Rectangle2D bounds = this.getBounds();
        int x = (int)Math.floor(bounds.getX());
        int y = (int)Math.floor(bounds.getY());
        int w = (int)Math.ceil(bounds.getWidth());
        int h = (int)Math.ceil(bounds.getHeight());
        this.writeln("%PDF-1.4");
        this.writeObj("Type", "/Catalog", "Pages", "2 0 R");
        this.writeObj("Type", "/Pages", "Kids", "[3 0 R]", "Count", "1");
        this.writeObj("Type", "/Page", "Parent", "2 0 R", "MediaBox", String.format("[%d %d %d %d]", x, y, w, h), "Contents", "4 0 R", "Resources", "6 0 R");
        this.writeln(this.nextObjId(this.size()), " 0 obj");
        this.writeDict("Length", "5 0 R");
        this.writeln("stream");
        this.contentStart = this.size();
        this.writeln("q");
        this.writeln(this.scale, " 0 0 ", -this.scale, " " + this.scaledOffsetX + " ", (double)h - this.scaledOffsetY, " cm");
    }

    protected void writeDict(Object ... strs) {
        this.writeln("<<");
        int i = 0;
        while (i < strs.length) {
            this.writeln("/", strs[i], " ", strs[i + 1]);
            i += 2;
        }
        this.writeln(">>");
    }

    protected int writeObj(Object ... strs) {
        int objId = this.nextObjId(this.size());
        this.writeln(objId, " 0 obj");
        this.writeDict(strs);
        this.writeln("endobj");
        return objId;
    }

    protected int peekObjId() {
        return this.curObjId + 1;
    }

    private int nextObjId(int position) {
        this.objPositions.put(this.curObjId, position);
        return this.curObjId++;
    }

    protected String getTransparencyResource(double a) {
        String name = this.transpResources.get(a);
        if (name == null) {
            name = String.format("%s%d", TRANSPARENCY_RESOURCE_PREFIX, this.transpResources.size() + 1);
            this.transpResources.put(a, name);
        }
        return name;
    }

    protected String getImageResource(BufferedImage bufferedImg) {
        String name = this.imageResources.get(bufferedImg);
        if (name == null) {
            name = String.format("%s%d", IMAGE_RESOURCE_PREFIX, this.imageResources.size() + 1);
            this.imageResources.put(bufferedImg, name);
        }
        return name;
    }

    protected String getFontResource(Font font) {
        String name = this.fontResources.get(font);
        if (name == null) {
            name = String.format("%s%d", FONT_RESOURCE_PREFIX, this.fontResources.size() + 1);
            this.fontResources.put(font, name);
        }
        return name;
    }

    @Override
    protected void writeClosingDraw(Shape s) {
        this.writeln(" S");
    }

    @Override
    protected void writeClosingFill(Shape s) {
        this.writeln(" f");
        if (!(this.getPaint() instanceof Color)) {
            super.writeClosingFill(s);
        }
    }

    @Override
    protected void writeShape(Shape s) {
        s = this.getTransform().createTransformedShape(s);
        PathIterator segments = s.getPathIterator(null);
        double[] coordsCur = new double[6];
        double[] pointPrev = new double[2];
        int i = 0;
        while (!segments.isDone()) {
            if (i > 0) {
                this.write(" ");
            }
            int segmentType = segments.currentSegment(coordsCur);
            switch (segmentType) {
                case 0: {
                    this.write(coordsCur[0], " ", coordsCur[1], " m");
                    pointPrev[0] = coordsCur[0];
                    pointPrev[1] = coordsCur[1];
                    break;
                }
                case 1: {
                    this.write(coordsCur[0], " ", coordsCur[1], " l");
                    pointPrev[0] = coordsCur[0];
                    pointPrev[1] = coordsCur[1];
                    break;
                }
                case 3: {
                    this.write(coordsCur[0], " ", coordsCur[1], " ", coordsCur[2], " ", coordsCur[3], " ", coordsCur[4], " ", coordsCur[5], " c");
                    pointPrev[0] = coordsCur[4];
                    pointPrev[1] = coordsCur[5];
                    break;
                }
                case 2: {
                    double x1 = pointPrev[0] + 0.6666666666666666 * (coordsCur[0] - pointPrev[0]);
                    double y1 = pointPrev[1] + 0.6666666666666666 * (coordsCur[1] - pointPrev[1]);
                    double x2 = coordsCur[0] + 0.3333333333333333 * (coordsCur[2] - coordsCur[0]);
                    double y2 = coordsCur[1] + 0.3333333333333333 * (coordsCur[3] - coordsCur[1]);
                    double x3 = coordsCur[2];
                    double y3 = coordsCur[3];
                    this.write(x1, " ", y1, " ", x2, " ", y2, " ", x3, " ", y3, " c");
                    pointPrev[0] = x3;
                    pointPrev[1] = y3;
                    break;
                }
                case 4: {
                    this.write("h");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown path operation.");
                }
            }
            ++i;
            segments.next();
        }
    }

    private String getPdf(BufferedImage bufferedImg) {
        int width = bufferedImg.getWidth();
        int height = bufferedImg.getHeight();
        int bands = bufferedImg.getSampleModel().getNumBands();
        StringBuffer str = new StringBuffer(width * height * bands * 2);
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int pixel = bufferedImg.getRGB(x, y) & 0xFFFFFF;
                if (bands >= 3) {
                    String hex = String.format("%06x", pixel);
                    str.append(hex);
                } else if (bands == 1) {
                    str.append(String.format("%02x", pixel));
                }
                ++x;
            }
            str.append('\n');
            ++y;
        }
        return str.append('>').toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected String getFooter() {
        String resourceId;
        StringBuffer footer = new StringBuffer();
        if (this.getClip() != null) {
            footer.append("Q\n");
        }
        footer.append("Q");
        int contentEnd = this.size() + footer.length();
        footer.append('\n');
        footer.append("endstream\n");
        footer.append("endobj\n");
        int lenObjId = this.nextObjId(this.size() + footer.length());
        footer.append(lenObjId).append(" 0 obj\n");
        footer.append(contentEnd - this.contentStart).append('\n');
        footer.append("endobj\n");
        int resourcesObjId = this.nextObjId(this.size() + footer.length());
        footer.append(resourcesObjId).append(" 0 obj\n");
        footer.append("<<\n");
        footer.append(" /ProcSet [/PDF /Text /ImageB /ImageC /ImageI]\n");
        if (!this.fontResources.isEmpty()) {
            footer.append(" /Font <<\n");
            for (Map.Entry<Font, String> entry : this.fontResources.entrySet()) {
                Font font = entry.getKey();
                resourceId = entry.getValue();
                footer.append("  /").append(resourceId).append(" << /Type /Font").append(" /Subtype /").append("TrueType").append(" /BaseFont /").append(font.getPSName()).append(" >>\n");
            }
            footer.append(" >>\n");
        }
        if (!this.imageResources.isEmpty()) {
            footer.append(" /XObject <<\n");
            boolean bl = false;
            for (Map.Entry<BufferedImage, String> entry : this.imageResources.entrySet()) {
                void var5_14;
                resourceId = entry.getValue();
                footer.append("  /").append(resourceId).append(' ').append(this.curObjId + var5_14).append(" 0 R\n");
                ++var5_14;
            }
            footer.append(" >>\n");
        }
        if (!this.transpResources.isEmpty()) {
            footer.append(" /ExtGState <<\n");
            for (Map.Entry<Double, String> entry : this.transpResources.entrySet()) {
                Double alpha = entry.getKey();
                resourceId = entry.getValue();
                footer.append("  /").append(resourceId).append(" << /Type /ExtGState").append(" /ca ").append(alpha).append(" /CA ").append(alpha).append(" >>\n");
            }
            footer.append(" >>\n");
        }
        footer.append(">>\n");
        footer.append("endobj\n");
        for (BufferedImage bufferedImage : this.imageResources.keySet()) {
            int imageObjId = this.nextObjId(this.size() + footer.length());
            footer.append(imageObjId).append(" 0 obj\n");
            footer.append("<<\n");
            String imageData = this.getPdf(bufferedImage);
            footer.append("/Type /XObject\n").append("/Subtype /Image\n").append("/Width ").append(bufferedImage.getWidth()).append('\n').append("/Height ").append(bufferedImage.getHeight()).append('\n').append("/ColorSpace /DeviceRGB\n").append("/BitsPerComponent 8\n").append("/Length ").append(imageData.length()).append('\n').append("/Filter /ASCIIHexDecode\n").append(">>\n").append("stream\n").append(imageData).append("\nendstream\n").append("endobj\n");
        }
        int n = this.objPositions.size() + 1;
        int n2 = this.size() + footer.length();
        footer.append("xref\n");
        footer.append("0 ").append(n).append('\n');
        footer.append(String.format("%010d %05d", 0, 65535)).append(" f \n");
        for (int pos : this.objPositions.values()) {
            footer.append(String.format("%010d %05d", pos, 0)).append(" n \n");
        }
        footer.append("trailer\n");
        footer.append("<<\n");
        footer.append("/Size ").append(n).append('\n');
        footer.append("/Root 1 0 R\n");
        footer.append(">>\n");
        footer.append("startxref\n");
        footer.append(n2).append('\n');
        footer.append("%%EOF\n");
        return footer.toString();
    }

    /*
     * WARNING - void declaration
     */
    public void writeFooter(Writer out) throws IOException {
        String resourceId;
        StringBuffer footer = new StringBuffer();
        if (this.getClip() != null) {
            footer.append("Q\n");
        }
        footer.append("Q");
        int contentEnd = this.size() + footer.length();
        footer.append('\n');
        footer.append("endstream\n");
        footer.append("endobj\n");
        int lenObjId = this.nextObjId(this.size() + footer.length());
        footer.append(lenObjId).append(" 0 obj\n");
        footer.append(contentEnd - this.contentStart).append('\n');
        footer.append("endobj\n");
        int resourcesObjId = this.nextObjId(this.size() + footer.length());
        footer.append(resourcesObjId).append(" 0 obj\n");
        footer.append("<<\n");
        footer.append(" /ProcSet [/PDF /Text /ImageB /ImageC /ImageI]\n");
        out.write(footer.toString());
        footer = new StringBuffer();
        if (!this.fontResources.isEmpty()) {
            footer.append(" /Font <<\n");
            for (Map.Entry<Font, String> entry : this.fontResources.entrySet()) {
                Font font = entry.getKey();
                resourceId = entry.getValue();
                footer.append("  /").append(resourceId).append(" << /Type /Font").append(" /Subtype /").append("TrueType").append(" /BaseFont /").append(font.getPSName()).append(" >>\n");
            }
            footer.append(" >>\n");
        }
        if (!this.imageResources.isEmpty()) {
            footer.append(" /XObject <<\n");
            boolean bl = false;
            for (Map.Entry<BufferedImage, String> entry : this.imageResources.entrySet()) {
                void var6_15;
                resourceId = entry.getValue();
                footer.append("  /").append(resourceId).append(' ').append(this.curObjId + var6_15).append(" 0 R\n");
                ++var6_15;
            }
            footer.append(" >>\n");
        }
        if (!this.transpResources.isEmpty()) {
            footer.append(" /ExtGState <<\n");
            for (Map.Entry<Double, String> entry : this.transpResources.entrySet()) {
                Double alpha = entry.getKey();
                resourceId = entry.getValue();
                footer.append("  /").append(resourceId).append(" << /Type /ExtGState").append(" /ca ").append(alpha).append(" /CA ").append(alpha).append(" >>\n");
            }
            footer.append(" >>\n");
        }
        footer.append(">>\n");
        footer.append("endobj\n");
        out.write(footer.toString());
        footer = new StringBuffer();
        for (BufferedImage bufferedImage : this.imageResources.keySet()) {
            int imageObjId = this.nextObjId(this.size() + footer.length());
            footer.append(imageObjId).append(" 0 obj\n");
            footer.append("<<\n");
            String imageData = this.getPdf(bufferedImage);
            footer.append("/Type /XObject\n").append("/Subtype /Image\n").append("/Width ").append(bufferedImage.getWidth()).append('\n').append("/Height ").append(bufferedImage.getHeight()).append('\n').append("/ColorSpace /DeviceRGB\n").append("/BitsPerComponent 8\n").append("/Length ").append(imageData.length()).append('\n').append("/Filter /ASCIIHexDecode\n").append(">>\n").append("stream\n");
            out.write(footer.toString());
            out.write(imageData);
            out.write("\nendstream\n");
            out.write("endobj\n");
            footer = new StringBuffer();
        }
        int n = this.objPositions.size() + 1;
        int n2 = this.size() + footer.length();
        footer.append("xref\n");
        footer.append("0 ").append(n).append('\n');
        footer.append(String.format("%010d %05d", 0, 65535)).append(" f \n");
        for (int pos : this.objPositions.values()) {
            footer.append(String.format("%010d %05d", pos, 0)).append(" n \n");
        }
        footer.append("trailer\n");
        footer.append("<<\n");
        footer.append("/Size ").append(n).append('\n');
        footer.append("/Root 1 0 R\n");
        footer.append(">>\n");
        footer.append("startxref\n");
        footer.append(n2).append('\n');
        footer.append("%%EOF\n");
        out.write(footer.toString());
    }

    @Override
    public String toString() {
        String doc = super.getDocument().toString();
        return doc;
    }

    @Override
    public byte[] getBytes() {
        try {
            return this.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return super.getBytes();
        }
    }
}

