/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.xmind.core.ILegend;
import org.xmind.core.IPositioned;
import org.xmind.core.ISheet;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.commands.ModifyLegendVisibilityCommand;
import org.xmind.ui.commands.ModifyPositionCommand;
import org.xmind.ui.internal.editpolicies.MindMapPolicyBase;
import org.xmind.ui.internal.editpolicies.PropertyCommandBuilder;
import org.xmind.ui.internal.layouts.SheetIntersectionSolver;
import org.xmind.ui.mindmap.IMindMapViewer;
import org.xmind.ui.mindmap.ISheetPart;
import org.xmind.ui.util.MindMapUtils;

public class MapPolicy
extends MindMapPolicyBase {
    public boolean understands(String requestType) {
        return super.understands(requestType) || "show_legend".equals(requestType) || "hide_legend".equals(requestType) || "tile".equals(requestType);
    }

    public void handle(Request request) {
        String type = request.getType();
        if ("show_legend".equals(type)) {
            this.modifyLegendVisibility(request, true);
        } else if ("hide_legend".equals(type)) {
            this.modifyLegendVisibility(request, false);
        } else if ("tile".equals(type)) {
            this.tile(request);
        }
    }

    private void tile(Request request) {
        ISheetPart sheet = this.getSheetPart(request);
        SheetIntersectionSolver intersectionSolver = new SheetIntersectionSolver();
        Point origin = ((IReferencedFigure)sheet.getFigure()).getOrigin();
        intersectionSolver.setOrigin(origin);
        intersectionSolver.recordInitPositions(sheet, false);
        intersectionSolver.solve();
        Collection keys = intersectionSolver.getKeys("free");
        ArrayList<ModifyPositionCommand> commands = new ArrayList<ModifyPositionCommand>(keys.size());
        for (Object key : keys) {
            IGraphicalPart part;
            Object o;
            if (!(key instanceof IGraphicalPart) || !((o = MindMapUtils.getRealModel((IPart)(part = (IGraphicalPart)key))) instanceof IPositioned)) continue;
            IPositioned p = (IPositioned)o;
            Point pos = intersectionSolver.getSolvedPosition(key);
            pos = this.toRelative(pos, origin);
            commands.add(new ModifyPositionCommand(p, MindMapUtils.toModelPosition(pos)));
        }
        if (commands.isEmpty()) {
            return;
        }
        CompoundCommand cmd = new CompoundCommand(commands);
        cmd.setLabel(CommandMessages.Command_Tile);
        this.saveAndRun((Command)cmd, request.getTargetDomain());
    }

    private Point toRelative(Point pos, Point origin) {
        Dimension offset = pos.getDifference(origin);
        return new Point(offset.width, offset.height);
    }

    private ISheetPart getSheetPart(Request request) {
        IPart target = request.getPrimaryTarget();
        if (target instanceof ISheetPart) {
            return (ISheetPart)target;
        }
        IViewer viewer = request.getTargetViewer();
        if (viewer instanceof IMindMapViewer) {
            return ((IMindMapViewer)viewer).getSheetPart();
        }
        return null;
    }

    private void modifyLegendVisibility(Request request, boolean visible) {
        ILegend legend = this.getLegend(request);
        if (legend == null) {
            return;
        }
        PropertyCommandBuilder builder = new PropertyCommandBuilder(request);
        if (!builder.canStart()) {
            return;
        }
        builder.start();
        builder.setLabel(visible ? CommandMessages.Command_ShowLegend : CommandMessages.Command_HideLegend);
        builder.add((Command)new ModifyLegendVisibilityCommand(legend, visible), true);
        builder.addSource(legend, false);
        builder.end();
    }

    private ILegend getLegend(Request request) {
        ISheet sheet;
        IViewer viewer;
        IPart target = request.getPrimaryTarget();
        if (target != null) {
            Object m = MindMapUtils.getRealModel(target);
            if (m instanceof ISheet) {
                return ((ISheet)m).getLegend();
            }
            if (m instanceof ILegend) {
                return (ILegend)m;
            }
        }
        if ((viewer = request.getTargetViewer()) instanceof IMindMapViewer && (sheet = ((IMindMapViewer)viewer).getSheet()) != null) {
            return sheet.getLegend();
        }
        return null;
    }
}

