/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import org.eclipse.draw2d.geometry.Point;
import org.xmind.core.IControlPoint;
import org.xmind.core.IPositioned;
import org.xmind.core.IRelationship;
import org.xmind.core.IRelationshipEnd;
import org.xmind.core.ISheet;
import org.xmind.core.ITitled;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.gef.IViewer;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.ui.commands.AddRelationshipCommand;
import org.xmind.ui.commands.AddTopicCommand;
import org.xmind.ui.commands.CommandBuilder;
import org.xmind.ui.commands.CreateRelationshipCommand;
import org.xmind.ui.commands.CreateTopicCommand;
import org.xmind.ui.commands.ModifyPositionCommand;
import org.xmind.ui.commands.ModifyRelationshipEndCommand;
import org.xmind.ui.commands.ModifyTitleTextCommand;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.util.MindMapUtils;

public class RelationshipCreateCommandBuilder
extends CommandBuilder {
    private ISheet parent;
    private IRelationshipEnd end1;

    public RelationshipCreateCommandBuilder(IViewer viewer, CommandBuilder delegate, ISheet parent, IRelationshipEnd end1) {
        super(viewer, delegate);
        this.parent = parent;
        this.end1 = end1;
    }

    public RelationshipCreateCommandBuilder(IViewer viewer, ICommandStack commandStack, ISheet parent, IRelationshipEnd end1) {
        super(viewer, commandStack);
        this.parent = parent;
        this.end1 = end1;
    }

    public void create(IRelationshipEnd end2) {
        this.createRelationship(end2, true);
    }

    public void create(Point targetPosition) {
        CreateTopicCommand createTopic = new CreateTopicCommand(this.parent.getOwnedWorkbook());
        this.add((Command)createTopic, true);
        ITopic end2 = (ITopic)createTopic.getSource();
        this.add((Command)new ModifyTitleTextCommand((ITitled)end2, MindMapMessages.TitleText_FloatingTopic), false);
        this.add((Command)new ModifyPositionCommand((IPositioned)end2, MindMapUtils.toModelPosition(targetPosition)), false);
        ITopic rootTopic = (ITopic)this.getViewer().getAdapter(ITopic.class);
        if (rootTopic == null) {
            rootTopic = this.parent.getRootTopic();
        }
        this.add((Command)new AddTopicCommand(end2, rootTopic, -1, "detached"), false);
        this.createRelationship((IRelationshipEnd)end2, false);
    }

    private void createRelationship(IRelationshipEnd end2, boolean relationshipCollectalbe) {
        IWorkbook workbook = this.parent.getOwnedWorkbook();
        CreateRelationshipCommand create = new CreateRelationshipCommand(workbook);
        this.add((Command)create, relationshipCollectalbe);
        IRelationship rel = (IRelationship)create.getSource();
        IControlPoint cp1 = rel.getControlPoint(0);
        IControlPoint cp2 = rel.getControlPoint(1);
        cp1.setPolarAngle(0.2617993877991494);
        cp1.setPolarAmount(0.3);
        cp2.setPolarAngle(0.2617993877991494);
        cp2.setPolarAmount(0.3);
        this.add((Command)new ModifyRelationshipEndCommand(rel, this.end1.getId(), true), false);
        this.add((Command)new ModifyRelationshipEndCommand(rel, end2.getId(), false), false);
        this.add((Command)new AddRelationshipCommand(rel, this.parent), false);
    }
}

