/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.protocols;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.Core;
import org.xmind.core.IFileEntry;
import org.xmind.core.IManifest;
import org.xmind.core.INamed;
import org.xmind.core.ITitled;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventSource2;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.editor.MME;
import org.xmind.ui.mindmap.IHyperlinked;
import org.xmind.ui.mindmap.IProtocol;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.Logger;
import org.xmind.ui.util.MindMapUtils;

public class AttachmentProtocol
implements IProtocol {
    private Map<IWorkbook, Map<String, IAction>> actions = null;

    @Override
    public IAction createOpenHyperlinkAction(Object context, String uri) {
        IAction action;
        Map<String, IAction> wbActions;
        if (uri == null) {
            return null;
        }
        String path = HyperlinkUtils.toAttachmentPath((String)uri);
        if (path == null) {
            return null;
        }
        IWorkbook workbook = MindMapUtils.findWorkbook(context);
        if (workbook == null) {
            return null;
        }
        ITopic topic = null;
        if (context instanceof IAdaptable) {
            topic = (ITopic)((IAdaptable)context).getAdapter(ITopic.class);
        }
        if (this.actions == null) {
            this.actions = new HashMap<IWorkbook, Map<String, IAction>>();
        }
        if ((wbActions = this.actions.get(workbook)) == null) {
            wbActions = new HashMap<String, IAction>();
            this.actions.put(workbook, wbActions);
        }
        if ((action = wbActions.get(uri)) == null) {
            action = this.createOpenAttachmentAction(AttachmentProtocol.getWindow(context), workbook, path, AttachmentProtocol.getFileName(context), topic);
            wbActions.put(uri, action);
        }
        return action;
    }

    private IAction createOpenAttachmentAction(IWorkbenchWindow window, IWorkbook workbook, String path, String fileName, ITopic topic) {
        AttachmentAction action = new AttachmentAction(window, workbook, path, fileName, topic);
        action.setText(MindMapMessages.OpenAttachment_text);
        action.setToolTipText(fileName);
        ImageDescriptor image = null;
        if (!this.existsEntryFile(workbook, path)) {
            image = MindMapUI.getImages().get("unknownfile.gif", true);
        } else {
            image = MindMapUI.getImages().getFileIcon(path, true);
            if (image == null) {
                IFileEntry e = workbook.getManifest().getFileEntry(path);
                image = e != null && e.isDirectory() ? MindMapUI.getImages().get("fldr_obj.gif", true) : MindMapUI.getImages().get("unknownfile.gif", true);
            }
        }
        action.setImageDescriptor(image);
        return action;
    }

    private boolean existsEntryFile(IWorkbook workbook, String path) {
        IManifest manifest = workbook.getManifest();
        IFileEntry fileEntry = manifest.getFileEntry(path);
        return fileEntry != null && fileEntry.getSize() > 0L;
    }

    private static String getFileName(Object context) {
        if (context instanceof IAdaptable) {
            Object adapter = ((IAdaptable)context).getAdapter(ITitled.class);
            if (adapter == null) {
                adapter = ((IAdaptable)context).getAdapter(INamed.class);
            }
            if (adapter != null) {
                context = adapter;
            }
        }
        if (context instanceof ITitled) {
            return ((ITitled)context).getTitleText();
        }
        if (context instanceof INamed) {
            return ((INamed)context).getName();
        }
        return null;
    }

    private static IWorkbenchWindow getWindow(Object context) {
        if (context instanceof IAdaptable) {
            Object adapter = ((IAdaptable)context).getAdapter(IWorkbenchWindow.class);
            if (adapter == null) {
                adapter = ((IAdaptable)context).getAdapter(IEditorPart.class);
                if (adapter == null) {
                    adapter = ((IAdaptable)context).getAdapter(IWorkbenchPart.class);
                }
                if (adapter instanceof IWorkbenchPart) {
                    adapter = ((IWorkbenchPart)adapter).getSite().getWorkbenchWindow();
                }
            }
            if (adapter instanceof IWorkbenchWindow) {
                return (IWorkbenchWindow)adapter;
            }
        }
        if (context instanceof IWorkbenchWindow) {
            return (IWorkbenchWindow)context;
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public String getProtocolName() {
        return HyperlinkUtils.getAttachmentProtocolName();
    }

    @Override
    public boolean isHyperlinkModifiable(Object source, String uri) {
        return false;
    }

    private static class AttachmentAction
    extends Action
    implements IHyperlinked {
        private IWorkbenchWindow window;
        private IWorkbook workbook;
        private String path;
        private String fileName;
        private ITopic topic;
        private IWindowListener windowListener;
        private long modificationTime = -1L;

        public AttachmentAction(IWorkbenchWindow window, IWorkbook workbook, String path, String fileName, ITopic topic) {
            this.window = window;
            this.workbook = workbook;
            this.path = path;
            this.topic = topic;
            this.fileName = fileName;
        }

        public void run() {
            String entryMediaType;
            String hiberLoc = Core.getWorkspace().getAbsolutePath(".temp-attachments");
            String[] tmps = this.path.split("/");
            int i = 0;
            while (i < tmps.length - 1) {
                hiberLoc = String.valueOf(hiberLoc) + File.separator + tmps[i];
                ++i;
            }
            File hiberDir = new File(hiberLoc);
            if (!hiberDir.exists()) {
                hiberDir.mkdirs();
            }
            String absolutelyFileName = this.fileName.endsWith(entryMediaType = this.path.substring(this.path.lastIndexOf("."))) ? this.fileName : String.valueOf(this.fileName) + entryMediaType;
            absolutelyFileName = MindMapUtils.trimFileName(absolutelyFileName);
            File hiberFile = new File(hiberDir, absolutelyFileName);
            IManifest manifest = this.workbook.getManifest();
            IFileEntry fileEntry = manifest.getFileEntry(this.path);
            try {
                InputStream is = fileEntry.openInputStream();
                FileOutputStream os = new FileOutputStream(hiberFile);
                FileUtils.transfer((InputStream)is, (OutputStream)os);
            }
            catch (IOException e) {
                Logger.log(e, "Failed to transfer attachment to temp-attachments dir.");
                return;
            }
            if (!hiberFile.exists()) {
                return;
            }
            MME.launch(this.window, hiberFile.getAbsolutePath(), this.fileName);
            if (this.workbook instanceof ICoreEventSource2) {
                ((ICoreEventSource2)this.workbook).registerOnceCoreEventListener("workbookPreSaveOnce", ICoreEventListener.NULL);
            }
            this.addSaveBackSupport(hiberFile, fileEntry);
        }

        private void addSaveBackSupport(final File hiberFile, final IFileEntry fileEntry) {
            this.modificationTime = hiberFile.lastModified();
            IEditorPart activeEditor = this.window.getActivePage().getActiveEditor();
            if (activeEditor instanceof IGraphicalEditor) {
                final IGraphicalEditorPage currentPage = ((IGraphicalEditor)activeEditor).getActivePageInstance();
                ((IGraphicalEditor)activeEditor).addPageChangedListener(new IPageChangedListener(){

                    public void pageChanged(PageChangedEvent event) {
                        if (event.getSelectedPage() == currentPage) {
                            AttachmentAction.this.saveEntryBack(fileEntry, hiberFile);
                        }
                    }
                });
            }
            if (this.window != null) {
                this.window.getWorkbench().addWindowListener(this.getWindowListener(fileEntry, hiberFile));
            }
            this.window.getActivePage().addPartListener(new IPartListener(){

                public void partOpened(IWorkbenchPart part) {
                }

                public void partDeactivated(IWorkbenchPart part) {
                }

                public void partClosed(IWorkbenchPart part) {
                    AttachmentAction.this.saveEntryBack(fileEntry, hiberFile);
                    AttachmentAction.this.window.getWorkbench().removeWindowListener(AttachmentAction.this.getWindowListener(null, null));
                }

                public void partBroughtToTop(IWorkbenchPart part) {
                }

                public void partActivated(IWorkbenchPart part) {
                }
            });
        }

        private IWindowListener getWindowListener(final IFileEntry fileEntry, final File hiberFile) {
            if (this.windowListener == null) {
                this.windowListener = new IWindowListener(){

                    public void windowOpened(IWorkbenchWindow window) {
                    }

                    public void windowDeactivated(IWorkbenchWindow window) {
                    }

                    public void windowClosed(IWorkbenchWindow window) {
                    }

                    public void windowActivated(IWorkbenchWindow window) {
                        AttachmentAction.this.saveEntryBack(fileEntry, hiberFile);
                    }
                };
            }
            return this.windowListener;
        }

        private void saveEntryBack(IFileEntry fileEntry, File hiberFile) {
            if (this.modificationTime == hiberFile.lastModified()) {
                return;
            }
            try {
                IFileEntry newEntry = this.workbook.getManifest().createAttachmentFromStream((InputStream)new FileInputStream(hiberFile), this.fileName, fileEntry.getMediaType());
                if (this.topic != null) {
                    this.topic.setHyperlink(HyperlinkUtils.toAttachmentURL((String)newEntry.getPath()));
                }
                this.modificationTime = hiberFile.lastModified();
            }
            catch (IOException e) {
                Logger.log(e, "Failed to transfer temp-attachments to attachment dir.");
                return;
            }
        }

        @Override
        public String getHyperlink() {
            return this.path;
        }
    }
}

