/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.activities.ITriggerPoint;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.WizardCollectionElement;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardNode;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.wizards.ImportExportPage;

public class ExportPage
extends ImportExportPage {
    private static final String STORE_SELECTED_EXPORT_WIZARD_ID = "ImportExportPage.STORE_SELECTED_EXPORT_WIZARD_ID";
    private static final String STORE_EXPANDED_EXPORT_CATEGORIES = "ImportExportPage.STORE_EXPANDED_EXPORT_CATEGORIES";
    private static final String STORE_RECENTLY_USED_WIZARD_IDS = "ImportExportPage.store_recently_used_wizard_ids";
    private static final String WIZARD_ID_SPLIT = ";";
    private static final int RECENTLY_USED_WIZARD_ID_SIZE = 5;
    private ImportExportPage.CategorizedWizardSelectionTree exportTree;

    public ExportPage(IWorkbench aWorkbench, IStructuredSelection currentSelection) {
        super(aWorkbench, currentSelection);
        this.wizardsOrder = ImportExportPage.getWizardsOrder("export-wizards");
    }

    @Override
    protected void initialize() {
        this.workbench.getHelpSystem().setHelp(this.getControl(), "org.eclipse.ui.export_wizard_selection_wizard_page_context");
    }

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        final IPageChangingListener listener = new IPageChangingListener(){

            public void handlePageChanging(PageChangingEvent event) {
                if (event.getCurrentPage() == ExportPage.this) {
                    IWizardDescriptor wizardDescriptor = ((WorkbenchWizardNode)ExportPage.this.getSelectedNode()).getWizardElement();
                    String selectedId = wizardDescriptor.getId();
                    List recentWizardIds = ExportPage.this.getRecentWizardIds();
                    if (recentWizardIds.contains(selectedId)) {
                        recentWizardIds.remove(selectedId);
                    }
                    if (recentWizardIds.size() > 4) {
                        recentWizardIds.remove(4);
                    }
                    recentWizardIds.add(0, selectedId);
                    ExportPage.this.putRecentWizardIds(recentWizardIds);
                }
            }
        };
        ((WizardDialog)this.getContainer()).addPageChangingListener(listener);
        this.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ExportPage.this.getContainer() != null) {
                    ((WizardDialog)ExportPage.this.getContainer()).removePageChangingListener(listener);
                }
            }
        });
    }

    private List<String> getRecentWizardIds() {
        String recentIds = this.getDialogSettings().get(STORE_RECENTLY_USED_WIZARD_IDS);
        if (recentIds != null && !recentIds.equals("")) {
            String[] ids = recentIds.split(WIZARD_ID_SPLIT);
            return new ArrayList<String>(Arrays.asList(ids));
        }
        return new ArrayList<String>();
    }

    private void putRecentWizardIds(List<String> recentWizardIds) {
        String recentIds = "";
        if (recentWizardIds.size() >= 1) {
            recentIds = String.valueOf(recentIds) + recentWizardIds.get(0);
        }
        if (recentWizardIds.size() >= 2) {
            int i = 1;
            while (i < recentWizardIds.size()) {
                recentIds = String.valueOf(recentIds) + WIZARD_ID_SPLIT + recentWizardIds.get(i);
                ++i;
            }
        }
        this.getDialogSettings().put(STORE_RECENTLY_USED_WIZARD_IDS, recentIds);
    }

    @Override
    protected Composite createTreeViewer(Composite parent) {
        IWizardCategory root = WorkbenchPlugin.getDefault().getExportWizardRegistry().getRootCategory();
        root = this.insertRecentWizards(root);
        this.exportTree = new ImportExportPage.CategorizedWizardSelectionTree(root, WorkbenchMessages.ExportWizard_selectWizard);
        Composite exportComp = this.exportTree.createControl(parent);
        this.exportTree.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExportPage.this.listSelectionChanged(event.getSelection());
            }
        });
        this.exportTree.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ExportPage.this.treeDoubleClicked(event);
            }
        });
        this.setTreeViewer(this.exportTree.getViewer());
        return exportComp;
    }

    private IWizardCategory insertRecentWizards(IWizardCategory root) {
        List<String> recentWizardIds = this.getRecentWizardIds();
        if (recentWizardIds.size() == 0) {
            return root;
        }
        ArrayList<IWizardDescriptor> wizardDescriptors = new ArrayList<IWizardDescriptor>();
        this.collectWizardDescriptors(wizardDescriptors, root);
        ArrayList<IWizardDescriptor> recentWizards = new ArrayList<IWizardDescriptor>();
        block0: for (String wizardId : recentWizardIds) {
            for (IWizardDescriptor wizardDescriptor : wizardDescriptors) {
                if (!wizardId.contains(wizardDescriptor.getId())) continue;
                recentWizards.add(wizardDescriptor);
                continue block0;
            }
        }
        if (recentWizards.size() == 0) {
            return root;
        }
        WizardCollectionElement newRoot = new WizardCollectionElement("root", null, "root", null);
        WizardCollectionElement recentCategory = new WizardCollectionElement("recentlyUsed", null, MindMapMessages.ExportPage_Categore_Recent_name, newRoot);
        for (IWizardDescriptor wizardDescriptor : recentWizards) {
            WorkbenchWizardElement newDescriptor = new WorkbenchWizardElement(((WorkbenchWizardElement)wizardDescriptor).getConfigurationElement());
            newDescriptor.setParent(recentCategory);
            recentCategory.add((IAdaptable)newDescriptor);
        }
        newRoot.add((IAdaptable)recentCategory);
        IWizardCategory[] iWizardCategoryArray = root.getCategories();
        int n = iWizardCategoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardCategory wizardCategory = iWizardCategoryArray[n2];
            newRoot.add((IAdaptable)((WizardCollectionElement)wizardCategory));
            ++n2;
        }
        iWizardCategoryArray = root.getWizards();
        n = iWizardCategoryArray.length;
        n2 = 0;
        while (n2 < n) {
            IWizardDescriptor wizardDescriptor;
            wizardDescriptor = iWizardCategoryArray[n2];
            newRoot.add((IAdaptable)wizardDescriptor);
            ++n2;
        }
        return newRoot;
    }

    private void collectWizardDescriptors(List<IWizardDescriptor> descriptors, IWizardCategory wizardCategory) {
        if (wizardCategory != null) {
            descriptors.addAll(Arrays.asList(wizardCategory.getWizards()));
            IWizardCategory[] iWizardCategoryArray = wizardCategory.getCategories();
            int n = iWizardCategoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardCategory category = iWizardCategoryArray[n2];
                this.collectWizardDescriptors(descriptors, category);
                ++n2;
            }
        }
    }

    @Override
    public void saveWidgetValues() {
        this.storeExpandedCategories(STORE_EXPANDED_EXPORT_CATEGORIES, this.exportTree.getViewer());
        this.storeSelectedCategoryAndWizard(STORE_SELECTED_EXPORT_WIZARD_ID, this.exportTree.getViewer());
        super.saveWidgetValues();
    }

    @Override
    protected void restoreWidgetValues() {
        IWizardCategory exportRoot = WorkbenchPlugin.getDefault().getExportWizardRegistry().getRootCategory();
        this.expandPreviouslyExpandedCategories(STORE_EXPANDED_EXPORT_CATEGORIES, exportRoot, this.exportTree.getViewer());
        this.selectPreviouslySelected(STORE_SELECTED_EXPORT_WIZARD_ID, exportRoot, this.exportTree.getViewer());
        super.restoreWidgetValues();
    }

    @Override
    protected ITriggerPoint getTriggerPoint() {
        return this.getWorkbench().getActivitySupport().getTriggerPointManager().getTriggerPoint("org.eclipse.ui.exportWizards");
    }

    @Override
    protected void updateMessage() {
        this.setMessage(WorkbenchMessages.ImportExportPage_chooseExportWizard);
        super.updateMessage();
    }

    @Override
    protected void expandPreviouslyExpandedCategories(String setting, IWizardCategory wizardCategories, TreeViewer viewer) {
        String[] expandedCategoryPaths = this.getDialogSettings().getArray(setting);
        if (expandedCategoryPaths == null || expandedCategoryPaths.length == 0) {
            return;
        }
        List<String> idList = Arrays.asList(expandedCategoryPaths);
        IWizardCategory[] iWizardCategoryArray = wizardCategories.getCategories();
        int n = iWizardCategoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardCategory category = iWizardCategoryArray[n2];
            if (!idList.contains(category.getId())) {
                viewer.setExpandedState((Object)wizardCategories.findCategory((IPath)new Path(category.getId())), false);
            }
            ++n2;
        }
    }
}

