/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.xmind.ui.io.FileDownloadTarget;
import org.xmind.ui.io.IDownloadTarget;
import org.xmind.ui.io.Messages;
import org.xmind.ui.io.MonitoredInputStream;
import org.xmind.ui.io.MonitoredOutputStream;

public class DownloadJob
extends Job {
    private String pluginId;
    private String sourceURL;
    private IDownloadTarget target;
    private URLConnection connection = null;

    public DownloadJob(String jobName, String sourceURL, String targetPath) {
        this(jobName, sourceURL, new FileDownloadTarget(targetPath, true), "org.xmind.ui.toolkit");
    }

    public DownloadJob(String jobName, String sourceURL, String targetPath, String pluginId) {
        this(jobName, sourceURL, new FileDownloadTarget(targetPath, true), pluginId);
    }

    public DownloadJob(String jobName, String sourceURL, IDownloadTarget target) {
        this(jobName, sourceURL, target, "org.xmind.ui.toolkit");
    }

    public DownloadJob(String jobName, String sourceURL, IDownloadTarget target, String pluginId) {
        super(jobName);
        Assert.isNotNull((Object)sourceURL);
        Assert.isNotNull((Object)target);
        this.sourceURL = sourceURL;
        this.target = target;
        this.pluginId = pluginId;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getSourceURL() {
        return this.sourceURL;
    }

    public String getTargetPath() {
        return this.target.getPath();
    }

    protected void setupConnection(URLConnection connection) {
    }

    protected IStatus validateConnection(URLConnection connection) {
        return null;
    }

    protected IStatus run(IProgressMonitor monitor) {
        Object status;
        try {
            status = this.runSafely(monitor);
        }
        catch (Throwable e) {
            status = e instanceof InterruptedIOException ? this.cancelStatus() : this.errorStatus(e);
        }
        if (this.target instanceof IDownloadTarget.IDownloadTarget2) {
            try {
                ((IDownloadTarget.IDownloadTarget2)((Object)this.target)).afterDownload((IStatus)status);
            }
            catch (Throwable throwable) {}
        }
        return status;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IStatus runSafely(IProgressMonitor monitor) throws Exception {
        Status status;
        OutputStream targetStream;
        InputStream sourceStream;
        int length;
        block28: {
            block27: {
                URLConnection connection;
                block26: {
                    monitor.beginTask(null, 100);
                    monitor.subTask(NLS.bind((String)Messages.ConnectingSource, (Object)this.getSourceURL()));
                    URL url = new URL(this.sourceURL);
                    connection = url.openConnection();
                    do {
                        this.setURLConnection(connection);
                        if (monitor.isCanceled()) {
                            return this.cancelStatus();
                        }
                        this.setupConnection(connection);
                        if (monitor.isCanceled()) {
                            return this.cancelStatus();
                        }
                        connection.connect();
                        if (monitor.isCanceled()) {
                            return this.cancelStatus();
                        }
                        int responseCode = ((HttpURLConnection)connection).getResponseCode();
                        if (responseCode != 301 && responseCode != 302) break block26;
                        String newLocation = connection.getHeaderField("Location");
                        connection = new URL(newLocation).openConnection();
                    } while (!monitor.isCanceled());
                    return this.cancelStatus();
                }
                IStatus consumed = this.validateConnection(connection);
                if (consumed != null) {
                    return consumed;
                }
                if (monitor.isCanceled()) {
                    return this.cancelStatus();
                }
                length = connection.getContentLength();
                if (monitor.isCanceled()) {
                    return this.cancelStatus();
                }
                sourceStream = connection.getInputStream();
                if (!monitor.isCanceled()) break block27;
                Status status2 = this.cancelStatus();
                {
                    catch (Throwable throwable) {
                        try {
                            sourceStream.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                }
                try {
                    sourceStream.close();
                    return status2;
                }
                catch (IOException iOException) {}
                return status2;
            }
            monitor.subTask(NLS.bind((String)Messages.InitializingTarget, (Object)this.getTargetPath()));
            targetStream = this.target.openOutputStream();
            if (!monitor.isCanceled()) break block28;
            Status status3 = this.cancelStatus();
            try {
                sourceStream.close();
                return status3;
            }
            catch (IOException iOException) {}
            return status3;
        }
        try {
            sourceStream = new MonitoredInputStream(sourceStream, monitor);
            targetStream = new MonitoredOutputStream(targetStream, monitor);
            monitor.subTask(Messages.TransferingData);
            this.transfer(sourceStream, targetStream, (IProgressMonitor)new SubProgressMonitor(monitor, 100), length);
            this.setURLConnection(null);
            monitor.done();
            status = new Status(0, this.pluginId, NLS.bind((String)Messages.DownloadFinished, (Object)this.getSourceURL(), (Object)this.getTargetPath()));
        }
        catch (Throwable throwable) {
            try {
                targetStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            targetStream.close();
        }
        catch (IOException iOException) {}
        try {
            sourceStream.close();
            return status;
        }
        catch (IOException iOException) {}
        return status;
    }

    private void transfer(InputStream sourceStream, OutputStream targetStream, IProgressMonitor monitor, int length) throws IOException {
        int num;
        monitor.beginTask(null, length < 0 ? 100 : Math.max(1, length / 1024));
        String total = length < 0 ? null : String.format("%.1fK", (double)length / 1024.0);
        byte[] buffer = new byte[1024];
        int downloaded = 0;
        int worked = 0;
        int newWorked = 0;
        while ((num = sourceStream.read(buffer)) > 0) {
            targetStream.write(buffer, 0, num);
            String taskName = total == null ? String.format("(%.1fK)", (double)downloaded / 1024.0) : String.format("(%.1fK/%s)", (double)(downloaded += num) / 1024.0, total);
            monitor.subTask(String.valueOf(Messages.TransferingData) + " " + taskName);
            newWorked = length < 0 ? Math.min(worked + 1, 99) : downloaded / 1024;
            if (newWorked <= worked) continue;
            monitor.worked(newWorked - worked);
            worked = newWorked;
        }
    }

    protected Status cancelStatus() {
        return new Status(8, this.pluginId, NLS.bind((String)Messages.DownloadCanceled, (Object)this.getSourceURL(), (Object)this.getTargetPath()));
    }

    protected IStatus errorStatus(Throwable e) {
        return new Status(4, this.pluginId, NLS.bind((String)Messages.DownloadFailed, (Object)this.getSourceURL(), (Object)this.getTargetPath()), e);
    }

    private void setURLConnection(URLConnection connection) {
        this.connection = connection;
    }

    protected void canceling() {
        super.canceling();
        URLConnection currentConnection = this.connection;
    }
}

