/*
 * Decompiled with CFR 0.152.
 */
package moulserver;

import java.io.File;
import java.io.FileInputStream;
import java.util.Queue;
import moulserver.ChunkSendHandler;
import moulserver.Comm;
import moulserver.ConnectionState;
import moulserver.Manager;
import moulserver.Server;
import moulserver.SharedServer;
import shared.Concurrent;
import shared.Format;
import shared.IBytedeque;
import shared.IBytestream;
import shared.SerialBytestream;
import shared.Str;
import shared.b;
import shared.m;
import shared.nested;
import shared.uncaughtexception;
import uru.Bytedeque;
import uru.server.Manifest;

public class FileServer
extends SharedServer {
    static final int kCli2File_PingRequest = 0;
    static final int kCli2File_BuildIdRequest = 10;
    static final int kCli2File_ManifestRequest = 20;
    static final int kCli2File_FileDownloadRequest = 21;
    static final int kCli2File_ManifestEntryAck = 22;
    static final int kCli2File_FileDownloadChunkAck = 23;
    static final int kFile2Cli_PingReply = 0;
    static final int kFile2Cli_BuildIdReply = 10;
    static final int kFile2Cli_BuildIdUpdate = 11;
    static final int kFile2Cli_ManifestReply = 20;
    static final int kFile2Cli_FileDownloadReply = 21;
    Queue<Comm.CommItem> items = Concurrent.getConcurrentQueue();
    Manager manager;

    public FileServer(Manager manager) {
        this.manager = manager;
    }

    public void run() {
        m.msg("Starting FileServer...");
        while (true) {
            Comm.CommItem item;
            if ((item = this.items.poll()) != null) {
                if (item.type == Comm.CommItemType.HandleMessage) {
                    this.HandleMessage(item.msg, item.connstate);
                    continue;
                }
                m.throwUncaughtException("unhandled");
                continue;
            }
            try {
                Thread.sleep(4L);
            }
            catch (Exception exception) {
            }
        }
    }

    public void HandleMessage(Object msg, ConnectionState cs) {
        Class<?> klass = msg.getClass();
        if (klass == PingRequest.class) {
            m.msg("FileServer_PingRequest");
            PingRequest pr = (PingRequest)msg;
            PingReply reply = new PingReply();
            reply.time = pr.time;
            FileServer.SendMsg(cs, reply);
        } else if (klass == ManifestRequest.class) {
            m.msg("FileServer_ManifestRequest");
            ManifestRequest mr = (ManifestRequest)msg;
            String group = mr.group.toString();
            m.msg("Manifest requested: " + group);
            ManifestReply reply = new ManifestReply();
            reply.transId = mr.transId;
            reply.result = 0;
            reply.readerId = mr.transId;
            if (group.equals("ExternalPatcher")) {
                IBytestream manstream = SerialBytestream.createFromFilename(this.manager.settings.getPathToExternalPatcherManifest());
                reply.manifest = new Manifest(manstream, true);
                FileServer.SendMsg(cs, reply);
            } else if (group.equals("ThinExternal")) {
                IBytestream manstream = SerialBytestream.createFromFilename(this.manager.settings.getPathToMainManifest());
                reply.manifest = new Manifest(manstream, true);
                FileServer.SendMsg(cs, reply);
            } else if (group.equals("External")) {
                IBytestream manstream = SerialBytestream.createFromFilename(this.manager.settings.getPathToMainManifest());
                reply.manifest = new Manifest(manstream, true);
                FileServer.SendMsg(cs, reply);
            } else {
                File manfile;
                if (group.contains("/") || group.contains("\\")) {
                    m.throwUncaughtException("None of that!");
                }
                if (!(manfile = new File(this.manager.settings.getPathToAgeManifests() + "/" + group + ".mfs_moul")).exists()) {
                    m.throwUncaughtException("unhandled group: " + group);
                }
                IBytestream manstream = SerialBytestream.createFromFile(manfile);
                reply.manifest = new Manifest(manstream, true);
                FileServer.SendMsg(cs, reply);
            }
        } else if (klass == ManifestEntryAck.class) {
            m.msg("FileServer_ManifestEntryAck");
            ManifestEntryAck ack = (ManifestEntryAck)msg;
            boolean dummy = false;
        } else if (klass == FileDownloadRequest.class) {
            FileDownloadRequest request = (FileDownloadRequest)msg;
            try {
                String filename = request.filename.toString();
                m.msg("FileServer_FileDownloadRequest: ", filename);
                File f = FileServer.GetFile(filename, this.manager.settings.getFileserverPath());
                int filesize = (int)f.length();
                FileInputStream fis = new FileInputStream(f);
                ChunkSendHandler.ChunkFile chunk = cs.chunksendhandler.startfile(request.filename.toString(), filesize, request.transId, fis, false);
                FileDownloadReply reply = new FileDownloadReply();
                reply.transId = request.transId;
                reply.result = 0;
                reply.readerId = request.transId;
                reply.filesize = filesize;
                reply.buffer = chunk.read();
                FileServer.SendMsg(cs, reply);
            }
            catch (Exception e2) {
                throw new nested(e2);
            }
        } else if (klass == FileDownloadChunkAck.class) {
            m.msg("FileServer_FileDownloadChunkAck");
            FileDownloadChunkAck ack = (FileDownloadChunkAck)msg;
            ChunkSendHandler.ChunkFile chunk = cs.chunksendhandler.ack(ack.transId);
            if (!chunk.done) {
                FileDownloadReply reply = new FileDownloadReply();
                reply.transId = ack.transId;
                reply.result = 0;
                reply.readerId = ack.transId;
                reply.filesize = chunk.filesize;
                reply.buffer = chunk.read();
                FileServer.SendMsg(cs, reply);
            } else {
                cs.chunksendhandler.clearfile(ack.transId);
            }
        } else {
            m.throwUncaughtException("Unhandled FileServer msg type: " + klass.getSimpleName());
        }
    }

    public static FileServerMsg ReadMessage(IBytestream c, boolean isServer) {
        int msgSize = c.readInt();
        int msgId = c.readInt();
        if (isServer) {
            switch (msgId) {
                case 0: {
                    return new PingRequest(c);
                }
                case 20: {
                    return new ManifestRequest(c);
                }
                case 22: {
                    return new ManifestEntryAck(c);
                }
                case 21: {
                    return new FileDownloadRequest(c);
                }
                case 23: {
                    return new FileDownloadChunkAck(c);
                }
            }
            throw new uncaughtexception("Unread FileServer msg type: " + Integer.toString(msgId));
        }
        switch (msgId) {
            case 0: {
                return new PingReply(c);
            }
            case 20: {
                return new ManifestReply(c);
            }
            case 21: {
                return new FileDownloadReply(c);
            }
        }
        throw new uncaughtexception("Unread FileServer msg type: " + Integer.toString(msgId));
    }

    public static File GetFile(String filename, String root) {
        String[] pathparts;
        File f = new File(root + "/" + filename);
        if (!f.exists()) {
            return null;
        }
        if (!f.isFile()) {
            throw new uncaughtexception("Expected file but found folder: " + filename);
        }
        for (String s : pathparts = filename.replace("\\", "/").split("/")) {
            if (!s.trim().equals("..")) continue;
            throw new uncaughtexception("File path contained ..: " + filename);
        }
        try {
            String realpath = f.getCanonicalPath();
            String realroot = new File(root).getCanonicalPath();
            if (!realpath.startsWith(realroot)) {
                throw new uncaughtexception("File path is not under root: " + filename);
            }
        }
        catch (Exception e2) {
            throw new nested(e2);
        }
        return f;
    }

    private static void SendMsg(ConnectionState cs, FileServerMsg msg) {
        Bytedeque c = new Bytedeque(Format.moul);
        c.writeInt(0);
        c.writeInt(msg.type());
        msg.write(c);
        byte[] data = c.getAllBytes();
        byte[] len = b.Int32ToBytes(data.length);
        b.CopyBytes(len, data, 0);
        cs.sendMsgBytes(data);
    }

    public static class PingRequest
    extends FileServerMsg {
        int time;

        public PingRequest(IBytestream c) {
            this.time = c.readInt();
        }

        public PingRequest() {
        }

        public int type() {
            return 0;
        }

        public void write(IBytedeque c) {
            c.writeInt(this.time);
        }
    }

    public static class ManifestEntryAck
    extends FileServerMsg {
        int transId;
        int readerId;

        public ManifestEntryAck(IBytestream c) {
            this.transId = c.readInt();
            this.readerId = c.readInt();
        }

        public ManifestEntryAck() {
        }

        public int type() {
            return 22;
        }

        public Integer transid() {
            return this.transId;
        }

        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.readerId);
        }
    }

    public static class ManifestReply
    extends FileServerMsg {
        int transId;
        int result;
        int readerId;
        Manifest manifest;

        public ManifestReply() {
        }

        public Integer transid() {
            return this.transId;
        }

        public ManifestReply(IBytestream c) {
            this.transId = c.readInt();
            this.result = c.readInt();
            this.readerId = c.readInt();
            this.manifest = new Manifest(c, false);
        }

        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.result);
            c.writeInt(this.readerId);
            this.manifest.write(c);
        }

        public int type() {
            return 20;
        }
    }

    public static class ManifestRequest
    extends FileServerMsg {
        int transId;
        Str group;
        int buildId;

        public ManifestRequest(IBytestream c) {
            this.transId = c.readInt();
            this.group = Str.readAsUtf16FixedAndNT(c, 260);
            this.buildId = c.readInt();
        }

        public int type() {
            return 20;
        }

        public Integer transid() {
            return this.transId;
        }

        public ManifestRequest() {
        }

        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            this.group.writeAsUtf16FixedAndNT(c, 260);
            c.writeInt(this.buildId);
        }
    }

    public static class PingReply
    extends FileServerMsg {
        int time;

        public PingReply(IBytestream c) {
            this.time = c.readInt();
        }

        public PingReply() {
        }

        public void write(IBytedeque c) {
            c.writeInt(this.time);
        }

        public int type() {
            return 0;
        }
    }

    static abstract class FileServerMsg
    extends Server.ServerMsg {
        FileServerMsg() {
        }

        abstract int type();

        public byte[] GetMsgBytes() {
            Bytedeque c = new Bytedeque(Format.moul);
            c.writeInt(0);
            c.writeInt(this.type());
            this.write(c);
            byte[] data = c.getAllBytes();
            b.Int32IntoBytes(data.length, data, 0);
            return data;
        }
    }

    public static class FileDownloadRequest
    extends FileServerMsg {
        int transId;
        Str filename;
        int buildId;

        public FileDownloadRequest(IBytestream c) {
            this.transId = c.readInt();
            this.filename = Str.readAsUtf16FixedAndNT(c, 260);
            this.buildId = c.readInt();
        }

        public int type() {
            return 21;
        }

        public Integer transid() {
            return this.transId;
        }

        public FileDownloadRequest() {
        }

        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            this.filename.writeAsUtf16FixedAndNT(c, 260);
            c.writeInt(this.buildId);
        }
    }

    public static class FileDownloadReply
    extends FileServerMsg {
        int transId;
        int result;
        int readerId;
        int filesize;
        private int buffersize;
        byte[] buffer;

        public FileDownloadReply() {
        }

        public FileDownloadReply(IBytestream c) {
            this.transId = c.readInt();
            this.result = c.readInt();
            this.readerId = c.readInt();
            this.filesize = c.readInt();
            this.buffersize = c.readInt();
            this.buffer = c.readBytes(this.buffersize);
        }

        public int type() {
            return 21;
        }

        public Integer transid() {
            return this.transId;
        }

        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.result);
            c.writeInt(this.readerId);
            c.writeInt(this.filesize);
            c.writeInt(this.buffer.length);
            c.writeBytes(this.buffer);
        }
    }

    public static class FileDownloadChunkAck
    extends FileServerMsg {
        int transId;
        int readerId;

        public FileDownloadChunkAck(IBytestream c) {
            this.transId = c.readInt();
            this.readerId = c.readInt();
        }

        public int type() {
            return 23;
        }

        public Integer transid() {
            return this.transId;
        }

        public FileDownloadChunkAck() {
        }

        public void write(IBytedeque c) {
            c.writeInt(this.transId);
            c.writeInt(this.readerId);
        }
    }
}

