/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import shared.Bytes;
import shared.mystobj;
import shared.readexception;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MystInStream {
    MystFileInStream stream;
    long baseoffset;
    long offset;

    private MystInStream() {
    }

    public MystInStream fork(int offset, boolean setAsNewBase) throws readexception {
        MystInStream result = new MystInStream();
        result.offset = this.baseoffset + (long)offset;
        result.baseoffset = setAsNewBase ? this.baseoffset + (long)offset : this.baseoffset;
        result.stream = this.stream;
        return result;
    }

    public static MystInStream createFromFile(String filename) throws readexception {
        File file = new File(filename);
        return MystInStream.createFromFile(file);
    }

    public static MystInStream createFromFile(File file) throws readexception {
        try {
            MystInStream result = new MystInStream();
            result.stream = new MystFileInStream(result, file);
            result.baseoffset = 0L;
            result.offset = 0L;
            return result;
        }
        catch (FileNotFoundException e2) {
            throw new readexception("Unable to find file.");
        }
    }

    public Bytes readbytes(int count) throws readexception {
        try {
            byte[] result = new byte[count];
            this.stream.read(this, result);
            return new Bytes(result);
        }
        catch (IOException e2) {
            throw new readexception("Unable to read bytes.");
        }
    }

    public byte readbyte() throws readexception {
        try {
            return (byte)this.stream.read(this);
        }
        catch (IOException e2) {
            throw new readexception("Unable to read byte");
        }
    }

    public short readshortBigendian() throws readexception {
        try {
            int a = this.stream.read(this) << 8;
            int b2 = this.stream.read(this) << 0;
            short result = (short)(a | b2);
            return result;
        }
        catch (IOException e2) {
            throw new readexception("Unable to read short.");
        }
    }

    public int readintBigendian() throws readexception {
        try {
            int a = this.stream.read(this) << 24;
            int b2 = this.stream.read(this) << 16;
            int c = this.stream.read(this) << 8;
            int d = this.stream.read(this) << 0;
            int result = a | b2 | c | d;
            return result;
        }
        catch (IOException e2) {
            throw new readexception("Unable to read int.");
        }
    }

    public <T extends mystobj> T[] readVector(Class<T> objclass, int size) throws readexception {
        mystobj[] result = (mystobj[])Array.newInstance(objclass, size);
        for (int i = 0; i < size; ++i) {
            result[i] = this.readObj(objclass);
        }
        return result;
    }

    public <T extends mystobj> T readObj(Class objclass) throws readexception {
        try {
            return (T)((mystobj)objclass.getConstructor(MystInStream.class).newInstance(this));
        }
        catch (NoSuchMethodException e2) {
            throw new readexception("MystInStream: NoSuchMethod Exception.");
        }
        catch (InstantiationException e3) {
            throw new readexception("MystInStream: Instantiation Exception.");
        }
        catch (IllegalAccessException e4) {
            throw new readexception("MystInStream: IllegalAccess Exception.");
        }
        catch (InvocationTargetException e5) {
            Throwable e2 = e5.getCause();
            if (e2 instanceof readexception) {
                throw (readexception)e2;
            }
            throw new readexception("MystInStream: InvocationTarget Exception.");
        }
    }

    public String toString() {
        return this.stream.toString(this);
    }

    public static class MystFileInStream {
        RandomAccessFile stream;
        MystInStream lastuser;

        public MystFileInStream(MystInStream user, File file) throws FileNotFoundException {
            this.stream = new RandomAccessFile(file, "r");
            user.offset = 0L;
            this.lastuser = user;
        }

        public int read(MystInStream user) throws IOException {
            if (user != this.lastuser) {
                long oldpos;
                this.lastuser.offset = oldpos = this.stream.getFilePointer();
                long newpos = user.offset;
                this.stream.seek(newpos);
                this.lastuser = user;
            }
            return this.stream.read();
        }

        public void read(MystInStream user, byte[] bytes) throws IOException {
            if (user != this.lastuser) {
                long oldpos;
                this.lastuser.offset = oldpos = this.stream.getFilePointer();
                long newpos = user.offset;
                this.stream.seek(newpos);
                this.lastuser = user;
            }
            this.stream.readFully(bytes);
        }

        public String toString(MystInStream user) {
            try {
                String result = "address:0x" + Integer.toHexString(user.hashCode());
                result = result + "  baseoffset:0x" + Long.toString(user.baseoffset);
                result = result + "  lastuser:0x" + Integer.toHexString(this.lastuser.hashCode());
                result = result + "  pos:0x" + Long.toString(this.stream.getFilePointer());
                return result;
            }
            catch (Exception e2) {
                return "exception";
            }
        }
    }
}

