/*
 * Decompiled with CFR 0.152.
 */
package shared;

import shared.IBytedeque;
import shared.IBytestream;

public class Vector3 {
    public float x;
    public float y;
    public float z;

    public Vector3(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3(IBytestream c) {
        this.x = c.readFloat();
        this.y = c.readFloat();
        this.z = c.readFloat();
    }

    public void compile(IBytedeque c) {
        c.writeFloat(this.x);
        c.writeFloat(this.y);
        c.writeFloat(this.z);
    }

    public Vector3 getInverse() {
        return new Vector3(-this.x, -this.y, -this.z);
    }

    public Vector3 getAdd(Vector3 v2) {
        return new Vector3(this.x + v2.x, this.y + v2.y, this.z + v2.z);
    }

    public Vector3 getSubtract(Vector3 v2) {
        return new Vector3(this.x - v2.x, this.y - v2.y, this.z - v2.z);
    }

    public float getDotProduct(Vector3 v2) {
        return this.x * v2.x + this.y * v2.y + this.z * v2.z;
    }

    public float getLength() {
        float f = this.x * this.x + this.y * this.y + this.z * this.z;
        return (float)Math.sqrt(f);
    }

    public float getDistance(Vector3 v2) {
        return this.getSubtract(v2).getLength();
    }

    public String toString() {
        return Float.toString(this.x) + ", " + Float.toString(this.y) + ", " + Float.toString(this.z);
    }
}

