/*
 * Decompiled with CFR 0.152.
 */
package uru.server;

import java.util.ArrayList;
import java.util.Iterator;
import shared.IBytedeque;
import shared.IBytestream;
import shared.b;
import shared.m;
import shared.mystobj;

public class Utf16 {
    private ArrayList<Short> data = new ArrayList();

    public Utf16(IBytestream c, int size) {
        for (int i = 0; i < size; ++i) {
            short sh = c.readShort();
            this.data.add(sh);
        }
    }

    public Utf16(IBytestream c) {
        short curshort;
        do {
            curshort = c.readShort();
            this.data.add(curshort);
        } while (curshort != 0);
    }

    public Utf16(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            short sh = (short)ch;
            this.data.add(sh);
        }
        this.data.add((short)0);
    }

    public Utf16(String s, int size) {
        this(s);
        int extras = size - this.data.size();
        if (extras < 0) {
            m.throwUncaughtException("String is too large");
        }
        for (int i = 0; i < extras; ++i) {
            this.data.add((short)0);
        }
    }

    public void write(IBytedeque c) {
        for (short sh : this.data) {
            c.writeShort(sh);
        }
    }

    public int numchars() {
        return this.data.size();
    }

    public String toString() {
        return this.toNullTerminatedString();
    }

    public String toDirectString() {
        StringBuilder r = new StringBuilder();
        for (short sh : this.data) {
            r.append((char)sh);
        }
        return r.toString();
    }

    public String toNullTerminatedString() {
        short sh;
        StringBuilder r = new StringBuilder();
        Iterator<Short> i$ = this.data.iterator();
        while (i$.hasNext() && (sh = i$.next().shortValue()) != 0) {
            r.append((char)sh);
        }
        return r.toString();
    }

    public static class NT
    extends mystobj {
        private ArrayList<Short> data = new ArrayList();

        public int size() {
            return this.data.size() - 1;
        }

        public NT(String str) {
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                this.data.add((short)c);
            }
            this.data.add((short)0);
        }

        public NT(IBytestream c) {
            short sh;
            do {
                sh = c.readShort();
                this.data.add(sh);
            } while (sh != 0);
        }

        public void write(IBytedeque c) {
            for (short sh : this.data) {
                c.writeShort(sh);
            }
        }

        public String toString() {
            short sh;
            StringBuilder r = new StringBuilder();
            Iterator<Short> i$ = this.data.iterator();
            while (i$.hasNext() && (sh = i$.next().shortValue()) != 0) {
                r.append((char)sh);
            }
            return r.toString();
        }
    }

    public static class FixedNT {
        private ArrayList<Short> data = new ArrayList();

        public FixedNT(IBytestream c, int size) {
            for (int i = 0; i < size; ++i) {
                short sh = c.readShort();
                this.data.add(sh);
            }
        }

        public FixedNT(String s, int size) {
            for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                short sh = (short)ch;
                this.data.add(sh);
            }
            this.data.add((short)0);
            int extras = size - this.data.size();
            if (extras < 0) {
                m.throwUncaughtException("String is too large");
            }
            for (int i = 0; i < extras; ++i) {
                this.data.add((short)0);
            }
        }

        public void write(IBytedeque c) {
            for (short sh : this.data) {
                c.writeShort(sh);
            }
        }

        public String toString() {
            return this.toNullTerminatedString();
        }

        public String toDirectString() {
            StringBuilder r = new StringBuilder();
            for (short sh : this.data) {
                r.append((char)sh);
            }
            return r.toString();
        }

        public String toNullTerminatedString() {
            short sh;
            StringBuilder r = new StringBuilder();
            Iterator<Short> i$ = this.data.iterator();
            while (i$.hasNext() && (sh = i$.next().shortValue()) != 0) {
                r.append((char)sh);
            }
            return r.toString();
        }
    }

    public static class Sized16 {
        short[] data;

        public Sized16(IBytestream c) {
            short size = c.readShort();
            int size2 = b.Int16ToInt32(size);
            this.data = new short[size2];
            for (int i = 0; i < size2; ++i) {
                this.data[i] = c.readShort();
            }
        }

        public Sized16(String s) {
            this.data = new short[s.length()];
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = (short)s.charAt(i);
            }
        }

        public void write(IBytedeque c) {
            short size = (short)this.data.length;
            c.writeShort(size);
            for (int i = 0; i < this.data.length; ++i) {
                c.writeShort(this.data[i]);
            }
        }

        public String toString() {
            StringBuilder r = new StringBuilder();
            for (short sh : this.data) {
                r.append((char)sh);
            }
            return r.toString();
        }
    }

    public static abstract class Utf16Base
    extends mystobj {
        short[] data;

        protected Utf16Base(IBytestream c, int size) {
            this.data = new short[size];
            for (int i = 0; i < size; ++i) {
                this.data[i] = c.readShort();
            }
        }

        protected Utf16Base(String s) {
            this.data = new short[s.length()];
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = (short)s.charAt(i);
            }
        }

        public void write(IBytedeque c) {
            for (int i = 0; i < this.data.length; ++i) {
                c.writeShort(this.data[i]);
            }
        }

        public String toString() {
            StringBuilder r = new StringBuilder();
            for (short sh : this.data) {
                r.append((char)sh);
            }
            return r.toString();
        }
    }

    public static class SizedAndNT {
        short[] data;

        public SizedAndNT(IBytestream c) {
            int numbytes = c.readInt();
            int size = numbytes / 2;
            this.data = new short[size];
            for (int i = 0; i < size; ++i) {
                this.data[i] = c.readShort();
            }
        }

        public SizedAndNT(String s) {
            this.data = new short[s.length() + 1];
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = (short)s.charAt(i);
            }
            this.data[this.data.length - 1] = 0;
        }

        public void write(IBytedeque c) {
            int numbytes = this.data.length * 2;
            c.writeInt(numbytes);
            for (short sh : this.data) {
                c.writeShort(sh);
            }
        }

        public String toString() {
            StringBuilder r = new StringBuilder();
            for (short sh : this.data) {
                if (sh == 0) break;
                r.append((char)sh);
            }
            return r.toString();
        }
    }
}

