/*
 * Decompiled with CFR 0.152.
 */
package uru.vault;

import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import uru.vault.Node;
import uru.vault.nodetype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Nodes {
    public Vector<Node> nodes = new Vector();

    public void add(Node n) {
        this.nodes.add(n);
    }

    public static Nodes createFromNodeVector(Vector<Node> nodes) {
        Nodes result = new Nodes();
        result.nodes = nodes;
        return result;
    }

    public Vector<Node> findNodesOfType(nodetype type) {
        Vector<Node> result = new Vector<Node>();
        for (Node n : this.nodes) {
            if (n.type != type) continue;
            result.add(n);
        }
        return result;
    }

    public String getAvatarName(int KInumber) {
        for (Node n : this.nodes) {
            if (n.type != nodetype.PlayerInfoNode || n.PlayerInfoNode_GetKINumber() != KInumber) continue;
            return n.PlayerInfoNode_GetAvatarName();
        }
        return null;
    }

    public Vector<Node> getMarkers(int KInumber, String age, int blob1) {
        Vector<Node> result = new Vector<Node>();
        for (Node n : this.nodes) {
            if (n.type != nodetype.MarkerNode || n.owner != KInumber || n.blob1 != blob1 || !n.age_name.toString().equals(age)) continue;
            result.add(n);
        }
        return result;
    }

    public void sortByCreationDate() {
        Collections.sort(this.nodes, new Comparator(){

            public int compare(Object o1, Object o2) {
                long l2;
                Node n1 = (Node)o1;
                Node n2 = (Node)o2;
                long l1 = n1.crt_time.toLong();
                if (l1 == (l2 = n2.crt_time.toLong())) {
                    return 0;
                }
                if (l1 < l2) {
                    return -1;
                }
                return 1;
            }
        });
    }
}

