/*
 * Decompiled with CFR 0.152.
 */
package ie.wombat.jbdiff;

import ie.wombat.jbdiff.Util;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;

public class JBPatch {
    private static final String VERSION = "jbdiff-0.1.1";

    public static void main(String[] arg) throws IOException {
        if (arg.length != 3) {
            System.err.println("usage example: java -Xmx200m ie.wombat.jbdiff.JBPatch oldfile newfile patchfile");
        }
        File oldFile = new File(arg[0]);
        File newFile = new File(arg[1]);
        File diffFile = new File(arg[2]);
        JBPatch.bspatch(oldFile, newFile, diffFile);
    }

    public static void bspatch(File oldFile, File newFile, File diffFile) throws IOException {
        DataInputStream diffIn = new DataInputStream(new FileInputStream(diffFile));
        long headerMagic = diffIn.readLong();
        long ctrlBlockLen = diffIn.readLong();
        long diffBlockLen = diffIn.readLong();
        int newsize = (int)diffIn.readLong();
        FileInputStream in = new FileInputStream(diffFile);
        in.skip(ctrlBlockLen + 32L);
        GZIPInputStream diffBlockIn = new GZIPInputStream(in);
        in = new FileInputStream(diffFile);
        in.skip(diffBlockLen + ctrlBlockLen + 32L);
        GZIPInputStream extraBlockIn = new GZIPInputStream(in);
        int oldsize = (int)oldFile.length();
        byte[] oldBuf = new byte[oldsize + 1];
        FileInputStream oldIn = new FileInputStream(oldFile);
        Util.readFromStream(oldIn, oldBuf, 0, oldsize);
        oldIn.close();
        byte[] newBuf = new byte[newsize + 1];
        int oldpos = 0;
        int newpos = 0;
        int[] ctrl = new int[3];
        while (newpos < newsize) {
            int i;
            for (i = 0; i <= 2; ++i) {
                ctrl[i] = diffIn.readInt();
            }
            if (newpos + ctrl[0] > newsize) {
                System.err.println("Corrupt patch\n");
                return;
            }
            if (!Util.readFromStream(diffBlockIn, newBuf, newpos, ctrl[0])) {
                System.err.println("error reading from extraIn");
                return;
            }
            for (i = 0; i < ctrl[0]; ++i) {
                if (oldpos + i < 0 || oldpos + i >= oldsize) continue;
                int n = newpos + i;
                newBuf[n] = (byte)(newBuf[n] + oldBuf[oldpos + i]);
            }
            oldpos += ctrl[0];
            if ((newpos += ctrl[0]) + ctrl[1] > newsize) {
                System.err.println("Corrupt patch");
                return;
            }
            if (!Util.readFromStream(extraBlockIn, newBuf, newpos, ctrl[1])) {
                System.err.println("error reading from extraIn");
                return;
            }
            newpos += ctrl[1];
            oldpos += ctrl[2];
        }
        diffBlockIn.close();
        extraBlockIn.close();
        diffIn.close();
        FileOutputStream out = new FileOutputStream(newFile);
        out.write(newBuf, 0, newBuf.length - 1);
        out.close();
    }
}

