/*
 * Decompiled with CFR 0.152.
 */
package moulserver;

import java.util.ArrayList;
import java.util.Vector;
import moulserver.Database;
import moulserver.Manager;
import moulserver.Node;
import moulserver.Results;
import prpobjects.Guid;
import shared.ByteArrayBytestream;
import shared.Format;
import shared.IBytedeque;
import shared.IBytestream;
import shared.Str;
import shared.m;
import shared.uncaughtexception;
import uru.Bytedeque;

public class RawNode {
    public static final int kNodeIdx = 0;
    public static final int kCreateTime = 1;
    public static final int kModifyTime = 2;
    public static final int kCreateAgeName = 3;
    public static final int kCreateAgeUuid = 4;
    public static final int kCreatorUuid = 5;
    public static final int kCreatorIdx = 6;
    public static final int kNodeType = 7;
    public static final int kInt32_1 = 8;
    public static final int kInt32_2 = 9;
    public static final int kInt32_3 = 10;
    public static final int kInt32_4 = 11;
    public static final int kUint32_1 = 12;
    public static final int kUint32_2 = 13;
    public static final int kUint32_3 = 14;
    public static final int kUint32_4 = 15;
    public static final int kUuid_1 = 16;
    public static final int kUuid_2 = 17;
    public static final int kUuid_3 = 18;
    public static final int kUuid_4 = 19;
    public static final int kString64_1 = 20;
    public static final int kString64_2 = 21;
    public static final int kString64_3 = 22;
    public static final int kString64_4 = 23;
    public static final int kString64_5 = 24;
    public static final int kString64_6 = 25;
    public static final int kIString64_1 = 26;
    public static final int kIString64_2 = 27;
    public static final int kText_1 = 28;
    public static final int kText_2 = 29;
    public static final int kBlob_1 = 30;
    public static final int kBlob_2 = 31;
    public static final int kNumFields = 32;
    long fields;
    Integer nodeIdx;
    Integer createTime;
    Integer modifyTime;
    Str createAgeName;
    Guid createAgeUuid;
    Guid creatorUuid;
    Integer creatorIdx;
    Integer nodeType;
    Integer int32_1;
    Integer int32_2;
    Integer int32_3;
    Integer int32_4;
    Integer uint32_1;
    Integer uint32_2;
    Integer uint32_3;
    Integer uint32_4;
    Guid uuid_1;
    Guid uuid_2;
    Guid uuid_3;
    Guid uuid_4;
    Str string64_1;
    Str string64_2;
    Str string64_3;
    Str string64_4;
    Str string64_5;
    Str string64_6;
    Str iString64_1;
    Str iString64_2;
    Str text_1b;
    Str text_2b;
    Node.Blob blob_1b;
    Node.Blob blob_2b;

    public RawNode(int type) {
        this.nodeIdx = Manager.manager.database.getNextIdx();
        this.nodeType = type;
        this.createTime = 0;
        this.modifyTime = 0;
        this.creatorUuid = Guid.none2();
        this.creatorIdx = 0;
    }

    private RawNode() {
    }

    public static RawNode createEmpty() {
        return new RawNode();
    }

    public RawNode(Results r) {
        this.fields = r.getLong(1);
        block34: for (int i = 0; i < 32; ++i) {
            if ((this.fields & (long)(1 << i)) == 0L) continue;
            switch (i) {
                case 0: {
                    this.nodeIdx = r.getInt(2);
                    continue block34;
                }
                case 1: {
                    this.createTime = r.getInt(3);
                    continue block34;
                }
                case 2: {
                    this.modifyTime = r.getInt(4);
                    continue block34;
                }
                case 3: {
                    this.createAgeName = new Str(r.getString(5));
                    continue block34;
                }
                case 4: {
                    this.createAgeUuid = new Guid(r.getBytes(6));
                    continue block34;
                }
                case 5: {
                    this.creatorUuid = new Guid(r.getBytes(7));
                    continue block34;
                }
                case 6: {
                    this.creatorIdx = r.getInt(8);
                    continue block34;
                }
                case 7: {
                    this.nodeType = r.getInt(9);
                    continue block34;
                }
                case 8: {
                    this.int32_1 = r.getInt(10);
                    continue block34;
                }
                case 9: {
                    this.int32_2 = r.getInt(11);
                    continue block34;
                }
                case 10: {
                    this.int32_3 = r.getInt(12);
                    continue block34;
                }
                case 11: {
                    this.int32_4 = r.getInt(13);
                    continue block34;
                }
                case 12: {
                    this.uint32_1 = r.getInt(14);
                    continue block34;
                }
                case 13: {
                    this.uint32_2 = r.getInt(15);
                    continue block34;
                }
                case 14: {
                    this.uint32_3 = r.getInt(16);
                    continue block34;
                }
                case 15: {
                    this.uint32_4 = r.getInt(17);
                    continue block34;
                }
                case 16: {
                    this.uuid_1 = new Guid(r.getBytes(18));
                    continue block34;
                }
                case 17: {
                    this.uuid_2 = new Guid(r.getBytes(19));
                    continue block34;
                }
                case 18: {
                    this.uuid_3 = new Guid(r.getBytes(20));
                    continue block34;
                }
                case 19: {
                    this.uuid_4 = new Guid(r.getBytes(21));
                    continue block34;
                }
                case 20: {
                    this.string64_1 = new Str(r.getString(22));
                    continue block34;
                }
                case 21: {
                    this.string64_2 = new Str(r.getString(23));
                    continue block34;
                }
                case 22: {
                    this.string64_3 = new Str(r.getString(24));
                    continue block34;
                }
                case 23: {
                    this.string64_4 = new Str(r.getString(25));
                    continue block34;
                }
                case 24: {
                    this.string64_5 = new Str(r.getString(26));
                    continue block34;
                }
                case 25: {
                    this.string64_6 = new Str(r.getString(27));
                    continue block34;
                }
                case 26: {
                    this.iString64_1 = new Str(r.getString(28));
                    continue block34;
                }
                case 27: {
                    this.iString64_2 = new Str(r.getString(29));
                    continue block34;
                }
                case 28: {
                    this.text_1b = new Str(r.getString(30));
                    continue block34;
                }
                case 29: {
                    this.text_2b = new Str(r.getString(31));
                    continue block34;
                }
                case 30: {
                    this.blob_1b = new Node.Blob(r.getBytes(32));
                    continue block34;
                }
                case 31: {
                    this.blob_2b = new Node.Blob(r.getBytes(33));
                    continue block34;
                }
                default: {
                    throw new uncaughtexception("Unhandled node flag");
                }
            }
        }
    }

    public RawNode(byte[] rawdata) {
        this(ByteArrayBytestream.createFromByteArray(rawdata));
    }

    public RawNode(IBytestream c) {
        this.fields = c.readLong();
        block34: for (int i = 0; i < 32; ++i) {
            if ((this.fields & (long)(1 << i)) == 0L) continue;
            switch (i) {
                case 0: {
                    this.nodeIdx = c.readInt();
                    continue block34;
                }
                case 1: {
                    this.createTime = c.readInt();
                    continue block34;
                }
                case 2: {
                    this.modifyTime = c.readInt();
                    continue block34;
                }
                case 3: {
                    this.createAgeName = Str.readAsUtf16SizedAndNT(c);
                    continue block34;
                }
                case 4: {
                    this.createAgeUuid = new Guid(c);
                    continue block34;
                }
                case 5: {
                    this.creatorUuid = new Guid(c);
                    continue block34;
                }
                case 6: {
                    this.creatorIdx = c.readInt();
                    continue block34;
                }
                case 7: {
                    this.nodeType = c.readInt();
                    continue block34;
                }
                case 8: {
                    this.int32_1 = c.readInt();
                    continue block34;
                }
                case 9: {
                    this.int32_2 = c.readInt();
                    continue block34;
                }
                case 10: {
                    this.int32_3 = c.readInt();
                    continue block34;
                }
                case 11: {
                    this.int32_4 = c.readInt();
                    continue block34;
                }
                case 12: {
                    this.uint32_1 = c.readInt();
                    continue block34;
                }
                case 13: {
                    this.uint32_2 = c.readInt();
                    continue block34;
                }
                case 14: {
                    this.uint32_3 = c.readInt();
                    continue block34;
                }
                case 15: {
                    this.uint32_4 = c.readInt();
                    continue block34;
                }
                case 16: {
                    this.uuid_1 = new Guid(c);
                    continue block34;
                }
                case 17: {
                    this.uuid_2 = new Guid(c);
                    continue block34;
                }
                case 18: {
                    this.uuid_3 = new Guid(c);
                    continue block34;
                }
                case 19: {
                    this.uuid_4 = new Guid(c);
                    continue block34;
                }
                case 20: {
                    this.string64_1 = Str.readAsUtf16SizedAndNT(c);
                    continue block34;
                }
                case 21: {
                    this.string64_2 = Str.readAsUtf16SizedAndNT(c);
                    continue block34;
                }
                case 22: {
                    this.string64_3 = Str.readAsUtf16SizedAndNT(c);
                    continue block34;
                }
                case 23: {
                    this.string64_4 = Str.readAsUtf16SizedAndNT(c);
                    continue block34;
                }
                case 24: {
                    this.string64_5 = Str.readAsUtf16SizedAndNT(c);
                    continue block34;
                }
                case 25: {
                    this.string64_6 = Str.readAsUtf16SizedAndNT(c);
                    continue block34;
                }
                case 26: {
                    this.iString64_1 = Str.readAsUtf16SizedAndNT(c);
                    continue block34;
                }
                case 27: {
                    this.iString64_2 = Str.readAsUtf16SizedAndNT(c);
                    continue block34;
                }
                case 28: {
                    this.text_1b = Str.readAsUtf16SizedAndNT(c);
                    continue block34;
                }
                case 29: {
                    this.text_2b = Str.readAsUtf16SizedAndNT(c);
                    continue block34;
                }
                case 30: {
                    this.blob_1b = new Node.Blob(c);
                    continue block34;
                }
                case 31: {
                    this.blob_2b = new Node.Blob(c);
                    continue block34;
                }
                default: {
                    throw new uncaughtexception("Unhandled node flag");
                }
            }
        }
    }

    public int[] makeSqlQuery() {
        StringBuilder r = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        boolean first = true;
        r.append("SELECT * FROM vault WHERE ");
        for (int i = 0; i < 32; ++i) {
            if ((this.fields & (long)(1 << i)) == 0L) continue;
            if (!first) {
                r.append(" AND ");
            }
            switch (i) {
                case 0: {
                    r.append("idx");
                    params.add(this.nodeIdx);
                    break;
                }
                case 1: {
                    r.append("createTime");
                    params.add(this.createTime);
                    break;
                }
                case 2: {
                    r.append("modifyTime");
                    params.add(this.modifyTime);
                    break;
                }
                case 3: {
                    r.append("createAgeName");
                    params.add(this.createAgeName);
                    break;
                }
                case 4: {
                    r.append("createAgeUuid");
                    params.add(this.createAgeUuid);
                    break;
                }
                case 5: {
                    r.append("creatorUuid");
                    params.add(this.creatorUuid);
                    break;
                }
                case 6: {
                    r.append("creatorIdx");
                    params.add(this.creatorIdx);
                    break;
                }
                case 7: {
                    r.append("type");
                    params.add(this.nodeType);
                    break;
                }
                case 8: {
                    r.append("int_1");
                    params.add(this.int32_1);
                    break;
                }
                case 9: {
                    r.append("int_2");
                    params.add(this.int32_2);
                    break;
                }
                case 10: {
                    r.append("int_3");
                    params.add(this.int32_3);
                    break;
                }
                case 11: {
                    r.append("int_4");
                    params.add(this.int32_4);
                    break;
                }
                case 12: {
                    r.append("uint_1");
                    params.add(this.uint32_1);
                    break;
                }
                case 13: {
                    r.append("uint_2");
                    params.add(this.uint32_2);
                    break;
                }
                case 14: {
                    r.append("uint_3");
                    params.add(this.uint32_3);
                    break;
                }
                case 15: {
                    r.append("uint_4");
                    params.add(this.uint32_4);
                    break;
                }
                case 16: {
                    r.append("uuid_1");
                    params.add(this.uuid_1);
                    break;
                }
                case 17: {
                    r.append("uuid_2");
                    params.add(this.uuid_2);
                    break;
                }
                case 18: {
                    r.append("uuid_3");
                    params.add(this.uuid_3);
                    break;
                }
                case 19: {
                    r.append("uuid_4");
                    params.add(this.uuid_4);
                    break;
                }
                case 20: {
                    r.append("str_1");
                    params.add(this.string64_1);
                    break;
                }
                case 21: {
                    r.append("str_2");
                    params.add(this.string64_2);
                    break;
                }
                case 22: {
                    r.append("str_3");
                    params.add(this.string64_3);
                    break;
                }
                case 23: {
                    r.append("str_4");
                    params.add(this.string64_4);
                    break;
                }
                case 24: {
                    r.append("str_5");
                    params.add(this.string64_5);
                    break;
                }
                case 25: {
                    r.append("str_6");
                    params.add(this.string64_6);
                    break;
                }
                case 26: {
                    r.append("lstr_1");
                    params.add(this.iString64_1);
                    break;
                }
                case 27: {
                    r.append("lstr_2");
                    params.add(this.iString64_2);
                    break;
                }
                case 28: {
                    r.append("text_1");
                    params.add(this.text_1b);
                    break;
                }
                case 29: {
                    r.append("text_2");
                    params.add(this.text_2b);
                    break;
                }
                case 30: {
                    r.append("blob_1");
                    params.add(this.blob_1b);
                    break;
                }
                case 31: {
                    r.append("blob_2");
                    params.add(this.blob_2b);
                    break;
                }
                default: {
                    throw new uncaughtexception("Unhandled node flag");
                }
            }
            r.append("=?");
            first = false;
        }
        String sql = r.toString();
        Object[] params2 = params.toArray();
        Results results = Manager.manager.database.sqlquery(sql, params2);
        ArrayList<Integer> idxs = new ArrayList<Integer>();
        while (results.next()) {
            int idx = results.getInt("idx");
            idxs.add(idx);
        }
        int[] idx2 = new int[idxs.size()];
        for (int i = 0; i < idx2.length; ++i) {
            idx2[i] = (Integer)idxs.get(i);
        }
        return idx2;
    }

    public String toString() {
        return this.dump();
    }

    public String dump() {
        StringBuilder r = new StringBuilder();
        for (int i = 0; i < 32; ++i) {
            String s;
            if ((this.fields & (long)(1 << i)) == 0L) continue;
            switch (i) {
                case 0: {
                    s = "NodeIdx=" + Integer.toString(this.nodeIdx);
                    break;
                }
                case 1: {
                    s = "CreateTime=" + Integer.toString(this.createTime);
                    break;
                }
                case 2: {
                    s = "ModifyTime=" + Integer.toString(this.modifyTime);
                    break;
                }
                case 3: {
                    s = "CreateAgeName=" + this.createAgeName.toString();
                    break;
                }
                case 4: {
                    s = "CreateAgeUuid=" + this.createAgeUuid.toString();
                    break;
                }
                case 5: {
                    s = "CreatorUuid=" + this.creatorUuid.toString();
                    break;
                }
                case 6: {
                    s = "CreatorIdx=" + Integer.toString(this.creatorIdx);
                    break;
                }
                case 7: {
                    s = "NodeType=" + Integer.toString(this.nodeType);
                    break;
                }
                case 8: {
                    s = "Int32_1=" + this.int32_1.toString();
                    break;
                }
                case 9: {
                    s = "Int32_2=" + this.int32_2.toString();
                    break;
                }
                case 10: {
                    s = "Int32_3=" + this.int32_3.toString();
                    break;
                }
                case 11: {
                    s = "Int32_4=" + this.int32_4.toString();
                    break;
                }
                case 12: {
                    s = "Uint32_1=" + this.uint32_1.toString();
                    break;
                }
                case 13: {
                    s = "Uint32_2=" + this.uint32_2.toString();
                    break;
                }
                case 14: {
                    s = "Uint32_3=" + this.uint32_3.toString();
                    break;
                }
                case 15: {
                    s = "Uint32_4=" + this.uint32_4.toString();
                    break;
                }
                case 16: {
                    s = "Uuid_1=" + this.uuid_1.toString();
                    break;
                }
                case 17: {
                    s = "Uuid_2=" + this.uuid_2.toString();
                    break;
                }
                case 18: {
                    s = "Uuid_3=" + this.uuid_3.toString();
                    break;
                }
                case 19: {
                    s = "Uuid_4=" + this.uuid_4.toString();
                    break;
                }
                case 20: {
                    s = "String64_1=" + this.string64_1.toString();
                    break;
                }
                case 21: {
                    s = "String64_2=" + this.string64_2.toString();
                    break;
                }
                case 22: {
                    s = "String64_3=" + this.string64_3.toString();
                    break;
                }
                case 23: {
                    s = "String64_4=" + this.string64_4.toString();
                    break;
                }
                case 24: {
                    s = "String64_5=" + this.string64_5.toString();
                    break;
                }
                case 25: {
                    s = "String64_6=" + this.string64_6.toString();
                    break;
                }
                case 26: {
                    s = "IString64_1=" + this.iString64_1.toString();
                    break;
                }
                case 27: {
                    s = "IString64_2=" + this.iString64_2.toString();
                    break;
                }
                case 28: {
                    s = "Text_1=" + this.text_1b.toString();
                    break;
                }
                case 29: {
                    s = "Text_2=" + this.text_2b.toString();
                    break;
                }
                case 30: {
                    if (this.nodeType == 27 || this.nodeType == 25) {
                        s = "Blob_1=[[binary data omitted]]";
                        break;
                    }
                    s = "Blob_1=" + this.blob_1b.toString();
                    break;
                }
                case 31: {
                    s = "Blob_2=" + this.blob_2b.toString();
                    break;
                }
                default: {
                    throw new uncaughtexception("Unhandled node flag");
                }
            }
            int maxsize = 40000;
            if (s.length() > maxsize) {
                s = s.substring(0, maxsize);
            }
            s = s.replace("\u0000", "[[0]]");
            s = s.replace("\r\n", "[[rn]]");
            s = s.replace("\n", "[[n]]");
            r.append(s);
            r.append("  ");
        }
        return r.toString();
    }

    public int numFields() {
        int r = 0;
        for (int i = 0; i < 32; ++i) {
            if ((this.fields & (long)(1 << i)) == 0L) continue;
            ++r;
        }
        return r;
    }

    private void regenerateFieldsFlag() {
        long newfields = 0L;
        for (int i = 0; i < 32; ++i) {
            boolean has = false;
            switch (i) {
                case 0: {
                    if (this.nodeIdx == null) break;
                    has = true;
                    break;
                }
                case 1: {
                    if (this.createTime == null) break;
                    has = true;
                    break;
                }
                case 2: {
                    if (this.modifyTime == null) break;
                    has = true;
                    break;
                }
                case 3: {
                    if (this.createAgeName == null) break;
                    has = true;
                    break;
                }
                case 4: {
                    if (this.createAgeUuid == null) break;
                    has = true;
                    break;
                }
                case 5: {
                    if (this.creatorUuid == null) break;
                    has = true;
                    break;
                }
                case 6: {
                    if (this.creatorIdx == null) break;
                    has = true;
                    break;
                }
                case 7: {
                    if (this.nodeType == null) break;
                    has = true;
                    break;
                }
                case 8: {
                    if (this.int32_1 == null) break;
                    has = true;
                    break;
                }
                case 9: {
                    if (this.int32_2 == null) break;
                    has = true;
                    break;
                }
                case 10: {
                    if (this.int32_3 == null) break;
                    has = true;
                    break;
                }
                case 11: {
                    if (this.int32_4 == null) break;
                    has = true;
                    break;
                }
                case 12: {
                    if (this.uint32_1 == null) break;
                    has = true;
                    break;
                }
                case 13: {
                    if (this.uint32_2 == null) break;
                    has = true;
                    break;
                }
                case 14: {
                    if (this.uint32_3 == null) break;
                    has = true;
                    break;
                }
                case 15: {
                    if (this.uint32_4 == null) break;
                    has = true;
                    break;
                }
                case 16: {
                    if (this.uuid_1 == null) break;
                    has = true;
                    break;
                }
                case 17: {
                    if (this.uuid_2 == null) break;
                    has = true;
                    break;
                }
                case 18: {
                    if (this.uuid_3 == null) break;
                    has = true;
                    break;
                }
                case 19: {
                    if (this.uuid_4 == null) break;
                    has = true;
                    break;
                }
                case 20: {
                    if (this.string64_1 == null) break;
                    has = true;
                    break;
                }
                case 21: {
                    if (this.string64_2 == null) break;
                    has = true;
                    break;
                }
                case 22: {
                    if (this.string64_3 == null) break;
                    has = true;
                    break;
                }
                case 23: {
                    if (this.string64_4 == null) break;
                    has = true;
                    break;
                }
                case 24: {
                    if (this.string64_5 == null) break;
                    has = true;
                    break;
                }
                case 25: {
                    if (this.string64_6 == null) break;
                    has = true;
                    break;
                }
                case 26: {
                    if (this.iString64_1 == null) break;
                    has = true;
                    break;
                }
                case 27: {
                    if (this.iString64_2 == null) break;
                    has = true;
                    break;
                }
                case 28: {
                    if (this.text_1b == null) break;
                    has = true;
                    break;
                }
                case 29: {
                    if (this.text_2b == null) break;
                    has = true;
                    break;
                }
                case 30: {
                    if (this.blob_1b == null) break;
                    has = true;
                    break;
                }
                case 31: {
                    if (this.blob_2b == null) break;
                    has = true;
                    break;
                }
                default: {
                    throw new uncaughtexception("Unhandled node flag");
                }
            }
            if (!has) continue;
            newfields |= 1L << i;
        }
        this.fields = newfields;
    }

    public void insert() {
        this.regenerateFieldsFlag();
        this.insertOrUpdate(true, 0L);
    }

    public void update(long newfields, Guid revision) {
        this.regenerateFieldsFlag();
        this.insertOrUpdate(false, newfields);
        Manager.manager.vaultlistener.SignalNodeChanged(this.nodeIdx, revision);
    }

    public void updateAll(Guid revision) {
        this.regenerateFieldsFlag();
        long newfields = this.fields;
        this.update(newfields, revision);
    }

    private void insertOrUpdate(boolean isInsert, long newfields) {
        int i;
        int numfields = this.numFields();
        StringBuilder r = new StringBuilder();
        Vector<Object> o = new Vector<Object>();
        if (isInsert) {
            r.append("INSERT INTO vault(");
        } else {
            r.append("UPDATE vault SET ");
        }
        if (isInsert) {
            r.append("fields");
            o.add(this.fields);
        } else {
            r.append("fields");
            o.add(newfields);
            r.append("=?");
        }
        for (i = 0; i < 32; ++i) {
            if ((this.fields & (long)(1 << i)) == 0L) continue;
            if (isInsert) {
                r.append(',');
            } else {
                r.append(',');
            }
            switch (i) {
                case 0: {
                    r.append("idx");
                    o.add(this.nodeIdx);
                    break;
                }
                case 1: {
                    r.append("createTime");
                    o.add(this.createTime);
                    break;
                }
                case 2: {
                    r.append("modifyTime");
                    o.add(this.modifyTime);
                    break;
                }
                case 3: {
                    r.append("createAgeName");
                    o.add(this.createAgeName.toString());
                    break;
                }
                case 4: {
                    r.append("createAgeUuid");
                    o.add(this.createAgeUuid.toBytes());
                    break;
                }
                case 5: {
                    r.append("creatorUuid");
                    o.add(this.creatorUuid.toBytes());
                    break;
                }
                case 6: {
                    r.append("creatorIdx");
                    o.add(this.creatorIdx);
                    break;
                }
                case 7: {
                    r.append("type");
                    o.add(this.nodeType);
                    break;
                }
                case 8: {
                    r.append("int_1");
                    o.add(this.int32_1);
                    break;
                }
                case 9: {
                    r.append("int_2");
                    o.add(this.int32_2);
                    break;
                }
                case 10: {
                    r.append("int_3");
                    o.add(this.int32_3);
                    break;
                }
                case 11: {
                    r.append("int_4");
                    o.add(this.int32_4);
                    break;
                }
                case 12: {
                    r.append("uint_1");
                    o.add(this.uint32_1);
                    break;
                }
                case 13: {
                    r.append("uint_2");
                    o.add(this.uint32_2);
                    break;
                }
                case 14: {
                    r.append("uint_3");
                    o.add(this.uint32_3);
                    break;
                }
                case 15: {
                    r.append("uint_4");
                    o.add(this.uint32_4);
                    break;
                }
                case 16: {
                    r.append("uuid_1");
                    o.add(this.uuid_1.toBytes());
                    break;
                }
                case 17: {
                    r.append("uuid_2");
                    o.add(this.uuid_2.toBytes());
                    break;
                }
                case 18: {
                    r.append("uuid_3");
                    o.add(this.uuid_3.toBytes());
                    break;
                }
                case 19: {
                    r.append("uuid_4");
                    o.add(this.uuid_4.toBytes());
                    break;
                }
                case 20: {
                    r.append("str_1");
                    o.add(this.string64_1.toString());
                    break;
                }
                case 21: {
                    r.append("str_2");
                    o.add(this.string64_2.toString());
                    break;
                }
                case 22: {
                    r.append("str_3");
                    o.add(this.string64_3.toString());
                    break;
                }
                case 23: {
                    r.append("str_4");
                    o.add(this.string64_4.toString());
                    break;
                }
                case 24: {
                    r.append("str_5");
                    o.add(this.string64_5.toString());
                    break;
                }
                case 25: {
                    r.append("str_6");
                    o.add(this.string64_6.toString());
                    break;
                }
                case 26: {
                    r.append("lstr_1");
                    o.add(this.iString64_1.toString());
                    break;
                }
                case 27: {
                    r.append("lstr_2");
                    o.add(this.iString64_2.toString());
                    break;
                }
                case 28: {
                    r.append("text_1");
                    o.add(this.text_1b.toString());
                    break;
                }
                case 29: {
                    r.append("text_2");
                    o.add(this.text_2b.toString());
                    break;
                }
                case 30: {
                    r.append("blob_1");
                    o.add(this.blob_1b.toBytes());
                    break;
                }
                case 31: {
                    r.append("blob_2");
                    o.add(this.blob_2b.toBytes());
                    break;
                }
                default: {
                    throw new uncaughtexception("Unhandled node flag");
                }
            }
            if (isInsert) continue;
            r.append("=?");
        }
        if (isInsert) {
            r.append(") VALUES(?");
            for (i = 0; i < numfields; ++i) {
                r.append(',');
                r.append('?');
            }
            r.append(") ;");
        } else {
            r.append(" WHERE idx=? ;");
            o.add(this.nodeIdx);
        }
        String sql = r.toString();
        Manager.manager.database.sqlupdate(sql, o.toArray());
    }

    public void mergeFrom(RawNode n) {
        block34: for (int i = 0; i < 32; ++i) {
            if ((n.fields & (long)(1 << i)) == 0L) continue;
            switch (i) {
                case 0: {
                    if (this.nodeIdx == n.nodeIdx) continue block34;
                    m.throwUncaughtException("unexpected");
                    continue block34;
                }
                case 1: {
                    this.createTime = n.createTime;
                    continue block34;
                }
                case 2: {
                    this.modifyTime = n.modifyTime;
                    continue block34;
                }
                case 3: {
                    this.createAgeName = n.createAgeName;
                    continue block34;
                }
                case 4: {
                    this.createAgeUuid = n.createAgeUuid;
                    continue block34;
                }
                case 5: {
                    this.creatorUuid = n.creatorUuid;
                    continue block34;
                }
                case 6: {
                    this.creatorIdx = n.creatorIdx;
                    continue block34;
                }
                case 7: {
                    if (this.nodeType != n.nodeType) {
                        m.throwUncaughtException("unexpected");
                    }
                    this.nodeType = n.nodeType;
                    continue block34;
                }
                case 8: {
                    this.int32_1 = n.int32_1;
                    continue block34;
                }
                case 9: {
                    this.int32_2 = n.int32_2;
                    continue block34;
                }
                case 10: {
                    this.int32_3 = n.int32_3;
                    continue block34;
                }
                case 11: {
                    this.int32_4 = n.int32_4;
                    continue block34;
                }
                case 12: {
                    this.uint32_1 = n.uint32_1;
                    continue block34;
                }
                case 13: {
                    this.uint32_2 = n.uint32_2;
                    continue block34;
                }
                case 14: {
                    this.uint32_3 = n.uint32_3;
                    continue block34;
                }
                case 15: {
                    this.uint32_4 = n.uint32_4;
                    continue block34;
                }
                case 16: {
                    this.uuid_1 = n.uuid_1;
                    continue block34;
                }
                case 17: {
                    this.uuid_2 = n.uuid_2;
                    continue block34;
                }
                case 18: {
                    this.uuid_3 = n.uuid_3;
                    continue block34;
                }
                case 19: {
                    this.uuid_4 = n.uuid_4;
                    continue block34;
                }
                case 20: {
                    this.string64_1 = n.string64_1;
                    continue block34;
                }
                case 21: {
                    this.string64_2 = n.string64_2;
                    continue block34;
                }
                case 22: {
                    this.string64_3 = n.string64_3;
                    continue block34;
                }
                case 23: {
                    this.string64_4 = n.string64_4;
                    continue block34;
                }
                case 24: {
                    this.string64_5 = n.string64_5;
                    continue block34;
                }
                case 25: {
                    this.string64_6 = n.string64_6;
                    continue block34;
                }
                case 26: {
                    this.iString64_1 = n.iString64_1;
                    continue block34;
                }
                case 27: {
                    this.iString64_2 = n.iString64_2;
                    continue block34;
                }
                case 28: {
                    this.text_1b = n.text_1b;
                    continue block34;
                }
                case 29: {
                    this.text_2b = n.text_2b;
                    continue block34;
                }
                case 30: {
                    this.blob_1b = n.blob_1b;
                    continue block34;
                }
                case 31: {
                    this.blob_2b = n.blob_2b;
                    continue block34;
                }
                default: {
                    throw new uncaughtexception("Unhandled node flag");
                }
            }
        }
    }

    public Node getInterface() {
        switch (this.nodeType) {
            case 27: {
                return new Node.SDLNode(this);
            }
        }
        throw new uncaughtexception("unhandled");
    }

    public byte[] getBytes() {
        Bytedeque c = new Bytedeque(Format.moul);
        this.write(c);
        return c.getAllBytes();
    }

    public void write(IBytedeque c) {
        this.regenerateFieldsFlag();
        c.writeLong(this.fields);
        block34: for (int i = 0; i < 32; ++i) {
            if ((this.fields & (long)(1 << i)) == 0L) continue;
            switch (i) {
                case 0: {
                    c.writeInt(this.nodeIdx);
                    continue block34;
                }
                case 1: {
                    c.writeInt(this.createTime);
                    continue block34;
                }
                case 2: {
                    c.writeInt(this.modifyTime);
                    continue block34;
                }
                case 3: {
                    this.createAgeName.writeAsUtf16SizedAndNT(c);
                    continue block34;
                }
                case 4: {
                    this.createAgeUuid.write(c);
                    continue block34;
                }
                case 5: {
                    this.creatorUuid.write(c);
                    continue block34;
                }
                case 6: {
                    c.writeInt(this.creatorIdx);
                    continue block34;
                }
                case 7: {
                    c.writeInt(this.nodeType);
                    continue block34;
                }
                case 8: {
                    c.writeInt(this.int32_1);
                    continue block34;
                }
                case 9: {
                    c.writeInt(this.int32_2);
                    continue block34;
                }
                case 10: {
                    c.writeInt(this.int32_3);
                    continue block34;
                }
                case 11: {
                    c.writeInt(this.int32_4);
                    continue block34;
                }
                case 12: {
                    c.writeInt(this.uint32_1);
                    continue block34;
                }
                case 13: {
                    c.writeInt(this.uint32_2);
                    continue block34;
                }
                case 14: {
                    c.writeInt(this.uint32_3);
                    continue block34;
                }
                case 15: {
                    c.writeInt(this.uint32_4);
                    continue block34;
                }
                case 16: {
                    this.uuid_1.write(c);
                    continue block34;
                }
                case 17: {
                    this.uuid_2.write(c);
                    continue block34;
                }
                case 18: {
                    this.uuid_3.write(c);
                    continue block34;
                }
                case 19: {
                    this.uuid_4.write(c);
                    continue block34;
                }
                case 20: {
                    this.string64_1.writeAsUtf16SizedAndNT(c);
                    continue block34;
                }
                case 21: {
                    this.string64_2.writeAsUtf16SizedAndNT(c);
                    continue block34;
                }
                case 22: {
                    this.string64_3.writeAsUtf16SizedAndNT(c);
                    continue block34;
                }
                case 23: {
                    this.string64_4.writeAsUtf16SizedAndNT(c);
                    continue block34;
                }
                case 24: {
                    this.string64_5.writeAsUtf16SizedAndNT(c);
                    continue block34;
                }
                case 25: {
                    this.string64_6.writeAsUtf16SizedAndNT(c);
                    continue block34;
                }
                case 26: {
                    this.iString64_1.writeAsUtf16SizedAndNT(c);
                    continue block34;
                }
                case 27: {
                    this.iString64_2.writeAsUtf16SizedAndNT(c);
                    continue block34;
                }
                case 28: {
                    this.text_1b.writeAsUtf16SizedAndNT(c);
                    continue block34;
                }
                case 29: {
                    this.text_2b.writeAsUtf16SizedAndNT(c);
                    continue block34;
                }
                case 30: {
                    this.blob_1b.write(c);
                    continue block34;
                }
                case 31: {
                    this.blob_2b.write(c);
                    continue block34;
                }
                default: {
                    throw new uncaughtexception("Unhandled node flag");
                }
            }
        }
    }

    public void setFieldsOnNewNode() {
        this.nodeIdx = Manager.manager.database.getNextIdx();
        this.createTime = Database.getCurrentTime();
        this.modifyTime = Database.getCurrentTime();
        this.creatorUuid = Guid.none2();
        this.creatorIdx = 0;
    }
}

