/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.nio;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.nio.ChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.util.log.Log;

public class SelectChannelEndPoint
extends ChannelEndPoint
implements Runnable,
AsyncEndPoint,
ConnectedEndPoint {
    private final SelectorManager.SelectSet _selectSet;
    private final SelectorManager _manager;
    private volatile Connection _connection;
    private boolean _dispatched = false;
    private boolean _redispatched = false;
    private volatile boolean _writable = true;
    private SelectionKey _key;
    private int _interestOps;
    private boolean _readBlocked;
    private boolean _writeBlocked;
    private boolean _open;
    private volatile long _idleTimestamp;

    public SelectChannelEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey key) throws IOException {
        super(channel);
        this._manager = selectSet.getManager();
        this._selectSet = selectSet;
        this._dispatched = false;
        this._redispatched = false;
        this._open = true;
        this._key = key;
        this._connection = this._manager.newConnection(channel, this);
        this.scheduleIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectionKey getSelectionKey() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            return this._key;
        }
    }

    public SelectorManager getSelectManager() {
        return this._manager;
    }

    public Connection getConnection() {
        return this._connection;
    }

    public void setConnection(Connection connection) {
        Connection old = this._connection;
        this._connection = connection;
        this._manager.endPointUpgraded(this, old);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this._key == null || !this._key.isValid()) {
                this._readBlocked = false;
                this._writeBlocked = false;
                this.notifyAll();
                return;
            }
            if (this._readBlocked || this._writeBlocked) {
                if (this._readBlocked && this._key.isReadable()) {
                    this._readBlocked = false;
                }
                if (this._writeBlocked && this._key.isWritable()) {
                    this._writeBlocked = false;
                }
                this.notifyAll();
                this._key.interestOps(0);
                return;
            }
            if (!this.isReadyForDispatch()) {
                this._key.interestOps(0);
                return;
            }
            if ((this._key.readyOps() & 4) == 4 && (this._key.interestOps() & 4) == 4) {
                this._interestOps = this._key.interestOps() & 0xFFFFFFFB;
                this._key.interestOps(this._interestOps);
                this._writable = true;
            }
            if (this._dispatched) {
                this._key.interestOps(0);
            } else {
                this.dispatch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this._dispatched) {
                this._redispatched = true;
            } else {
                this._dispatched = this._manager.dispatch(this);
                if (!this._dispatched) {
                    Log.warn("Dispatched Failed!");
                    this.updateKey();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean undispatch() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this._redispatched) {
                this._redispatched = false;
                return false;
            }
            this._dispatched = false;
            this.updateKey();
        }
        return true;
    }

    public void scheduleIdle() {
        this._idleTimestamp = System.currentTimeMillis();
    }

    public void cancelIdle() {
        this._idleTimestamp = 0L;
    }

    public void checkIdleTimestamp(long now) {
        if (this._idleTimestamp != 0L && this._maxIdleTime != 0 && now > this._idleTimestamp + (long)this._maxIdleTime) {
            this.idleExpired();
        }
    }

    protected void idleExpired() {
        try {
            this.close();
        }
        catch (IOException e2) {
            Log.ignore(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int flush(Buffer header, Buffer buffer, Buffer trailer) throws IOException {
        int l = super.flush(header, buffer, trailer);
        this._writable = l != 0;
        if (!this._writable) {
            SelectChannelEndPoint selectChannelEndPoint = this;
            synchronized (selectChannelEndPoint) {
                if (!this._dispatched) {
                    this.updateKey();
                }
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int flush(Buffer buffer) throws IOException {
        int l = super.flush(buffer);
        this._writable = l != 0;
        if (!this._writable) {
            SelectChannelEndPoint selectChannelEndPoint = this;
            synchronized (selectChannelEndPoint) {
                if (!this._dispatched) {
                    this.updateKey();
                }
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadyForDispatch() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            return !this._dispatched && !this.getConnection().isSuspended();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean blockReadable(long timeoutMs) throws IOException {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            long start = this._selectSet.getNow();
            try {
                boolean bl;
                block9: {
                    this._readBlocked = true;
                    while (this.isOpen()) {
                        if (!this._readBlocked) return true;
                        try {
                            this.updateKey();
                            this.wait(timeoutMs);
                            if (!this._readBlocked || (timeoutMs -= this._selectSet.getNow() - start) > 0L) continue;
                            bl = false;
                            break block9;
                        }
                        catch (InterruptedException e2) {
                            Log.warn(e2);
                        }
                    }
                    return true;
                }
                return bl;
            }
            finally {
                this._readBlocked = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean blockWritable(long timeoutMs) throws IOException {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            long start = this._selectSet.getNow();
            try {
                boolean bl;
                block10: {
                    this._writeBlocked = true;
                    while (this.isOpen()) {
                        if (!this._writeBlocked) return true;
                        try {
                            this.updateKey();
                            this.wait(timeoutMs);
                            if (!this._writeBlocked || (timeoutMs -= this._selectSet.getNow() - start) > 0L) continue;
                            bl = false;
                            break block10;
                        }
                        catch (InterruptedException e2) {
                            Log.warn(e2);
                        }
                    }
                    return true;
                }
                return bl;
            }
            finally {
                this._writeBlocked = false;
                if (this._idleTimestamp != -1L) {
                    this.scheduleIdle();
                }
            }
        }
    }

    public void setWritable(boolean writable) {
        this._writable = writable;
    }

    public void scheduleWrite() {
        this._writable = false;
        this.updateKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateKey() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            int ops = -1;
            if (this.getChannel().isOpen()) {
                this._interestOps = (!this._dispatched || this._readBlocked ? 1 : 0) | (!this._writable || this._writeBlocked ? 4 : 0);
                try {
                    ops = this._key != null && this._key.isValid() ? this._key.interestOps() : -1;
                }
                catch (Exception e2) {
                    this._key = null;
                    Log.ignore(e2);
                }
            }
            if (this._interestOps == ops && this.getChannel().isOpen()) {
                return;
            }
        }
        this._selectSet.addChange(this);
        this._selectSet.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doUpdateKey() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            if (this.getChannel().isOpen()) {
                if (this._interestOps > 0) {
                    if (this._key == null || !this._key.isValid()) {
                        SelectableChannel sc = (SelectableChannel)((Object)this.getChannel());
                        if (sc.isRegistered()) {
                            this.updateKey();
                        } else {
                            try {
                                this._key = ((SelectableChannel)((Object)this.getChannel())).register(this._selectSet.getSelector(), this._interestOps, this);
                            }
                            catch (Exception e2) {
                                Log.ignore(e2);
                                if (this._key != null && this._key.isValid()) {
                                    this._key.cancel();
                                }
                                this.cancelIdle();
                                if (this._open) {
                                    this._selectSet.destroyEndPoint(this);
                                }
                                this._open = false;
                                this._key = null;
                            }
                        }
                    } else {
                        this._key.interestOps(this._interestOps);
                    }
                } else if (this._key.isValid()) {
                    this._key.interestOps(0);
                } else {
                    this._key = null;
                }
            } else {
                if (this._key != null && this._key.isValid()) {
                    this._key.cancel();
                }
                this.cancelIdle();
                if (this._open) {
                    this._selectSet.destroyEndPoint(this);
                }
                this._open = false;
                this._key = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block18: {
            boolean dispatched = true;
            try {
                while (dispatched) {
                    try {
                        Connection next;
                        while ((next = this._connection.handle()) != this._connection) {
                            this._connection = next;
                        }
                    }
                    catch (ClosedChannelException e2) {
                        Log.ignore(e2);
                    }
                    catch (EofException e3) {
                        Log.debug("EOF", e3);
                        try {
                            this.close();
                        }
                        catch (IOException e2) {
                            Log.ignore(e2);
                        }
                    }
                    catch (IOException e4) {
                        Log.warn(e4.toString());
                        Log.debug(e4);
                        try {
                            this.close();
                        }
                        catch (IOException e2) {
                            Log.ignore(e2);
                        }
                    }
                    catch (Throwable e5) {
                        Log.warn("handle failed", e5);
                        try {
                            this.close();
                        }
                        catch (IOException e2) {
                            Log.ignore(e2);
                        }
                    }
                    dispatched = !this.undispatch();
                }
                if (!dispatched) break block18;
                boolean bl = dispatched = !this.undispatch();
            }
            catch (Throwable throwable) {
                if (dispatched) {
                    boolean bl = dispatched = !this.undispatch();
                    while (dispatched) {
                        Log.warn("SCEP.run() finally DISPATCHED");
                        dispatched = !this.undispatch();
                    }
                }
                throw throwable;
            }
            while (dispatched) {
                Log.warn("SCEP.run() finally DISPATCHED");
                dispatched = !this.undispatch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            super.close();
        }
        catch (IOException e2) {
            Log.ignore(e2);
        }
        finally {
            this.updateKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        SelectChannelEndPoint selectChannelEndPoint = this;
        synchronized (selectChannelEndPoint) {
            return "SCEP@" + this.hashCode() + "\t[d=" + this._dispatched + ",io=" + this._interestOps + ",w=" + this._writable + ",rb=" + this._readBlocked + ",wb=" + this._writeBlocked + "]";
        }
    }

    public SelectorManager.SelectSet getSelectSet() {
        return this._selectSet;
    }

    public void setMaxIdleTime(int timeMs) throws IOException {
        this._maxIdleTime = timeMs;
    }
}

