/*
 * Decompiled with CFR 0.152.
 */
package parsers;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenStream;
import parsers.gen.SDLgrammarLexer;
import parsers.gen.SDLgrammarParser;
import shared.EscapeUtils;
import shared.m;
import shared.nested;
import shared.uncaughtexception;

public class sdlparser {
    public static Sdlfile parse(byte[] data) {
        try {
            ByteArrayInputStream in1 = new ByteArrayInputStream(data);
            ANTLRInputStream in2 = new ANTLRInputStream(in1);
            CustomLexer lexer = new CustomLexer(in2);
            CommonTokenStream tokenstream = new CommonTokenStream(lexer);
            CustomParser parser2 = new CustomParser(tokenstream);
            Sdlfile root = parser2.sdlfile();
            return root;
        }
        catch (ParseException e2) {
            m.err("Unable to correctly parse file.");
            return null;
        }
        catch (Exception e3) {
            throw new nested(e3);
        }
    }

    public static class CustomLexer
    extends SDLgrammarLexer {
        public CustomLexer(CharStream input) {
            super(input);
        }

        @Override
        public void reportError(RecognitionException re) {
            super.reportError(re);
            throw new ParseException();
        }

        @Override
        public void recover(IntStream input, RecognitionException re) {
            super.recover(input, re);
        }
    }

    public static class CustomParser
    extends SDLgrammarParser {
        public CustomParser(TokenStream input) {
            super(input);
        }

        @Override
        public void reportError(RecognitionException re) {
            super.reportError(re);
            throw new ParseException();
        }

        @Override
        public void recover(IntStream input, RecognitionException re) {
            super.recover(input, re);
        }
    }

    public static class ParseException
    extends RuntimeException {
    }

    public static class Statedesc {
        public String name;
        public int version;
        public ArrayList<Varline> varlines = new ArrayList();
        public ArrayList<Varline> varlinessimple = new ArrayList();
        public ArrayList<Varline> varlinesstatedescs = new ArrayList();

        public Statedesc(String name, int version) {
            this.name = name;
            this.version = version;
        }

        public void add(Varline varline) {
            this.varlines.add(varline);
            if (varline.type.isStatedesc()) {
                this.varlinesstatedescs.add(varline);
            } else {
                this.varlinessimple.add(varline);
            }
        }

        public int getVarCount() {
            return this.varlines.size();
        }

        public int getSimpleVarCount() {
            return this.varlinessimple.size();
        }

        public int getStatedescVarCount() {
            return this.varlinesstatedescs.size();
        }

        public Varline getVar(int index) {
            return this.varlines.get(index);
        }

        public Varline getSimpleVar(int index) {
            return this.varlinessimple.get(index);
        }

        public Varline getStatedescVar(int index) {
            return this.varlinesstatedescs.get(index);
        }

        public String toString() {
            return this.name.toString();
        }
    }

    public static class Sdlfile {
        public ArrayList<Statedesc> statedescs = new ArrayList();

        public void add(Statedesc statedesc) {
            this.statedescs.add(statedesc);
        }
    }

    public static class Varline {
        public Type type;
        public String name;
        public Integer index;
        public ArrayList<Option> options = new ArrayList();
        public OptionDefault defaultOption;

        public Varline(Type type, String name) {
            this.type = type;
            this.name = name;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public void add(Option option) {
            this.options.add(option);
            if (option instanceof OptionDefault) {
                this.defaultOption = (OptionDefault)option;
            }
        }

        public boolean isVariableLength() {
            return this.index == null;
        }

        public int getCount() {
            return this.index;
        }

        public Value getDefault() {
            if (this.defaultOption == null) {
                return null;
            }
            return this.defaultOption.value;
        }
    }

    public static class OptionDisplayoption
    extends Option {
        public Value value;

        public OptionDisplayoption(Value value) {
            this.value = value;
        }
    }

    public static class OptionDefaultoption
    extends Option {
        public Value value;

        public OptionDefaultoption(Value value) {
            this.value = value;
        }
    }

    public static class OptionDefault
    extends Option {
        public Value value;

        public OptionDefault(Value value) {
            this.value = value;
        }
    }

    public static abstract class Option {
    }

    public static abstract class Value {
        public abstract Object getValue();

        public float AsFloat() {
            Class<?> klass = this.getClass();
            if (klass == ValueFloat.class) {
                return ((ValueFloat)this).value;
            }
            if (klass == ValueInt.class) {
                return ((ValueInt)this).value;
            }
            throw new uncaughtexception("wasn't a float");
        }
    }

    public static abstract class Type {
        public static final byte kNone = -1;
        public static final byte kInt = 0;
        public static final byte kFloat = 1;
        public static final byte kBool = 2;
        public static final byte kString = 3;
        public static final byte kKey = 4;
        public static final byte kStateDescriptor = 5;
        public static final byte kCreatable = 6;
        public static final byte kDouble = 7;
        public static final byte kTime = 8;
        public static final byte kByte = 9;
        public static final byte kShort = 10;
        public static final byte kAgeTimeOfDay = 11;
        public static final byte kVector3 = 50;
        public static final byte kPoint3 = 51;
        public static final byte kRGB = 52;
        public static final byte kRGBA = 53;
        public static final byte kQuaternion = 54;
        public static final byte kRGB8 = 55;
        public static final byte kRGBA8 = 56;
        public byte type;

        public boolean isStatedesc() {
            return this instanceof TypeStatedesc;
        }
    }

    public static class TypeStatedesc
    extends Type {
        public String typestr;

        public TypeStatedesc(String typestr) {
            this.typestr = typestr;
            this.type = (byte)5;
        }
    }

    public static class TypeStd
    extends Type {
        public String typestr;

        public TypeStd(String typestr) {
            this.typestr = typestr;
            String t = typestr.toLowerCase();
            if (t.equals("int")) {
                this.type = 0;
            } else if (t.equals("float")) {
                this.type = 1;
            } else if (t.equals("bool")) {
                this.type = (byte)2;
            } else if (t.equals("byte")) {
                this.type = (byte)9;
            } else if (t.equals("creatable")) {
                this.type = (byte)6;
            } else if (t.equals("time")) {
                this.type = (byte)8;
            } else if (t.equals("string32")) {
                this.type = (byte)3;
            } else if (t.equals("short")) {
                this.type = (byte)10;
            } else if (t.equals("plkey")) {
                this.type = (byte)4;
            } else if (t.equals("point3")) {
                this.type = (byte)51;
            } else if (t.equals("rgb8")) {
                this.type = (byte)55;
            } else if (t.equals("agetimeofday")) {
                this.type = (byte)11;
            } else if (t.equals("quaternion")) {
                this.type = (byte)54;
            } else if (t.equals("vector3")) {
                this.type = (byte)50;
            } else {
                m.throwUncaughtException("unhandled");
            }
        }
    }

    public static class ValueString
    extends Value {
        public String value;

        public ValueString(String escapedvalue) {
            this.value = EscapeUtils.unescapeJavaString(escapedvalue);
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    public static class ValueFloat
    extends Value {
        public float value;

        public ValueFloat(float value) {
            this.value = value;
        }

        @Override
        public Object getValue() {
            return Float.valueOf(this.value);
        }
    }

    public static class ValueInt
    extends Value {
        public int value;

        public ValueInt(int value) {
            this.value = value;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    public static class ValueName
    extends Value {
        public String name;

        public ValueName(String name) {
            this.name = name;
        }

        @Override
        public Object getValue() {
            return this.name;
        }
    }

    public static class ValueTuple
    extends Value {
        public ArrayList<Value> values = new ArrayList();

        public void add(Value value) {
            this.values.add(value);
        }

        @Override
        public Object getValue() {
            return this.values;
        }
    }
}

