/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.bouncycastle.crypto.StreamCipher;
import shared.IBytedeque;
import shared.b;
import shared.nested;
import shared.uncaughtexception;

public class CryptoBytedeque
extends IBytedeque {
    OutputStream out;
    StreamCipher cipher;

    public CryptoBytedeque(OutputStream out, StreamCipher cipher) {
        this.out = out;
        this.cipher = cipher;
    }

    @Override
    public void writeInt(int n) {
        int b1 = n >>> 0 & 0xFF;
        int b2 = n >>> 8 & 0xFF;
        int b3 = n >>> 16 & 0xFF;
        int b4 = n >>> 24 & 0xFF;
        this.write(b1);
        this.write(b2);
        this.write(b3);
        this.write(b4);
    }

    @Override
    public void writeShort(short n) {
        int b1 = n >>> 0 & 0xFF;
        int b2 = n >>> 8 & 0xFF;
        this.write(b1);
        this.write(b2);
    }

    @Override
    public IBytedeque Fork() {
        throw new uncaughtexception("unimplemented");
    }

    @Override
    public byte[] getAllBytes() {
        throw new uncaughtexception("unimplemented");
    }

    @Override
    public void writeBytes(byte[] bytes) {
        try {
            byte[] r = new byte[bytes.length];
            this.cipher.processBytes(bytes, 0, bytes.length, r, 0);
            this.out.write(r);
        }
        catch (IOException e2) {
            throw new nested(e2);
        }
    }

    @Override
    public void writeByte(byte b1) {
        try {
            byte b2 = this.cipher.returnByte(b1);
            int b3 = b.ByteToInt32(b2);
            this.out.write(b3);
        }
        catch (IOException e2) {
            throw new nested(e2);
        }
    }

    public void write(int byt) {
        try {
            byte b1 = (byte)byt;
            byte b2 = this.cipher.returnByte(b1);
            int b3 = b.ByteToInt32(b2);
            this.out.write(b3);
        }
        catch (IOException e2) {
            throw new nested(e2);
        }
    }

    @Override
    public void writeShorts(short[] shorts) {
        for (short n : shorts) {
            int b1 = n >>> 0 & 0xFF;
            int b2 = n >>> 8 & 0xFF;
            this.write(b1);
            this.write(b2);
        }
    }

    @Override
    protected Iterator<byte[]> getIterator() {
        throw new uncaughtexception("unimplemented");
    }

    @Override
    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException e2) {
            throw new nested(e2);
        }
    }
}

