/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.math.BigInteger;
import java.util.Random;
import shared.b;
import shared.uncaughtexception;

public class LargeInteger {
    private BigInteger val;

    public LargeInteger(long l) {
        this.val = BigInteger.valueOf(l);
    }

    public LargeInteger(int numbits, Random rng) {
        this.val = new BigInteger(numbits, rng);
    }

    public LargeInteger(String littleendian_hexstr) {
        String revhexstr = LargeInteger.reverseHexstr(littleendian_hexstr);
        this.val = new BigInteger(revhexstr, 16);
    }

    public LargeInteger(byte[] littleendian_bytes) {
        this(b.BytesToHexString(littleendian_bytes));
    }

    private LargeInteger(BigInteger val2) {
        this.val = val2;
    }

    private LargeInteger() {
    }

    public static LargeInteger probablePrime(int bitlength, Random rng) {
        return new LargeInteger(BigInteger.probablePrime(512, rng));
    }

    private static String reverseHexstr(String hexstr) {
        StringBuilder r = new StringBuilder();
        for (int i = hexstr.length() - 2; i >= 0; i -= 2) {
            char c1 = hexstr.charAt(i);
            char c2 = hexstr.charAt(i + 1);
            r.append(c1);
            r.append(c2);
        }
        return r.toString();
    }

    public LargeInteger modPow(LargeInteger exponent, LargeInteger mod) {
        BigInteger newval = this.val.modPow(exponent.val, mod.val);
        return new LargeInteger(newval);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] toBytes(int size) {
        byte[] result;
        byte[] bytes = this.val.toByteArray();
        if (bytes.length == size) {
            result = bytes;
        } else if (bytes.length < size) {
            int pad = size = bytes.length;
            result = new byte[size];
            for (int i = 0; i < bytes.length; ++i) {
                result[i + pad] = bytes[i];
            }
        } else {
            if (bytes.length != size + 1) throw new uncaughtexception("Can not fit in given size.");
            if (bytes[0] != 0) throw new uncaughtexception("Can not fit in given size.");
            result = new byte[size];
            for (int i = 0; i < size; ++i) {
                result[i] = bytes[i + 1];
            }
        }
        b.reverseEndianness(result);
        return result;
    }

    public String toString(int size) {
        byte[] data = this.toBytes(size);
        String r = b.BytesToHexString(data);
        return r;
    }

    public String toString() {
        return this.toString(64);
    }
}

