/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.xmp.impl;

import com.adobe.internal.xmp.XMPConst;
import com.adobe.internal.xmp.XMPError;
import com.adobe.internal.xmp.XMPException;
import com.adobe.internal.xmp.XMPMetaFactory;
import com.adobe.internal.xmp.XMPSchemaRegistry;
import com.adobe.internal.xmp.impl.Utils;
import com.adobe.internal.xmp.impl.XMPMetaImpl;
import com.adobe.internal.xmp.impl.XMPNode;
import com.adobe.internal.xmp.impl.XMPNodeUtils;
import com.adobe.internal.xmp.options.ParseOptions;
import com.adobe.internal.xmp.options.PropertyOptions;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ParseRDF
implements XMPError,
XMPConst {
    public static final int RDFTERM_OTHER = 0;
    public static final int RDFTERM_RDF = 1;
    public static final int RDFTERM_ID = 2;
    public static final int RDFTERM_ABOUT = 3;
    public static final int RDFTERM_PARSE_TYPE = 4;
    public static final int RDFTERM_RESOURCE = 5;
    public static final int RDFTERM_NODE_ID = 6;
    public static final int RDFTERM_DATATYPE = 7;
    public static final int RDFTERM_DESCRIPTION = 8;
    public static final int RDFTERM_LI = 9;
    public static final int RDFTERM_ABOUT_EACH = 10;
    public static final int RDFTERM_ABOUT_EACH_PREFIX = 11;
    public static final int RDFTERM_BAG_ID = 12;
    public static final int RDFTERM_FIRST_CORE = 1;
    public static final int RDFTERM_LAST_CORE = 7;
    public static final int RDFTERM_FIRST_SYNTAX = 1;
    public static final int RDFTERM_LAST_SYNTAX = 9;
    public static final int RDFTERM_FIRST_OLD = 10;
    public static final int RDFTERM_LAST_OLD = 12;
    public static final String DEFAULT_PREFIX = "_dflt";

    static XMPMetaImpl parse(Node xmlRoot, ParseOptions options) throws XMPException {
        XMPMetaImpl xmp = new XMPMetaImpl();
        ParseRDF.rdf_RDF(xmp, xmlRoot, options);
        return xmp;
    }

    static void rdf_RDF(XMPMetaImpl xmp, Node rdfRdfNode, ParseOptions options) throws XMPException {
        if (!rdfRdfNode.hasAttributes()) {
            throw new XMPException("Invalid attributes of rdf:RDF element", 202);
        }
        ParseRDF.rdf_NodeElementList(xmp, xmp.getRoot(), rdfRdfNode, options);
    }

    private static void rdf_NodeElementList(XMPMetaImpl xmp, XMPNode xmpParent, Node rdfRdfNode, ParseOptions options) throws XMPException {
        for (int i = 0; i < rdfRdfNode.getChildNodes().getLength(); ++i) {
            Node child = rdfRdfNode.getChildNodes().item(i);
            if (ParseRDF.isWhitespaceNode(child)) continue;
            ParseRDF.rdf_NodeElement(xmp, xmpParent, child, true, options);
        }
    }

    private static void rdf_NodeElement(XMPMetaImpl xmp, XMPNode xmpParent, Node xmlNode, boolean isTopLevel, ParseOptions options) throws XMPException {
        int nodeTerm = ParseRDF.getRDFTermKind(xmlNode);
        if (nodeTerm != 8 && nodeTerm != 0) {
            throw new XMPException("Node element must be rdf:Description or typed node", 202);
        }
        if (isTopLevel && nodeTerm == 0) {
            throw new XMPException("Top level typed node not allowed", 203);
        }
        ParseRDF.rdf_NodeElementAttrs(xmp, xmpParent, xmlNode, isTopLevel, options);
        ParseRDF.rdf_PropertyElementList(xmp, xmpParent, xmlNode, isTopLevel, options);
    }

    private static void rdf_NodeElementAttrs(XMPMetaImpl xmp, XMPNode xmpParent, Node xmlNode, boolean isTopLevel, ParseOptions options) throws XMPException {
        int exclusiveAttrs = 0;
        block4: for (int i = 0; i < xmlNode.getAttributes().getLength(); ++i) {
            Node attribute = xmlNode.getAttributes().item(i);
            if ("xmlns".equals(attribute.getPrefix()) || attribute.getPrefix() == null && "xmlns".equals(attribute.getNodeName())) continue;
            int attrTerm = ParseRDF.getRDFTermKind(attribute);
            switch (attrTerm) {
                case 2: 
                case 3: 
                case 6: {
                    if (exclusiveAttrs > 0) {
                        throw new XMPException("Mutally exclusive about, ID, nodeID attributes", 202);
                    }
                    ++exclusiveAttrs;
                    if (!isTopLevel || attrTerm != 3) continue block4;
                    if (xmpParent.getName() != null && xmpParent.getName().length() > 0) {
                        if (xmpParent.getName().equals(attribute.getNodeValue())) continue block4;
                        throw new XMPException("Mismatched top level rdf:about values", 203);
                    }
                    xmpParent.setName(attribute.getNodeValue());
                    continue block4;
                }
                case 0: {
                    ParseRDF.addChildNode(xmp, xmpParent, attribute, attribute.getNodeValue(), isTopLevel);
                    continue block4;
                }
                default: {
                    throw new XMPException("Invalid nodeElement attribute", 202);
                }
            }
        }
    }

    private static void rdf_PropertyElementList(XMPMetaImpl xmp, XMPNode xmpParent, Node xmlParent, boolean isTopLevel, ParseOptions options) throws XMPException {
        for (int i = 0; i < xmlParent.getChildNodes().getLength(); ++i) {
            Node currChild = xmlParent.getChildNodes().item(i);
            if (ParseRDF.isWhitespaceNode(currChild)) continue;
            if (currChild.getNodeType() != 1) {
                throw new XMPException("Expected property element node not found", 202);
            }
            if (xmpParent.getOptions().isArrayLimited() && i > xmpParent.getOptions().getArrayElementsLimit()) break;
            ParseRDF.rdf_PropertyElement(xmp, xmpParent, currChild, isTopLevel, options);
        }
    }

    private static void rdf_PropertyElement(XMPMetaImpl xmp, XMPNode xmpParent, Node xmlNode, boolean isTopLevel, ParseOptions options) throws XMPException {
        Node attribute;
        int i;
        int nodeTerm = ParseRDF.getRDFTermKind(xmlNode);
        if (!ParseRDF.isPropertyElementName(nodeTerm)) {
            throw new XMPException("Invalid property element name", 202);
        }
        NamedNodeMap attributes = xmlNode.getAttributes();
        ArrayList<String> nsAttrs = null;
        for (i = 0; i < attributes.getLength(); ++i) {
            attribute = attributes.item(i);
            if (!"xmlns".equals(attribute.getPrefix()) && (attribute.getPrefix() != null || !"xmlns".equals(attribute.getNodeName()))) continue;
            if (nsAttrs == null) {
                nsAttrs = new ArrayList<String>();
            }
            nsAttrs.add(attribute.getNodeName());
        }
        if (nsAttrs != null) {
            for (String ns : nsAttrs) {
                attributes.removeNamedItem(ns);
            }
        }
        if (attributes.getLength() > 3) {
            ParseRDF.rdf_EmptyPropertyElement(xmp, xmpParent, xmlNode, isTopLevel);
        } else {
            for (i = 0; i < attributes.getLength(); ++i) {
                attribute = attributes.item(i);
                String attrLocal = attribute.getLocalName();
                String attrNS = attribute.getNamespaceURI();
                String attrValue = attribute.getNodeValue();
                if ("xml:lang".equals(attribute.getNodeName()) && (!"ID".equals(attrLocal) || !"http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(attrNS))) continue;
                if ("datatype".equals(attrLocal) && "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(attrNS)) {
                    ParseRDF.rdf_LiteralPropertyElement(xmp, xmpParent, xmlNode, isTopLevel);
                } else if (!"parseType".equals(attrLocal) || !"http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(attrNS)) {
                    ParseRDF.rdf_EmptyPropertyElement(xmp, xmpParent, xmlNode, isTopLevel);
                } else if ("Literal".equals(attrValue)) {
                    ParseRDF.rdf_ParseTypeLiteralPropertyElement();
                } else if ("Resource".equals(attrValue)) {
                    ParseRDF.rdf_ParseTypeResourcePropertyElement(xmp, xmpParent, xmlNode, isTopLevel, options);
                } else if ("Collection".equals(attrValue)) {
                    ParseRDF.rdf_ParseTypeCollectionPropertyElement();
                } else {
                    ParseRDF.rdf_ParseTypeOtherPropertyElement();
                }
                return;
            }
            if (xmlNode.hasChildNodes()) {
                for (i = 0; i < xmlNode.getChildNodes().getLength(); ++i) {
                    Node currChild = xmlNode.getChildNodes().item(i);
                    if (currChild.getNodeType() == 3) continue;
                    ParseRDF.rdf_ResourcePropertyElement(xmp, xmpParent, xmlNode, isTopLevel, options);
                    return;
                }
                ParseRDF.rdf_LiteralPropertyElement(xmp, xmpParent, xmlNode, isTopLevel);
            } else {
                ParseRDF.rdf_EmptyPropertyElement(xmp, xmpParent, xmlNode, isTopLevel);
            }
        }
    }

    private static void rdf_ResourcePropertyElement(XMPMetaImpl xmp, XMPNode xmpParent, Node xmlNode, boolean isTopLevel, ParseOptions options) throws XMPException {
        if (isTopLevel && "iX:changes".equals(xmlNode.getNodeName())) {
            return;
        }
        XMPNode newCompound = ParseRDF.addChildNode(xmp, xmpParent, xmlNode, "", isTopLevel);
        for (int i = 0; i < xmlNode.getAttributes().getLength(); ++i) {
            Node attribute = xmlNode.getAttributes().item(i);
            if ("xmlns".equals(attribute.getPrefix()) || attribute.getPrefix() == null && "xmlns".equals(attribute.getNodeName())) continue;
            String attrLocal = attribute.getLocalName();
            String attrNS = attribute.getNamespaceURI();
            if ("xml:lang".equals(attribute.getNodeName())) {
                ParseRDF.addQualifierNode(newCompound, "xml:lang", attribute.getNodeValue());
                continue;
            }
            if ("ID".equals(attrLocal) && "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(attrNS)) continue;
            throw new XMPException("Invalid attribute for resource property element", 202);
        }
        Node currChild = null;
        boolean found = false;
        for (int i = 0; i < xmlNode.getChildNodes().getLength(); ++i) {
            currChild = xmlNode.getChildNodes().item(i);
            if (ParseRDF.isWhitespaceNode(currChild)) continue;
            if (currChild.getNodeType() == 1 && !found) {
                Integer listLimit;
                boolean isRDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(currChild.getNamespaceURI());
                String childLocal = currChild.getLocalName();
                if (isRDF && "Bag".equals(childLocal)) {
                    newCompound.getOptions().setArray(true);
                } else if (isRDF && "Seq".equals(childLocal)) {
                    newCompound.getOptions().setArray(true).setArrayOrdered(true);
                } else if (isRDF && "Alt".equals(childLocal)) {
                    newCompound.getOptions().setArray(true).setArrayOrdered(true).setArrayAlternate(true);
                } else {
                    newCompound.getOptions().setStruct(true);
                    if (!isRDF && !"Description".equals(childLocal)) {
                        String typeName = currChild.getNamespaceURI();
                        if (typeName == null) {
                            throw new XMPException("All XML elements must be in a namespace", 203);
                        }
                        typeName = typeName + ':' + childLocal;
                        ParseRDF.addQualifierNode(newCompound, "rdf:type", typeName);
                    }
                }
                if (newCompound.getOptions().isArray() && (listLimit = options.getXMPNodesToLimit().get(newCompound.getName())) != null) {
                    newCompound.getOptions().setArrayElementLimit(listLimit);
                }
                ParseRDF.rdf_NodeElement(xmp, newCompound, currChild, false, options);
                if (newCompound.getHasValueChild()) {
                    ParseRDF.fixupQualifiedNode(newCompound);
                } else if (newCompound.getOptions().isArrayAlternate()) {
                    XMPNodeUtils.detectAltText(newCompound);
                }
                found = true;
                continue;
            }
            if (found) {
                throw new XMPException("Invalid child of resource property element", 202);
            }
            throw new XMPException("Children of resource property element must be XML elements", 202);
        }
        if (!found) {
            throw new XMPException("Missing child of resource property element", 202);
        }
    }

    private static void rdf_LiteralPropertyElement(XMPMetaImpl xmp, XMPNode xmpParent, Node xmlNode, boolean isTopLevel) throws XMPException {
        XMPNode newChild = ParseRDF.addChildNode(xmp, xmpParent, xmlNode, null, isTopLevel);
        for (int i = 0; i < xmlNode.getAttributes().getLength(); ++i) {
            Node attribute = xmlNode.getAttributes().item(i);
            if ("xmlns".equals(attribute.getPrefix()) || attribute.getPrefix() == null && "xmlns".equals(attribute.getNodeName())) continue;
            String attrNS = attribute.getNamespaceURI();
            String attrLocal = attribute.getLocalName();
            if ("xml:lang".equals(attribute.getNodeName())) {
                ParseRDF.addQualifierNode(newChild, "xml:lang", attribute.getNodeValue());
                continue;
            }
            if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(attrNS) && ("ID".equals(attrLocal) || "datatype".equals(attrLocal))) continue;
            throw new XMPException("Invalid attribute for literal property element", 202);
        }
        String textValue = "";
        for (int i = 0; i < xmlNode.getChildNodes().getLength(); ++i) {
            Node child = xmlNode.getChildNodes().item(i);
            if (child.getNodeType() != 3) {
                throw new XMPException("Invalid child of literal property element", 202);
            }
            textValue = textValue + child.getNodeValue();
        }
        newChild.setValue(textValue);
    }

    private static void rdf_ParseTypeLiteralPropertyElement() throws XMPException {
        throw new XMPException("ParseTypeLiteral property element not allowed", 203);
    }

    private static void rdf_ParseTypeResourcePropertyElement(XMPMetaImpl xmp, XMPNode xmpParent, Node xmlNode, boolean isTopLevel, ParseOptions options) throws XMPException {
        XMPNode newStruct = ParseRDF.addChildNode(xmp, xmpParent, xmlNode, "", isTopLevel);
        newStruct.getOptions().setStruct(true);
        for (int i = 0; i < xmlNode.getAttributes().getLength(); ++i) {
            Node attribute = xmlNode.getAttributes().item(i);
            if ("xmlns".equals(attribute.getPrefix()) || attribute.getPrefix() == null && "xmlns".equals(attribute.getNodeName())) continue;
            String attrLocal = attribute.getLocalName();
            String attrNS = attribute.getNamespaceURI();
            if ("xml:lang".equals(attribute.getNodeName())) {
                ParseRDF.addQualifierNode(newStruct, "xml:lang", attribute.getNodeValue());
                continue;
            }
            if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(attrNS) && ("ID".equals(attrLocal) || "parseType".equals(attrLocal))) continue;
            throw new XMPException("Invalid attribute for ParseTypeResource property element", 202);
        }
        ParseRDF.rdf_PropertyElementList(xmp, newStruct, xmlNode, false, options);
        if (newStruct.getHasValueChild()) {
            ParseRDF.fixupQualifiedNode(newStruct);
        }
    }

    private static void rdf_ParseTypeCollectionPropertyElement() throws XMPException {
        throw new XMPException("ParseTypeCollection property element not allowed", 203);
    }

    private static void rdf_ParseTypeOtherPropertyElement() throws XMPException {
        throw new XMPException("ParseTypeOther property element not allowed", 203);
    }

    private static void rdf_EmptyPropertyElement(XMPMetaImpl xmp, XMPNode xmpParent, Node xmlNode, boolean isTopLevel) throws XMPException {
        boolean hasPropertyAttrs = false;
        boolean hasResourceAttr = false;
        boolean hasNodeIDAttr = false;
        boolean hasValueAttr = false;
        Node valueNode = null;
        if (xmlNode.hasChildNodes()) {
            throw new XMPException("Nested content not allowed with rdf:resource or property attributes", 202);
        }
        block11: for (int i = 0; i < xmlNode.getAttributes().getLength(); ++i) {
            Node attribute = xmlNode.getAttributes().item(i);
            if ("xmlns".equals(attribute.getPrefix()) || attribute.getPrefix() == null && "xmlns".equals(attribute.getNodeName())) continue;
            int attrTerm = ParseRDF.getRDFTermKind(attribute);
            switch (attrTerm) {
                case 2: {
                    continue block11;
                }
                case 5: {
                    if (hasNodeIDAttr) {
                        throw new XMPException("Empty property element can't have both rdf:resource and rdf:nodeID", 202);
                    }
                    if (hasValueAttr) {
                        throw new XMPException("Empty property element can't have both rdf:value and rdf:resource", 203);
                    }
                    hasResourceAttr = true;
                    if (hasValueAttr) continue block11;
                    valueNode = attribute;
                    continue block11;
                }
                case 6: {
                    if (hasResourceAttr) {
                        throw new XMPException("Empty property element can't have both rdf:resource and rdf:nodeID", 202);
                    }
                    hasNodeIDAttr = true;
                    continue block11;
                }
                case 0: {
                    if ("value".equals(attribute.getLocalName()) && "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(attribute.getNamespaceURI())) {
                        if (hasResourceAttr) {
                            throw new XMPException("Empty property element can't have both rdf:value and rdf:resource", 203);
                        }
                        hasValueAttr = true;
                        valueNode = attribute;
                        continue block11;
                    }
                    if ("xml:lang".equals(attribute.getNodeName())) continue block11;
                    hasPropertyAttrs = true;
                    continue block11;
                }
                default: {
                    throw new XMPException("Unrecognized attribute of empty property element", 202);
                }
            }
        }
        XMPNode childNode = ParseRDF.addChildNode(xmp, xmpParent, xmlNode, "", isTopLevel);
        boolean childIsStruct = false;
        if (hasValueAttr || hasResourceAttr) {
            childNode.setValue(valueNode != null ? valueNode.getNodeValue() : "");
            if (!hasValueAttr) {
                childNode.getOptions().setURI(true);
            }
        } else if (hasPropertyAttrs) {
            childNode.getOptions().setStruct(true);
            childIsStruct = true;
        }
        block12: for (int i = 0; i < xmlNode.getAttributes().getLength(); ++i) {
            Node attribute = xmlNode.getAttributes().item(i);
            if (attribute == valueNode || "xmlns".equals(attribute.getPrefix()) || attribute.getPrefix() == null && "xmlns".equals(attribute.getNodeName())) continue;
            int attrTerm = ParseRDF.getRDFTermKind(attribute);
            switch (attrTerm) {
                case 2: 
                case 6: {
                    continue block12;
                }
                case 5: {
                    ParseRDF.addQualifierNode(childNode, "rdf:resource", attribute.getNodeValue());
                    continue block12;
                }
                case 0: {
                    if (!childIsStruct) {
                        ParseRDF.addQualifierNode(childNode, attribute.getNodeName(), attribute.getNodeValue());
                        continue block12;
                    }
                    if ("xml:lang".equals(attribute.getNodeName())) {
                        ParseRDF.addQualifierNode(childNode, "xml:lang", attribute.getNodeValue());
                        continue block12;
                    }
                    ParseRDF.addChildNode(xmp, childNode, attribute, attribute.getNodeValue(), false);
                    continue block12;
                }
                default: {
                    throw new XMPException("Unrecognized attribute of empty property element", 202);
                }
            }
        }
    }

    private static XMPNode addChildNode(XMPMetaImpl xmp, XMPNode xmpParent, Node xmlNode, String value, boolean isTopLevel) throws XMPException {
        boolean isParentArray;
        String prefix;
        XMPSchemaRegistry registry = XMPMetaFactory.getSchemaRegistry();
        String namespace = xmlNode.getNamespaceURI();
        if (namespace != null) {
            if ("http://purl.org/dc/1.1/".equals(namespace)) {
                namespace = "http://purl.org/dc/elements/1.1/";
            }
            if ((prefix = registry.getNamespacePrefix(namespace)) == null) {
                prefix = xmlNode.getPrefix() != null ? xmlNode.getPrefix() : DEFAULT_PREFIX;
                prefix = registry.registerNamespace(namespace, prefix);
            }
        } else {
            throw new XMPException("XML namespace required for all elements and attributes", 202);
        }
        String childName = prefix + xmlNode.getLocalName();
        PropertyOptions childOptions = new PropertyOptions();
        boolean isAlias = false;
        if (isTopLevel) {
            XMPNode schemaNode = XMPNodeUtils.findSchemaNode(xmp.getRoot(), namespace, DEFAULT_PREFIX, true);
            schemaNode.setImplicit(false);
            xmpParent = schemaNode;
            if (registry.findAlias(childName) != null) {
                isAlias = true;
                xmp.getRoot().setHasAliases(true);
                schemaNode.setHasAliases(true);
            }
        }
        boolean isArrayItem = ParseRDF.isNumberedArrayItemName(childName);
        boolean isValueNode = "rdf:value".equals(childName);
        XMPNode newChild = new XMPNode(childName, value, childOptions);
        newChild.setAlias(isAlias);
        if (!isValueNode) {
            xmpParent.addChild(newChild);
        } else {
            xmpParent.addChild(1, newChild);
        }
        if (isValueNode) {
            if (isTopLevel || !xmpParent.getOptions().isStruct()) {
                throw new XMPException("Misplaced rdf:value element", 202);
            }
            xmpParent.setHasValueChild(true);
        }
        if ((isParentArray = xmpParent.getOptions().isArray()) && isArrayItem) {
            newChild.setName("[]");
        } else {
            if (!isParentArray && isArrayItem) {
                throw new XMPException("Misplaced rdf:li element", 202);
            }
            if (isParentArray && !isArrayItem) {
                throw new XMPException("Arrays cannot have arbitrary child names", 202);
            }
        }
        return newChild;
    }

    private static XMPNode addQualifierNode(XMPNode xmpParent, String name, String value) throws XMPException {
        boolean isLang = "xml:lang".equals(name);
        XMPNode newQual = null;
        newQual = new XMPNode(name, isLang ? Utils.normalizeLangValue(value) : value, null);
        xmpParent.addQualifier(newQual);
        return newQual;
    }

    private static void fixupQualifiedNode(XMPNode xmpParent) throws XMPException {
        XMPNode qualifier;
        int i;
        assert (xmpParent.getOptions().isStruct() && xmpParent.hasChildren());
        XMPNode valueNode = xmpParent.getChild(1);
        assert ("rdf:value".equals(valueNode.getName()));
        if (valueNode.getOptions().getHasLanguage()) {
            if (xmpParent.getOptions().getHasLanguage()) {
                throw new XMPException("Redundant xml:lang for rdf:value element", 203);
            }
            XMPNode langQual = valueNode.getQualifier(1);
            valueNode.removeQualifier(langQual);
            xmpParent.addQualifier(langQual);
        }
        for (i = 1; i <= valueNode.getQualifierLength(); ++i) {
            qualifier = valueNode.getQualifier(i);
            xmpParent.addQualifier(qualifier);
        }
        for (i = 2; i <= xmpParent.getChildrenLength(); ++i) {
            qualifier = xmpParent.getChild(i);
            xmpParent.addQualifier(qualifier);
        }
        assert (xmpParent.getOptions().isStruct() || xmpParent.getHasValueChild());
        xmpParent.setHasValueChild(false);
        xmpParent.getOptions().setStruct(false);
        xmpParent.getOptions().mergeWith(valueNode.getOptions());
        xmpParent.setValue(valueNode.getValue());
        xmpParent.removeChildren();
        Iterator it = valueNode.iterateChildren();
        while (it.hasNext()) {
            XMPNode child = (XMPNode)it.next();
            xmpParent.addChild(child);
        }
    }

    private static boolean isWhitespaceNode(Node node) {
        if (node.getNodeType() != 3) {
            return false;
        }
        String value = node.getNodeValue();
        for (int i = 0; i < value.length(); ++i) {
            if (Character.isWhitespace(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isPropertyElementName(int term) {
        if (term == 8 || ParseRDF.isOldTerm(term)) {
            return false;
        }
        return !ParseRDF.isCoreSyntaxTerm(term);
    }

    private static boolean isOldTerm(int term) {
        return 10 <= term && term <= 12;
    }

    private static boolean isCoreSyntaxTerm(int term) {
        return 1 <= term && term <= 7;
    }

    private static int getRDFTermKind(Node node) {
        String localName = node.getLocalName();
        String namespace = node.getNamespaceURI();
        if (namespace == null && ("about".equals(localName) || "ID".equals(localName)) && node instanceof Attr && "http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(((Attr)node).getOwnerElement().getNamespaceURI())) {
            namespace = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
        }
        if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(namespace)) {
            if ("li".equals(localName)) {
                return 9;
            }
            if ("parseType".equals(localName)) {
                return 4;
            }
            if ("Description".equals(localName)) {
                return 8;
            }
            if ("about".equals(localName)) {
                return 3;
            }
            if ("resource".equals(localName)) {
                return 5;
            }
            if ("RDF".equals(localName)) {
                return 1;
            }
            if ("ID".equals(localName)) {
                return 2;
            }
            if ("nodeID".equals(localName)) {
                return 6;
            }
            if ("datatype".equals(localName)) {
                return 7;
            }
            if ("aboutEach".equals(localName)) {
                return 10;
            }
            if ("aboutEachPrefix".equals(localName)) {
                return 11;
            }
            if ("bagID".equals(localName)) {
                return 12;
            }
        }
        return 0;
    }

    private static boolean isNumberedArrayItemName(String nodeName) {
        boolean result = "rdf:li".equals(nodeName);
        if (nodeName.startsWith("rdf:_")) {
            result = true;
            for (int i = 5; i < nodeName.length(); ++i) {
                result = result && nodeName.charAt(i) >= '0' && nodeName.charAt(i) <= '9';
            }
        }
        return result;
    }
}

