/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.Collection;
import java.util.Objects;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.TransformNodesCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;

public class RotateCommand
extends TransformNodesCommand {
    private final EastNorth pivot = this.getNodesCenter();
    private final double startAngle;
    private double rotationAngle;

    public RotateCommand(Collection<? extends OsmPrimitive> objects, EastNorth currentEN) {
        super(objects);
        this.startAngle = this.getAngle(currentEN);
        this.rotationAngle = 0.0;
        this.handleEvent(currentEN);
    }

    protected final double getAngle(EastNorth currentEN) {
        if (this.pivot == null) {
            return 0.0;
        }
        return Math.atan2(currentEN.east() - this.pivot.east(), currentEN.north() - this.pivot.north());
    }

    @Override
    public final void handleEvent(EastNorth currentEN) {
        double currentAngle = this.getAngle(currentEN);
        this.rotationAngle = currentAngle - this.startAngle;
        this.transformNodes();
    }

    protected void setRotationAngle(double rotationAngle) {
        this.rotationAngle = rotationAngle;
    }

    @Override
    protected void transformNodes() {
        double cosPhi = Math.cos(this.rotationAngle);
        double sinPhi = Math.sin(this.rotationAngle);
        for (Node n : this.nodes) {
            EastNorth oldEastNorth = ((Command.OldNodeState)this.oldStates.get(n)).getEastNorth();
            double x = oldEastNorth.east() - this.pivot.east();
            double y = oldEastNorth.north() - this.pivot.north();
            double nx = cosPhi * x + sinPhi * y + this.pivot.east();
            double ny = -sinPhi * x + cosPhi * y + this.pivot.north();
            n.setEastNorth(new EastNorth(nx, ny));
        }
    }

    @Override
    public String getDescriptionText() {
        return I18n.trn("Rotate {0} node", "Rotate {0} nodes", this.nodes.size(), this.nodes.size());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.pivot, this.startAngle, this.rotationAngle);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        RotateCommand that = (RotateCommand)obj;
        return Double.compare(that.startAngle, this.startAngle) == 0 && Double.compare(that.rotationAngle, this.rotationAngle) == 0 && Objects.equals(this.pivot, that.pivot);
    }
}

