/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.ac;

import java.awt.im.InputContext;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Locale;
import javax.swing.ComboBoxEditor;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompComboBoxEditor;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompComboBoxModel;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompEvent;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompListener;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompTextField;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.tools.Logging;

public class AutoCompComboBox<E>
extends JosmComboBox<E>
implements AutoCompListener {
    private boolean useFixedLocale;
    private final transient InputContext privateInputContext = InputContext.getInstance();

    public AutoCompComboBox() {
        this(new AutoCompComboBoxModel());
    }

    public AutoCompComboBox(AutoCompComboBoxModel<E> model) {
        super(model);
        this.setEditor(new AutoCompComboBoxEditor());
        this.setEditable(true);
        ((AutoCompTextField)this.getEditorComponent()).setModel(model);
        ((AutoCompTextField)this.getEditorComponent()).addAutoCompListener(this);
    }

    @Override
    public AutoCompComboBoxModel<E> getModel() {
        return (AutoCompComboBoxModel)this.dataModel;
    }

    @Override
    public void setEditor(ComboBoxEditor newEditor) {
        if (this.editor != null) {
            this.editor.getEditorComponent().removePropertyChangeListener(this);
        }
        super.setEditor(newEditor);
        if (this.editor != null) {
            this.editor.getEditorComponent().addPropertyChangeListener(this);
        }
    }

    @Override
    public AutoCompTextField<E> getEditorComponent() {
        return this.getEditor() == null ? null : (AutoCompTextField)this.getEditor().getEditorComponent();
    }

    private void autocomplete(Object item) {
        String savedText = this.getText();
        this.setSelectedItem(item);
        this.setText(savedText);
    }

    @Deprecated
    public void setPossibleItems(Collection<E> elems) {
        LinkedList<E> reversed = new LinkedList<E>(elems);
        Collections.reverse(reversed);
        this.setPossibleAcItems(reversed);
    }

    @Deprecated
    public void setPossibleItemsTopDown(Collection<E> elems) {
        this.setPossibleAcItems(elems);
    }

    @Deprecated
    public void setPossibleAcItems(Collection<E> elems) {
        Object oldValue = this.getEditor().getItem();
        this.getModel().removeAllElements();
        this.getModel().addAllElements(elems);
        this.getEditor().setItem(oldValue);
    }

    public boolean setAutocompleteEnabled(boolean enabled) {
        return ((AutoCompTextField)this.getEditorComponent()).setAutocompleteEnabled(enabled);
    }

    public void setFixedLocale(boolean f) {
        this.useFixedLocale = f;
        if (this.useFixedLocale) {
            Locale oldLocale = this.privateInputContext.getLocale();
            Logging.info("Using English input method");
            if (!this.privateInputContext.selectInputMethod(new Locale("en", "US"))) {
                Logging.warn("Unable to use English input method");
                this.useFixedLocale = false;
                if (oldLocale != null) {
                    Logging.info("Restoring input method to " + oldLocale);
                    if (!this.privateInputContext.selectInputMethod(oldLocale)) {
                        Logging.warn("Unable to restore input method to " + oldLocale);
                    }
                }
            }
        }
    }

    @Override
    public InputContext getInputContext() {
        if (this.useFixedLocale) {
            return this.privateInputContext;
        }
        return super.getInputContext();
    }

    @Override
    public void autoCompBefore(AutoCompEvent e) {
    }

    @Override
    public void autoCompPerformed(AutoCompEvent e) {
        this.autocomplete(e.getItem());
    }
}

