/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.util.Collection;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.JTable;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.properties.AbstractCopyAction;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class CopyAllKeyValueAction
extends AbstractCopyAction {
    public CopyAllKeyValueAction(JTable tagTable, IntFunction<String> keyFn, Supplier<Collection<? extends Tagged>> objectSp) {
        super(tagTable, keyFn, objectSp);
        this.putValue("Name", I18n.tr("Copy all Keys/Values", new Object[0]));
        this.putValue("ShortDescription", I18n.tr("Copy the key and value of all the tags to clipboard", new Object[0]));
        new ImageProvider("copy").getResource().attachImageIcon(this, true);
    }

    CopyAllKeyValueAction registerShortcut() {
        Shortcut sc = Shortcut.registerShortcut("system:copytags", I18n.tr("Edit: {0}", I18n.tr("Copy Tags", new Object[0])), 65535, 5000);
        MainApplication.registerActionShortcut(this, sc);
        sc.setAccelerator(this);
        return this;
    }

    @Override
    protected Collection<String> getString(Tagged p, String key) {
        return p.getKeys().entrySet().stream().map(kv -> new Tag((String)kv.getKey(), (String)kv.getValue()).toString()).collect(Collectors.toList());
    }
}

