/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FileSwitchDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Constants;

public final class IOUtils {
    @Deprecated
    public static final Charset CHARSET_UTF_8 = StandardCharsets.UTF_8;
    public static final String UTF_8 = StandardCharsets.UTF_8.name();

    private IOUtils() {
    }

    public static void close(Closeable ... objects) throws IOException {
        IOUtils.close(Arrays.asList(objects));
    }

    public static void close(Iterable<? extends Closeable> objects) throws IOException {
        Throwable th = null;
        for (Closeable closeable : objects) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Throwable t) {
                IOUtils.addSuppressed(th, t);
                if (th != null) continue;
                th = t;
            }
        }
        IOUtils.reThrow(th);
    }

    public static void closeWhileHandlingException(Closeable ... objects) {
        IOUtils.closeWhileHandlingException(Arrays.asList(objects));
    }

    public static void closeWhileHandlingException(Iterable<? extends Closeable> objects) {
        for (Closeable closeable : objects) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private static void addSuppressed(Throwable exception, Throwable suppressed) {
        if (exception != null && suppressed != null) {
            exception.addSuppressed(suppressed);
        }
    }

    public static Reader getDecodingReader(InputStream stream, Charset charSet) {
        CharsetDecoder charSetDecoder = charSet.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        return new BufferedReader(new InputStreamReader(stream, charSetDecoder));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Reader getDecodingReader(Class<?> clazz, String resource, Charset charSet) throws IOException {
        Reader reader;
        block3: {
            InputStream stream = null;
            boolean success = false;
            try {
                stream = clazz.getResourceAsStream(resource);
                Reader reader2 = IOUtils.getDecodingReader(stream, charSet);
                success = true;
                reader = reader2;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.close(stream);
                }
                throw throwable;
            }
            IOUtils.close(stream);
        }
        return reader;
    }

    public static void deleteFilesIgnoringExceptions(Directory dir, String ... files) {
        for (String name : files) {
            try {
                dir.deleteFile(name);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
    }

    public static void deleteFilesIgnoringExceptions(Path ... files) {
        IOUtils.deleteFilesIgnoringExceptions(Arrays.asList(files));
    }

    public static void deleteFilesIgnoringExceptions(Collection<? extends Path> files) {
        for (Path path : files) {
            if (path == null) continue;
            try {
                Files.delete(path);
            }
            catch (Throwable throwable) {}
        }
    }

    public static void deleteFilesIfExist(Path ... files) throws IOException {
        IOUtils.deleteFilesIfExist(Arrays.asList(files));
    }

    public static void deleteFilesIfExist(Collection<? extends Path> files) throws IOException {
        Throwable th = null;
        for (Path path : files) {
            try {
                if (path == null) continue;
                Files.deleteIfExists(path);
            }
            catch (Throwable t) {
                IOUtils.addSuppressed(th, t);
                if (th != null) continue;
                th = t;
            }
        }
        IOUtils.reThrow(th);
    }

    public static void rm(Path ... locations) throws IOException {
        LinkedHashMap<Path, Throwable> unremoved = IOUtils.rm(new LinkedHashMap<Path, Throwable>(), locations);
        if (!unremoved.isEmpty()) {
            StringBuilder b = new StringBuilder("Could not remove the following files (in the order of attempts):\n");
            for (Map.Entry<Path, Throwable> kv : unremoved.entrySet()) {
                b.append("   ").append(kv.getKey().toAbsolutePath()).append(": ").append(kv.getValue()).append("\n");
            }
            throw new IOException(b.toString());
        }
    }

    private static LinkedHashMap<Path, Throwable> rm(final LinkedHashMap<Path, Throwable> unremoved, Path ... locations) {
        if (locations != null) {
            for (Path location : locations) {
                if (location == null || !Files.exists(location, new LinkOption[0])) continue;
                try {
                    Files.walkFileTree(location, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                        @Override
                        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult postVisitDirectory(Path dir, IOException impossible) throws IOException {
                            assert (impossible == null);
                            try {
                                Files.delete(dir);
                            }
                            catch (IOException e) {
                                unremoved.put(dir, e);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            try {
                                Files.delete(file);
                            }
                            catch (IOException exc) {
                                unremoved.put(file, exc);
                            }
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                            if (exc != null) {
                                unremoved.put(file, exc);
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException impossible) {
                    throw new AssertionError("visitor threw exception", impossible);
                }
            }
        }
        return unremoved;
    }

    public static void reThrow(Throwable th) throws IOException {
        if (th != null) {
            if (th instanceof IOException) {
                throw (IOException)th;
            }
            IOUtils.reThrowUnchecked(th);
        }
    }

    public static void reThrowUnchecked(Throwable th) {
        if (th != null) {
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            if (th instanceof Error) {
                throw (Error)th;
            }
            throw new RuntimeException(th);
        }
    }

    public static void fsync(Path fileToSync, boolean isDir) throws IOException {
        try (FileChannel file = FileChannel.open(fileToSync, isDir ? StandardOpenOption.READ : StandardOpenOption.WRITE);){
            file.force(true);
        }
        catch (IOException ioe) {
            if (isDir) {
                assert (!(Constants.LINUX || Constants.MAC_OS_X)) : "On Linux and MacOSX fsyncing a directory should not throw IOException, we just don't want to rely on that in production (undocumented). Got: " + ioe;
                return;
            }
            throw ioe;
        }
    }

    public static boolean spins(Directory dir) throws IOException {
        if ((dir = FilterDirectory.unwrap(dir)) instanceof FileSwitchDirectory) {
            FileSwitchDirectory fsd = (FileSwitchDirectory)dir;
            return IOUtils.spins(fsd.getPrimaryDir()) || IOUtils.spins(fsd.getSecondaryDir());
        }
        if (dir instanceof RAMDirectory) {
            return false;
        }
        if (dir instanceof FSDirectory) {
            return IOUtils.spins(((FSDirectory)dir).getDirectory());
        }
        return true;
    }

    public static boolean spins(Path path) throws IOException {
        path = path.toRealPath(new LinkOption[0]);
        if (!Constants.LINUX) {
            return true;
        }
        try {
            return IOUtils.spinsLinux(path);
        }
        catch (Exception exc) {
            return true;
        }
    }

    static boolean spinsLinux(Path path) throws IOException {
        FileStore store = IOUtils.getFileStore(path);
        if ("tmpfs".equals(store.type())) {
            return false;
        }
        String devName = store.name();
        if (!devName.startsWith("/")) {
            return true;
        }
        devName = path.getRoot().resolve(devName).toRealPath(new LinkOption[0]).getFileName().toString();
        Path sysinfo = path.getRoot().resolve("sys").resolve("block");
        Path devsysinfo = null;
        int matchlen = 0;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(sysinfo);){
            for (Path device : stream) {
                String name = device.getFileName().toString();
                if (name.length() <= matchlen || !devName.startsWith(name)) continue;
                devsysinfo = device;
                matchlen = name.length();
            }
        }
        if (devsysinfo == null) {
            return true;
        }
        Path rotational = devsysinfo.resolve("queue").resolve("rotational");
        try (InputStream stream = Files.newInputStream(rotational, new OpenOption[0]);){
            boolean bl = stream.read() == 49;
            return bl;
        }
    }

    static FileStore getFileStore(Path path) throws IOException {
        FileStore store = Files.getFileStore(path);
        String mount = IOUtils.getMountPoint(store);
        FileStore sameMountPoint = null;
        for (FileStore fs : path.getFileSystem().getFileStores()) {
            if (!mount.equals(IOUtils.getMountPoint(fs))) continue;
            if (sameMountPoint == null) {
                sameMountPoint = fs;
                continue;
            }
            return store;
        }
        if (sameMountPoint != null) {
            return sameMountPoint;
        }
        return store;
    }

    static String getMountPoint(FileStore store) {
        String desc = store.toString();
        int index = desc.lastIndexOf(" (");
        if (index != -1) {
            return desc.substring(0, index);
        }
        return desc;
    }
}

