/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.frenchtreebank;

import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import opennlp.tools.parser.Constituent;
import opennlp.tools.parser.Parse;
import opennlp.tools.util.Span;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ConstitDocumentHandler
extends DefaultHandler {
    private static final String SENT_ELEMENT_NAME = "SENT";
    private static final String WORD_ELEMENT_NAME = "w";
    private static final String SENT_TYPE_NAME = "S";
    private final List<Parse> parses;
    private boolean insideSentenceElement;
    private final StringBuilder tokenBuffer = new StringBuilder();
    private final StringBuilder text = new StringBuilder();
    private int offset;
    private final Stack<Constituent> stack = new Stack();
    private final List<Constituent> cons = new LinkedList<Constituent>();
    private String cat;
    private String subcat;

    ConstitDocumentHandler(List<Parse> parses) {
        this.parses = parses;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String type = qName;
        if (SENT_ELEMENT_NAME.equals(qName)) {
            this.text.setLength(0);
            this.offset = 0;
            this.stack.clear();
            this.cons.clear();
            type = SENT_TYPE_NAME;
            this.insideSentenceElement = true;
        } else if (WORD_ELEMENT_NAME.equals(qName)) {
            String catint;
            String newSubcat;
            String newCat = attributes.getValue("cat");
            if (newCat != null && newCat.length() > 0) {
                this.cat = newCat;
            }
            if ((newSubcat = attributes.getValue("subcat")) != null && newSubcat.length() > 0) {
                this.subcat = newSubcat;
            }
            type = this.cat != null ? this.cat + (this.subcat != null ? this.subcat : "") : ((catint = attributes.getValue("catint")) != null ? this.cat + (catint != null ? catint : "") : this.cat + this.subcat);
        }
        this.stack.push(new Constituent(type, new Span(this.offset, this.offset)));
        this.tokenBuffer.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.tokenBuffer.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        boolean isCreateConstituent = true;
        if (this.insideSentenceElement) {
            int start;
            if (WORD_ELEMENT_NAME.equals(qName)) {
                String token = this.tokenBuffer.toString().trim();
                if (token.length() > 0) {
                    this.cons.add(new Constituent("TK", new Span(this.offset, this.offset + token.length())));
                    this.text.append(token).append(" ");
                    this.offset += token.length() + 1;
                } else {
                    isCreateConstituent = false;
                }
            }
            Constituent unfinishedCon = this.stack.pop();
            if (isCreateConstituent && (start = unfinishedCon.getSpan().getStart()) < this.offset) {
                this.cons.add(new Constituent(unfinishedCon.getLabel(), new Span(start, this.offset - 1)));
            }
            if (SENT_ELEMENT_NAME.equals(qName)) {
                String txt = this.text.toString();
                int tokenIndex = -1;
                Parse p = new Parse(txt, new Span(0, txt.length()), "TOP", 1.0, 0);
                for (int ci = 0; ci < this.cons.size(); ++ci) {
                    Constituent con = this.cons.get(ci);
                    String type = con.getLabel();
                    if (type.equals("TOP")) continue;
                    if ("TK".equals(type)) {
                        ++tokenIndex;
                    }
                    Parse c = new Parse(txt, con.getSpan(), type, 1.0, tokenIndex);
                    p.insert(c);
                }
                this.parses.add(p);
                this.insideSentenceElement = false;
            }
            this.tokenBuffer.setLength(0);
        }
    }
}

