/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.tools.StringTools;

public final class AnalyzedSentence {
    private final AnalyzedTokenReadings[] tokens;
    private final AnalyzedTokenReadings[] nonBlankTokens;
    private final int[] whPositions;
    private final Set<String> tokenSet;
    private final Set<String> lemmaSet;

    public AnalyzedSentence(AnalyzedTokenReadings[] tokens) {
        this.tokens = tokens;
        int whCounter = 0;
        int nonWhCounter = 0;
        int[] mapping = new int[tokens.length + 1];
        ArrayList<AnalyzedTokenReadings> l = new ArrayList<AnalyzedTokenReadings>();
        for (AnalyzedTokenReadings token : tokens) {
            if (!token.isWhitespace() || token.isSentenceStart() || token.isSentenceEnd() || token.isParagraphEnd()) {
                l.add(token);
                mapping[nonWhCounter] = whCounter;
                ++nonWhCounter;
            }
            ++whCounter;
        }
        this.whPositions = mapping;
        this.nonBlankTokens = l.toArray(new AnalyzedTokenReadings[l.size()]);
        this.tokenSet = this.getTokenSet(tokens);
        this.lemmaSet = this.getLemmaSet(tokens);
    }

    private AnalyzedSentence(AnalyzedTokenReadings[] tokens, int[] mapping, AnalyzedTokenReadings[] nonBlankTokens) {
        this.tokens = tokens;
        this.whPositions = mapping;
        this.nonBlankTokens = nonBlankTokens;
        this.tokenSet = this.getTokenSet(tokens);
        this.lemmaSet = this.getLemmaSet(tokens);
    }

    private Set<String> getTokenSet(AnalyzedTokenReadings[] tokens) {
        HashSet<String> tokenSet = new HashSet<String>();
        for (AnalyzedTokenReadings token : tokens) {
            tokenSet.add(token.getToken().toLowerCase());
        }
        return Collections.unmodifiableSet(tokenSet);
    }

    private Set<String> getLemmaSet(AnalyzedTokenReadings[] tokens) {
        HashSet<String> lemmaSet = new HashSet<String>();
        for (AnalyzedTokenReadings token : tokens) {
            for (AnalyzedToken lemmaTok : token.getReadings()) {
                if (lemmaTok.getLemma() != null) {
                    lemmaSet.add(lemmaTok.getLemma().toLowerCase());
                    continue;
                }
                lemmaSet.add(lemmaTok.getToken().toLowerCase());
            }
        }
        return Collections.unmodifiableSet(lemmaSet);
    }

    public AnalyzedSentence copy(AnalyzedSentence sentence) {
        AnalyzedTokenReadings[] copyTokens = new AnalyzedTokenReadings[sentence.getTokens().length];
        for (int i = 0; i < copyTokens.length; ++i) {
            AnalyzedTokenReadings analyzedTokens = sentence.getTokens()[i];
            copyTokens[i] = new AnalyzedTokenReadings(analyzedTokens.getReadings(), analyzedTokens.getStartPos());
            copyTokens[i].setHistoricalAnnotations(analyzedTokens.getHistoricalAnnotations());
            copyTokens[i].setChunkTags(analyzedTokens.getChunkTags());
            if (analyzedTokens.isImmunized()) {
                copyTokens[i].immunize();
            }
            if (analyzedTokens.isIgnoredBySpeller()) {
                copyTokens[i].ignoreSpelling();
            }
            copyTokens[i].setWhitespaceBefore(sentence.getTokens()[i].isWhitespaceBefore());
        }
        return new AnalyzedSentence(copyTokens, sentence.whPositions, sentence.getTokensWithoutWhitespace());
    }

    public AnalyzedTokenReadings[] getTokens() {
        return this.tokens;
    }

    public AnalyzedTokenReadings[] getTokensWithoutWhitespace() {
        return (AnalyzedTokenReadings[])this.nonBlankTokens.clone();
    }

    public int getOriginalPosition(int nonWhPosition) {
        return this.whPositions[nonWhPosition];
    }

    public String toString() {
        return this.toString(",");
    }

    public String toShortString(String readingDelimiter) {
        return this.toString(readingDelimiter, false);
    }

    public String getText() {
        StringBuilder sb = new StringBuilder();
        for (AnalyzedTokenReadings element : this.tokens) {
            sb.append(element.getToken());
        }
        return sb.toString();
    }

    String toTextString() {
        return this.getText();
    }

    public String toString(String readingDelimiter) {
        return this.toString(readingDelimiter, true);
    }

    private String toString(String readingDelimiter, boolean includeChunks) {
        StringBuilder sb = new StringBuilder();
        for (AnalyzedTokenReadings element : this.tokens) {
            if (!element.isWhitespace()) {
                sb.append(element.getToken());
                sb.append('[');
            }
            Iterator<AnalyzedToken> iterator = element.iterator();
            while (iterator.hasNext()) {
                AnalyzedToken token = iterator.next();
                String posTag = token.getPOSTag();
                if (element.isSentenceStart()) {
                    sb.append("<S>");
                    continue;
                }
                if ("SENT_END".equals(posTag)) {
                    sb.append("</S>");
                    continue;
                }
                if ("PARA_END".equals(posTag)) {
                    sb.append("<P/>");
                    continue;
                }
                if (posTag == null && !includeChunks) {
                    sb.append(token.getToken());
                    continue;
                }
                if (element.isWhitespace()) continue;
                sb.append(token);
                if (!iterator.hasNext()) continue;
                sb.append(readingDelimiter);
            }
            if (!element.isWhitespace()) {
                if (includeChunks && element.getChunkTags().size() > 0) {
                    sb.append(',');
                    sb.append(StringUtils.join(element.getChunkTags(), (String)"|"));
                }
                if (element.isImmunized()) {
                    sb.append("{!}");
                }
                sb.append(']');
                continue;
            }
            sb.append(' ');
        }
        return sb.toString();
    }

    public String getAnnotations() {
        StringBuilder sb = new StringBuilder(40);
        sb.append("Disambiguator log: \n");
        for (AnalyzedTokenReadings element : this.tokens) {
            if (element.isWhitespace() || "".equals(element.getHistoricalAnnotations())) continue;
            sb.append(element.getHistoricalAnnotations());
            sb.append('\n');
        }
        return sb.toString();
    }

    public Set<String> getTokenSet() {
        return this.tokenSet;
    }

    public Set<String> getLemmaSet() {
        return this.lemmaSet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        AnalyzedSentence other = (AnalyzedSentence)o;
        return Arrays.equals(this.nonBlankTokens, other.nonBlankTokens) && Arrays.equals(this.tokens, other.tokens) && Arrays.equals(this.whPositions, other.whPositions);
    }

    public int hashCode() {
        return Objects.hash(this.nonBlankTokens, this.tokens, this.whPositions);
    }

    public boolean hasParagraphEndMark(Language lang) {
        return StringTools.isParagraphEnd(this.getText(), lang.getSentenceTokenizer().singleLineBreaksMarksPara());
    }
}

