/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.neuralnetwork;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.ScoredConfusionSet;
import org.languagetool.rules.neuralnetwork.Classifier;
import org.languagetool.rules.neuralnetwork.SingleLayerClassifier;
import org.languagetool.rules.neuralnetwork.Suggestion;
import org.languagetool.rules.neuralnetwork.TwoLayerClassifier;
import org.languagetool.rules.neuralnetwork.Word2VecModel;
import org.languagetool.tools.Tools;

public class NeuralNetworkRule
extends Rule {
    private static final int CONTEXT_LENGTH = 5;
    private static final boolean DEBUG = false;
    private final List<String> subjects;
    private final List<Optional<String>> descriptions;
    private final String id;
    private final Classifier classifier;
    private double minScore;

    public NeuralNetworkRule(ResourceBundle messages, Language language, ScoredConfusionSet confusionSet, Word2VecModel word2VecModel) throws IOException {
        super(messages);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        this.subjects = confusionSet.getConfusionTokens();
        this.descriptions = confusionSet.getTokenDescriptions();
        this.minScore = confusionSet.getScore();
        try {
            Classifier tmpClassifier;
            InputStream W1Stream = this.streamFor(word2VecModel.getPath(), "W_fc1.txt");
            InputStream b1Stream = this.streamFor(word2VecModel.getPath(), "b_fc1.txt");
            try {
                InputStream W2Stream = this.streamFor(word2VecModel.getPath(), "W_fc2.txt");
                InputStream b2Stream = this.streamFor(word2VecModel.getPath(), "b_fc2.txt");
                tmpClassifier = new TwoLayerClassifier(word2VecModel.getEmbedding(), W1Stream, b1Stream, W2Stream, b2Stream);
            }
            catch (FileNotFoundException e) {
                tmpClassifier = new SingleLayerClassifier(word2VecModel.getEmbedding(), W1Stream, b1Stream);
            }
            this.classifier = tmpClassifier;
        }
        catch (FileNotFoundException e) {
            throw new IOException("Weights for confusion set " + confusionSet.toString() + " are missing", e);
        }
        this.id = this.createId(language);
    }

    public NeuralNetworkRule(ResourceBundle messages, Language language, ScoredConfusionSet confusionSet, Classifier classifier) {
        super(messages);
        super.setCategory(Categories.TYPOS.getCategory(messages));
        this.subjects = confusionSet.getConfusionTokens();
        this.descriptions = confusionSet.getTokenDescriptions();
        this.minScore = confusionSet.getScore();
        this.classifier = classifier;
        this.id = this.createId(language);
    }

    @NotNull
    private String createId(Language language) {
        return language.getShortCode().toUpperCase() + "_" + this.subjects.get(0) + "_VS_" + this.subjects.get(1) + "_NEURALNETWORK";
    }

    private InputStream streamFor(File path, String filename) throws FileNotFoundException {
        String folderName = String.join((CharSequence)"_", this.subjects);
        return new FileInputStream(path.getPath() + File.separator + "neuralnetwork" + File.separator + folderName + File.separator + filename);
    }

    public List<String> getSubjects() {
        return this.subjects;
    }

    protected double getMinScore() {
        return this.minScore;
    }

    public void setMinScore(double minScore) {
        this.minScore = minScore;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return "Possible Typo '" + this.getSubjects().get(0) + "'/'" + this.getSubjects().get(1) + "'";
    }

    private Suggestion getSuggestion(float[] y) {
        boolean unsure;
        String suggestion;
        if (y[0] > y[1]) {
            suggestion = this.getSubjects().get(0);
            unsure = !((double)y[0] > this.getMinScore()) || !((double)y[1] < -this.getMinScore());
        } else {
            suggestion = this.getSubjects().get(1);
            unsure = !((double)y[1] > this.getMinScore()) || !((double)y[0] < -this.getMinScore());
        }
        return new Suggestion(suggestion, unsure);
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        for (int i = 1; i < tokens.length; ++i) {
            String[] context;
            float[] y;
            Suggestion suggestion;
            String token = tokens[i].getToken();
            if (!this.getSubjects().contains(token) || (suggestion = this.getSuggestion(y = this.classifier.getScores(context = this.getContext(tokens, i)))).matches(token) || suggestion.isUnsure()) continue;
            ruleMatches.add(this.createRuleMatch(tokens[i], suggestion, y));
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @NotNull
    private String[] getContext(AnalyzedTokenReadings[] tokens, int center) {
        int i;
        String[] context = new String[4];
        for (i = 0; i < 2; ++i) {
            context[i] = NeuralNetworkRule.safeGetToken(tokens, center - 2 + i);
        }
        for (i = 0; i < 2; ++i) {
            context[2 + i] = NeuralNetworkRule.safeGetToken(tokens, center + 1 + i);
        }
        return context;
    }

    private static String safeGetToken(AnalyzedTokenReadings[] arr, int i) {
        if (i <= 0 || i >= arr.length) {
            return ".";
        }
        return arr[i].getToken();
    }

    @NotNull
    private RuleMatch createRuleMatch(AnalyzedTokenReadings token, Suggestion suggestion, float[] y) {
        String msg = this.getMessage(suggestion, y);
        int pos = token.getStartPos();
        RuleMatch ruleMatch = new RuleMatch(this, pos, pos + token.getToken().length(), msg);
        ruleMatch.setSuggestedReplacement(suggestion.toString());
        return ruleMatch;
    }

    @NotNull
    private String getMessage(Suggestion suggestion, float[] y) {
        int suggestionIndex = suggestion.matches(this.subjects.get(0)) ? 0 : 1;
        int wrongWordIndex = (suggestionIndex + 1) % 2;
        String msg = this.descriptions.get(suggestionIndex).isPresent() && this.descriptions.get(wrongWordIndex).isPresent() ? Tools.i18n(this.messages, "neural_network_suggest_with_description", this.subjects.get(suggestionIndex), this.descriptions.get(suggestionIndex).get(), this.subjects.get(wrongWordIndex), this.descriptions.get(wrongWordIndex).get()) : Tools.i18n(this.messages, "neural_network_suggest", this.subjects.get(suggestionIndex), this.subjects.get(wrongWordIndex));
        if (suggestion.isUnsure()) {
            msg = "(low certainty) " + msg;
        }
        return msg;
    }

    private String certaintiesToString(float[] y) {
        return String.format(Locale.US, "[%4.2f, %4.2f]", Float.valueOf(y[0]), Float.valueOf(y[1]));
    }
}

