/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.segment.srx;

import java.util.ArrayList;
import java.util.List;
import net.loomchild.segment.srx.LanguageMap;
import net.loomchild.segment.srx.LanguageRule;
import net.loomchild.segment.srx.SrxDocumentCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SrxDocument {
    public static final boolean DEFAULT_CASCADE = true;
    private boolean cascade;
    private List<LanguageMap> languageMapList;
    private SrxDocumentCache cache;

    public SrxDocument(boolean cascade) {
        this.cascade = cascade;
        this.languageMapList = new ArrayList<LanguageMap>();
        this.cache = new SrxDocumentCache();
    }

    public SrxDocument() {
        this(true);
    }

    public void setCascade(boolean cascade) {
        this.cascade = cascade;
    }

    public boolean getCascade() {
        return this.cascade;
    }

    public void addLanguageMap(String pattern, LanguageRule languageRule) {
        LanguageMap languageMap = new LanguageMap(pattern, languageRule);
        this.languageMapList.add(languageMap);
    }

    public List<LanguageMap> getLanguageMapList() {
        return this.languageMapList;
    }

    public List<LanguageRule> getLanguageRuleList(String languageCode) {
        ArrayList<LanguageRule> matchingLanguageRuleList = new ArrayList<LanguageRule>();
        for (LanguageMap languageMap : this.languageMapList) {
            if (!languageMap.matches(languageCode)) continue;
            matchingLanguageRuleList.add(languageMap.getLanguageRule());
            if (this.cascade) continue;
            break;
        }
        return matchingLanguageRuleList;
    }

    public SrxDocumentCache getCache() {
        return this.cache;
    }
}

