/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.languagemodel;

import edu.berkeley.nlp.lm.io.LmReaders;
import edu.berkeley.nlp.lm.map.NgramMapWrapper;
import edu.berkeley.nlp.lm.util.LongRef;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.languagetool.Experimental;
import org.languagetool.languagemodel.BaseLanguageModel;

@Experimental
public class BerkeleyRawLanguageModel
extends BaseLanguageModel {
    private final NgramMapWrapper<String, LongRef> map;

    public BerkeleyRawLanguageModel(File berkeleyLm) {
        if (!berkeleyLm.isFile()) {
            throw new RuntimeException("You need to specify a BerkeleyLM file: " + berkeleyLm);
        }
        File vocabFile = new File(berkeleyLm.getParent(), "vocab_cs.gz");
        if (!vocabFile.exists()) {
            throw new RuntimeException("No vocabulary file 'vocab_cs.gz' found in the BerkeleyLM directory: " + vocabFile);
        }
        this.map = LmReaders.readNgramMapFromBinary((String)berkeleyLm.getAbsolutePath(), (String)vocabFile.getAbsolutePath());
    }

    @Override
    public long getCount(List<String> tokens) {
        LongRef count = (LongRef)this.map.get(tokens);
        long result = count == null ? 0L : count.asLong();
        return result;
    }

    @Override
    public long getCount(String token1) {
        return this.getCount(Arrays.asList(token1));
    }

    @Override
    public long getTotalTokenCount() {
        return this.map.getMapForOrder(1).size();
    }

    @Override
    public void close() {
    }
}

