/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.FloatLongHashMap;
import com.carrotsearch.hppc.HashOrderMixing;

public class FloatLongScatterMap
extends FloatLongHashMap {
    public FloatLongScatterMap() {
        this(4);
    }

    public FloatLongScatterMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public FloatLongScatterMap(int expectedElements, double loadFactor) {
        super(expectedElements, loadFactor, HashOrderMixing.none());
    }

    @Override
    protected int hashKey(float key) {
        return BitMixer.mixPhi(key);
    }

    public static FloatLongScatterMap from(float[] keys, long[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        FloatLongScatterMap map = new FloatLongScatterMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }
}

