/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class AnalyzedToken {
    private final String token;
    private final String posTag;
    private final String lemma;
    private final String lemmaOrToken;
    private boolean isWhitespaceBefore;
    private boolean hasNoPOSTag;

    public AnalyzedToken(String token, String posTag, String lemma) {
        this.token = Objects.requireNonNull(token, "token cannot be null");
        this.posTag = posTag;
        this.lemma = lemma;
        this.lemmaOrToken = lemma == null ? token : lemma;
        this.hasNoPOSTag = posTag == null || "SENT_END".equals(posTag) || "PARA_END".equals(posTag);
    }

    public String getToken() {
        return this.token;
    }

    @Nullable
    public String getPOSTag() {
        return this.posTag;
    }

    @Nullable
    public String getLemma() {
        return this.lemma;
    }

    public void setWhitespaceBefore(boolean whitespaceBefore) {
        this.isWhitespaceBefore = whitespaceBefore;
    }

    public boolean isWhitespaceBefore() {
        return this.isWhitespaceBefore;
    }

    public boolean matches(AnalyzedToken an) {
        if (this.equals(an)) {
            return true;
        }
        if (an.getToken().isEmpty() && an.getLemma() == null && an.getPOSTag() == null) {
            return false;
        }
        boolean found = true;
        if (!an.getToken().isEmpty()) {
            found = an.getToken().equals(this.token);
        }
        if (an.getLemma() != null) {
            found &= an.getLemma().equals(this.lemma);
        }
        if (an.getPOSTag() != null) {
            found &= an.getPOSTag().equals(this.posTag);
        }
        return found;
    }

    public boolean hasNoTag() {
        return this.hasNoPOSTag;
    }

    public void setNoPOSTag(boolean noTag) {
        this.hasNoPOSTag = noTag;
    }

    public String toString() {
        return this.lemmaOrToken + '/' + this.posTag;
    }

    public int hashCode() {
        return Objects.hash(this.isWhitespaceBefore, this.lemma, this.posTag, this.token);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        AnalyzedToken other = (AnalyzedToken)o;
        return Objects.equals(this.token, other.token) && Objects.equals(this.posTag, other.posTag) && Objects.equals(this.lemma, other.lemma) && Objects.equals(this.isWhitespaceBefore, other.isWhitespaceBefore);
    }
}

