/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.logging;

import org.mariadb.jdbc.internal.logging.Logger;
import org.mariadb.jdbc.internal.logging.NoLogger;
import org.mariadb.jdbc.internal.logging.Slf4JLogger;

public class LoggerFactory {
    private static final Logger NO_LOGGER = new NoLogger();
    private static Boolean hasToLog = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(boolean mustLog) {
        if (hasToLog != null && hasToLog == mustLog || !mustLog) return;
        Class<LoggerFactory> clazz = LoggerFactory.class;
        synchronized (LoggerFactory.class) {
            if (hasToLog != null && hasToLog == mustLog) return;
            try {
                Class.forName("org.slf4j.LoggerFactory");
                hasToLog = Boolean.TRUE;
            }
            catch (ClassNotFoundException classNotFound) {
                System.out.println("Logging cannot be activated, missing slf4j dependency");
                hasToLog = Boolean.FALSE;
            }
            return;
        }
    }

    public static Logger getLogger(Class<?> clazz) {
        if (hasToLog != null && hasToLog.booleanValue()) {
            return new Slf4JLogger(org.slf4j.LoggerFactory.getLogger(clazz));
        }
        return NO_LOGGER;
    }
}

