/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;

public final class RemoteRuleMetrics {
    private static final double[] LATENCY_BUCKETS = new double[]{0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.07, 0.08, 0.09, 0.1, 0.11, 0.12, 0.13, 0.14, 0.15, 0.16, 0.17, 0.18, 0.19, 0.2, 0.22, 0.24, 0.26, 0.28, 0.3, 0.32, 0.34, 0.36, 0.38, 0.4, 0.42, 0.44, 0.46, 0.48, 0.5, 0.52, 0.54, 0.56, 0.58, 0.6, 0.62, 0.64, 0.66, 0.68, 0.7, 0.72, 0.74, 0.76, 0.78, 0.8, 0.82, 0.84, 0.86, 0.88, 0.9, 0.92, 0.94, 0.96, 0.98, 1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2.0, 2.1, 2.2, 2.3, 2.4, 2.5, 2.6, 2.7, 2.8, 2.9, 3.0, 3.1, 3.2, 3.3, 3.4, 3.5, 3.6, 3.7, 3.8, 3.9, 4.0, 4.1, 4.2, 4.3, 4.4, 4.5, 4.6, 4.7, 4.8, 4.9, 5.0, 5.5, 6.0, 6.5, 7.0, 7.5, 8.0, 8.5, 9.0, 9.5, 10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0};
    private static final double[] SIZE_BUCKETS = new double[]{25.0, 50.0, 100.0, 150.0, 200.0, 250.0, 300.0, 400.0, 500.0, 750.0, 1000.0, 2000.0, 3000.0, 4000.0, 5000.0, 7500.0, 10000.0, 15000.0, 20000.0, 30000.0, 40000.0};
    private static final Counter retries = (Counter)((Counter.Builder)Counter.build((String)"languagetool_remote_rule_retries_total", (String)"Amount of retries for the given rule").labelNames(new String[]{"rule_id"})).register();
    private static final Counter downtime = (Counter)((Counter.Builder)Counter.build((String)"languagetool_remote_rule_downtime_seconds_total", (String)"Time remote rules were deactivated because of errors").labelNames(new String[]{"rule_id"})).register();
    private static final Histogram requestLatency = (Histogram)((Histogram.Builder)Histogram.build((String)"languagetool_remote_rule_request_latency_seconds", (String)"Request duration summary").labelNames(new String[]{"rule_id", "result"})).buckets(LATENCY_BUCKETS).register();
    private static final Histogram requestThroughput = (Histogram)((Histogram.Builder)Histogram.build((String)"languagetool_remote_rule_request_throughput_characters", (String)"Request size summary").labelNames(new String[]{"rule_id", "result"})).buckets(SIZE_BUCKETS).register();
    private static final Gauge failures = (Gauge)((Gauge.Builder)Gauge.build((String)"languagetool_remote_rule_consecutive_failures", (String)"Amount of consecutive failures").labelNames(new String[]{"rule_id"})).register();
    private static final Gauge up = (Gauge)((Gauge.Builder)Gauge.build((String)"languagetool_remote_rule_up", (String)"Status of remote rule").labelNames(new String[]{"rule_id"})).register();

    private RemoteRuleMetrics() {
        throw new IllegalStateException("RemoteRuleMetrics should only be used via static methods.");
    }

    public static void request(String rule, int numRetries, long nanoseconds, long characters, RequestResult result) {
        ((Histogram.Child)requestLatency.labels(new String[]{rule, result.name().toLowerCase()})).observe((double)nanoseconds / 1.0E9);
        ((Histogram.Child)requestThroughput.labels(new String[]{rule, result.name().toLowerCase()})).observe((double)characters);
        ((Counter.Child)retries.labels(new String[]{rule})).inc((double)numRetries);
    }

    public static void failures(String rule, int count) {
        ((Gauge.Child)failures.labels(new String[]{rule})).set((double)count);
    }

    public static void up(String rule, boolean isUp) {
        ((Gauge.Child)up.labels(new String[]{rule})).set(isUp ? 1.0 : 0.0);
    }

    public static void downtime(String rule, long milliseconds) {
        ((Counter.Child)downtime.labels(new String[]{rule})).inc((double)milliseconds / 1000.0);
    }

    public static enum RequestResult {
        SUCCESS,
        SKIPPED,
        TIMEOUT,
        INTERRUPTED,
        DOWN,
        ERROR;

    }
}

